/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.io.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.profiles.Activation;
import org.apache.maven.profiles.ActivationFile;
import org.apache.maven.profiles.ActivationOS;
import org.apache.maven.profiles.ActivationProperty;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.Repository;
import org.apache.maven.profiles.RepositoryBase;
import org.apache.maven.profiles.RepositoryPolicy;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProfilesJDOMWriter {
    private DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private String lineSeparator = "\n";

    protected Element findAndReplaceProperties(Counter counter, Element parent, String name, Map props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.keySet().iterator();
            Counter innerCounter = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                String key = (String)it.next();
                this.findAndReplaceSimpleElement(innerCounter, element, key, (String)props.get(key), null);
            }
            ArrayList lst = new ArrayList(props.keySet());
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String key = elem.getName();
                if (lst.contains(key)) continue;
                it.remove();
            }
        }
        return element;
    }

    protected Element findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text, String defaultValue) {
        Element element;
        if (defaultValue != null && text != null && defaultValue.equals(text) && ((element = parent.getChild(name, parent.getNamespace())) != null && defaultValue.equals(element.getText()) || element == null)) {
            return element;
        }
        boolean shouldExist = text != null && text.trim().length() > 0;
        Element element2 = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element2.setText(text);
        }
        return element2;
    }

    protected Element findAndReplaceSimpleLists(Counter counter, Element parent, Collection list, String parentName, String childName) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = (String)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childName, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
        return element;
    }

    protected Element findAndReplaceXpp3DOM(Counter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            this.replaceXpp3DOM(element, dom, new Counter(counter.getDepth() + 1));
        }
        return element;
    }

    protected void insertAtPreferredLocation(Element parent, Element child, Counter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter <= counter.getCurrentIndex()) {
            Object next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = (Text)lastText.clone();
        } else {
            String starter = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter = starter + "    ";
            }
            lastText = this.factory.text(starter);
        }
        if (parent.getContentSize() == 0) {
            Text finalText = (Text)lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - "    ".length()));
            parent.addContent(contentIndex, (Content)finalText);
        }
        parent.addContent(contentIndex, (Content)child);
        parent.addContent(contentIndex, (Content)lastText);
    }

    protected void iterateProfile(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, Counter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] childs = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChilds = new ArrayList<Xpp3Dom>();
            for (int i = 0; i < childs.length; ++i) {
                domChilds.add(childs[i]);
            }
            boolean domIndex = false;
            ListIterator it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                Iterator it2 = domChilds.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChilds.remove(corrDom);
                    this.replaceXpp3DOM(elem, corrDom, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                parent.removeContent((Content)elem);
            }
            for (Xpp3Dom dm : domChilds) {
                Element elem = this.factory.element(dm.getName(), parent.getNamespace());
                this.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                this.replaceXpp3DOM(elem, dm, new Counter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            parent.setText(parentDom.getValue());
        }
    }

    protected void updateActivation(Activation value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !value.isActiveByDefault() ? null : String.valueOf(value.isActiveByDefault()), "false");
            this.findAndReplaceSimpleElement(innerCount, root, "jdk", value.getJdk(), null);
            this.updateActivationOS(value.getOs(), "os", innerCount, root);
            this.updateActivationProperty(value.getProperty(), "property", innerCount, root);
            this.updateActivationFile(value.getFile(), "file", innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "missing", value.getMissing(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "exists", value.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "family", value.getFamily(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "arch", value.getArch(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "value", value.getValue(), null);
        }
    }

    protected Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (element != null && shouldExist) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name, parent.getNamespace());
            this.insertAtPreferredLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf((Content)element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().length() == 0) {
                parent.removeContent((Content)txt);
            }
            parent.removeContent((Content)element);
        }
        return element;
    }

    protected void updateProfile(Profile value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.updateActivation(value.getActivation(), "activation", innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
    }

    protected void updateProfilesRoot(ProfilesRoot value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.iterateProfile(innerCount, root, value.getProfiles(), "profiles", "profile");
        this.findAndReplaceSimpleLists(innerCount, root, value.getActiveProfiles(), "activeProfiles", "activeProfile");
    }

    protected void updateRepository(Repository value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "enabled", value.isEnabled() ? null : String.valueOf(value.isEnabled()), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", value.getUpdatePolicy(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", value.getChecksumPolicy(), null);
        }
    }

    public void write(ProfilesRoot profilesXml, Document document, OutputStream stream) throws IOException {
        this.updateProfilesRoot(profilesXml, "profilesXml", new Counter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat().setIndent("    ").setLineSeparator(System.getProperty("line.separator")));
        outputter.output(document, stream);
    }

    public void write(ProfilesRoot profilesXml, Document document, OutputStreamWriter writer) throws IOException {
        Format format = Format.getRawFormat().setEncoding(writer.getEncoding()).setLineSeparator(System.getProperty("line.separator"));
        this.write(profilesXml, document, writer, format);
    }

    public void write(ProfilesRoot profilesXml, Document document, Writer writer, Format jdomFormat) throws IOException {
        this.updateProfilesRoot(profilesXml, "profilesXml", new Counter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(jdomFormat);
        outputter.output(document, writer);
    }

    public class Counter {
        private int currentIndex = 0;
        private int level;

        public Counter(int depthLevel) {
            this.level = depthLevel;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }
    }
}

