/*
 * Decompiled with CFR 0.152.
 */
package org.joni.util;

import java.util.Iterator;
import org.joni.exception.InternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Hash<V>
implements Iterable<V> {
    protected OniHashEntry<V>[] table;
    protected int size;
    private static final int[] PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int INITIAL_CAPACITY = PRIMES[0];
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MIN_CAPA = 8;
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;

    public Hash() {
        this.table = new OniHashEntry[INITIAL_CAPACITY];
    }

    public Hash(int size) {
        int i = 0;
        int n = 8;
        while (i < PRIMES.length) {
            if (n > size) {
                this.table = new OniHashEntry[PRIMES[i]];
                return;
            }
            ++i;
            n <<= 1;
        }
        throw new InternalException("run out of polynomials");
    }

    public final int size() {
        return this.size;
    }

    protected final void checkResize() {
        if (this.size == this.table.length) {
            int forSize = this.table.length + 1;
            int i = 0;
            int newCapacity = 8;
            while (i < PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(PRIMES[i]);
                    return;
                }
                ++i;
                newCapacity <<= 1;
            }
            return;
        }
    }

    protected final void resize(int newCapacity) {
        OniHashEntry<V>[] oldTable = this.table;
        OniHashEntry[] newTable = new OniHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            OniHashEntry<V> entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                OniHashEntry next = entry.next;
                int i = Hash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next;
            }
        }
        this.table = newTable;
    }

    protected static int bucketIndex(int h, int length) {
        return h % length;
    }

    protected static int hashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    @Override
    public Iterator<V> iterator() {
        return new OniHashIterator();
    }

    public OniHashIterator entryIterator() {
        return new OniHashIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OniHashEntryIterator
    implements Iterator<OniHashEntry<V>> {
        OniHashEntry<V> next;
        OniHashEntry<V> current;
        int index;

        public OniHashEntryIterator() {
            if (Hash.this.size > 0) {
                OniHashEntry<V>[] t = Hash.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public OniHashEntry<V> next() {
            OniHashEntry e = this.next;
            this.next = e.next;
            if (this.next == null) {
                OniHashEntry<V>[] t = Hash.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            throw new InternalException("not supported operation exception");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OniHashIterator
    implements Iterator<V> {
        OniHashEntry<V> next;
        OniHashEntry<V> current;
        int index;

        public OniHashIterator() {
            if (Hash.this.size > 0) {
                OniHashEntry<V>[] t = Hash.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            OniHashEntry e = this.next;
            this.next = e.next;
            if (this.next == null) {
                OniHashEntry<V>[] t = Hash.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e.value;
        }

        @Override
        public void remove() {
            throw new InternalException("not supported operation exception");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OniHashEntry<V> {
        final int hash;
        OniHashEntry<V> next;
        public V value;

        OniHashEntry(int hash, OniHashEntry<V> next, V value) {
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }
}

