/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.AbilitiesPanel;
import org.netbeans.modules.mobility.project.ui.FNode;
import org.netbeans.modules.mobility.project.ui.FileMonitor;
import org.netbeans.modules.mobility.project.ui.LazyInitFilterNode;
import org.netbeans.modules.mobility.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.mobility.project.ui.MissingFileDetector;
import org.netbeans.modules.mobility.project.ui.actions.RemoveResourceAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.actions.CopyAction;
import org.openide.actions.EditAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

final class OneResourceNode
extends LazyInitFilterNode
implements FileMonitor {
    static final String ARCHIVE_ICON = "org/netbeans/modules/mobility/project/ui/resources/libraries.gif";
    private final File root;
    private ProjectConfiguration config;
    private boolean multi;

    OneResourceNode(J2MEProject project, ProjectConfiguration config, VisualClassPathItem item, File root, boolean multi) {
        this(Lookups.fixed((Object[])new Object[]{project, AbilitiesPanel.hintInstance, config == null ? project.getConfigurationHelper().getActiveConfiguration() : config, item}), root);
        this.config = config;
        this.setValue("VCPI", item);
        this.setValue("resource", Boolean.TRUE);
        this.multi = multi;
        if (multi) {
            this.setDisplayName(NbBundle.getMessage(OneResourceNode.class, (String)"LBL_JarFromMultiJarLibrary", (Object[])new Object[]{item.getDisplayName(), root.getName()}));
        } else {
            this.setDisplayName(item.getDisplayName());
        }
    }

    private OneResourceNode(Lookup lookup, File root) {
        super(lookup);
        if (root == null) {
            throw new NullPointerException("Null root");
        }
        this.root = root;
        this.setValue("resource", Boolean.TRUE);
        this.setValue("error", !root.exists());
        this.change();
        MissingFileDetector.register(root, this);
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        return new Node.PropertySet[]{set};
    }

    public Action[] getActions(boolean context) {
        Action[] actionArray;
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (project != null);
        boolean showActions = project.canModifyLibraries(this.config);
        if (showActions) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = RemoveResourceAction.getStaticInstance();
            actionArray = actionArray2;
            actionArray2[1] = SystemAction.get(CopyAction.class);
        } else {
            Action[] actionArray3 = new Action[1];
            actionArray = actionArray3;
            actionArray3[0] = SystemAction.get(CopyAction.class);
        }
        return actionArray;
    }

    public Image getIcon(int type) {
        return ((VisualClassPathItem)this.getLookup().lookup(VisualClassPathItem.class)).getImage();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private void change() {
        boolean changeChildren;
        boolean doesNotExist = !this.root.exists();
        this.setValue("error", doesNotExist);
        boolean bl = changeChildren = !this.isLazyChildren() && FilterNode.Children.LEAF == this.getChildren() && !doesNotExist;
        if (changeChildren) {
            this.reinit();
        }
    }

    @Override
    public void fileCreated() {
        this.change();
    }

    @Override
    public void fileDeleted() {
        this.change();
    }

    @Override
    public void fileChanged() {
        this.reinit();
    }

    @Override
    protected FilterNode.Children createRealChildren() {
        FileObject file;
        if (this.root == null) {
            return null;
        }
        try {
            file = FileUtil.toFileObject((File)this.root);
        }
        catch (NullPointerException e) {
            IllegalStateException ise = new IllegalStateException("NPE from toFileObject for " + this.root, e);
            throw ise;
        }
        assert (this.root != null);
        if (file != null) {
            Node nd = this.findNodeForRoot(file);
            return new RemoveActionsFilterChildren(nd);
        }
        return new FilterNode.Children((Node)new AbstractNode((Children)this.createLazyChildren()));
    }

    private Node findNodeForRoot(FileObject file) {
        Object result = null;
        try {
            if ("jar".equals(file.getURL().getProtocol())) {
                ImageIcon openedIcon;
                file = FileUtil.getArchiveFile((FileObject)file);
                ImageIcon icon = openedIcon = ImageUtilities.loadImageIcon((String)ARCHIVE_ICON, (boolean)false);
                result = PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(file, file.getNameExt(), icon, openedIcon));
            } else if (file.isFolder()) {
                result = DataFolder.findFolder((FileObject)file).getNodeDelegate();
            } else {
                try {
                    result = DataObject.find((FileObject)file).getNodeDelegate();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            VisualClassPathItem item = (VisualClassPathItem)this.getLookup().lookup(VisualClassPathItem.class);
            if (item != null) {
                Lookup lookup = this.getLookup();
                J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
                assert (project != null);
                boolean usingDefaultLibs = project.isUsingDefaultLibs(this.config);
                result.setValue("VCPI", (Object)item);
                result = new FNode((Node)result, lookup, usingDefaultLibs ? null : new Action[]{}, item);
                result.setDisplayName(item.getDisplayName());
                result.setValue("gray", (Object)usingDefaultLibs);
                result.setValue("resource", (Object)"Resource");
            }
            return result;
        }
        catch (Exception e) {
            return new AbstractNode((Children)this.createLazyChildren());
        }
    }

    private static final class RemoveActionsFilterChildren
    extends FilterNode.Children {
        RemoveActionsFilterChildren(Node orig) {
            super(orig);
        }

        protected Node copyNode(Node node) {
            return new RemoveActionsFilterNode(node);
        }
    }

    private static final class RemoveActionsFilterNode
    extends FilterNode {
        RemoveActionsFilterNode(Node n) {
            super(n);
        }

        public Action[] getActions(boolean ignored) {
            LinkedList<SystemAction> result = new LinkedList<SystemAction>();
            if (this.getLookup().lookupItem(new Lookup.Template(OpenCookie.class)) != null) {
                result.add(SystemAction.get(OpenAction.class));
            }
            if (this.getLookup().lookupItem(new Lookup.Template(EditCookie.class)) != null) {
                result.add(SystemAction.get(EditAction.class));
            }
            if (this.getLookup().lookupItem(new Lookup.Template(ViewCookie.class)) != null) {
                result.add(SystemAction.get(ViewAction.class));
            }
            if (!result.isEmpty()) {
                result.add(null);
            }
            result.add(SystemAction.get(ToolsAction.class));
            result.add(SystemAction.get(PropertiesAction.class));
            Action[] actions = result.toArray(new Action[result.size()]);
            return actions;
        }
    }

    private class PathProperty
    extends PropertySupport.ReadOnly<String> {
        PathProperty() {
            super("path", String.class, NbBundle.getMessage(NameProperty.class, (String)"LBL_LibraryPathProperty"), NbBundle.getMessage(NameProperty.class, (String)"DESC_LibraryPathProperty"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return OneResourceNode.this.root.getPath();
        }
    }

    private class NameProperty
    extends PropertySupport.ReadOnly<String> {
        NameProperty() {
            super("name", String.class, NbBundle.getMessage(NameProperty.class, (String)"LBL_LibraryNameProperty"), NbBundle.getMessage(NameProperty.class, (String)"DESC_LibraryNameProperty"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            VisualClassPathItem item = (VisualClassPathItem)OneResourceNode.this.getLookup().lookup(VisualClassPathItem.class);
            if (item.getType() == 0 || item.getType() == 2) {
                String s = item.getRawText();
                int ix = s.lastIndexOf(47);
                if (ix > 0) {
                    s = s.substring(ix);
                }
                return s;
            }
            return item.getDisplayName();
        }
    }
}

