/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.actions.Single;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class AddConfigurationAction
extends Single<Node> {
    private AddConfigurationAction() {
        super(Node.class);
        this.putValue("Name", NbBundle.getMessage(AddConfigurationAction.class, (String)"LBL_VCS_AddConfiguration"));
    }

    public static Action getStaticInstance() {
        return new AddConfigurationAction();
    }

    protected boolean isEnabled(Node target) {
        return target.getLookup().lookup(J2MEProject.class) != null;
    }

    protected void actionPerformed(Node target) {
        String newName;
        final J2MEProject project = (J2MEProject)target.getLookup().lookup(J2MEProject.class);
        final J2MEProjectProperties j2meProperties = new J2MEProjectProperties(project, (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class), project.getConfigurationHelper());
        final ArrayList allNames = new ArrayList();
        ProjectManager.mutex().postReadRequest(new Runnable(){

            @Override
            public void run() {
                allNames.addAll(Arrays.asList(j2meProperties.getConfigurations()));
            }
        });
        ArrayList<String> names = new ArrayList<String>(allNames.size());
        for (ProjectConfiguration cfg : allNames) {
            names.add(cfg.getDisplayName());
        }
        final NewConfigurationPanel ncp = new NewConfigurationPanel(names);
        DialogDescriptor dd = new DialogDescriptor((Object)ncp, NbBundle.getMessage(AddConfigurationAction.class, (String)"LBL_VCS_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        ncp.setDialogDescriptor(dd);
        String string = newName = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) ? ncp.getName() : null;
        if (newName != null) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    if (AddConfigurationAction.this.addNewConfig(project, newName, j2meProperties, ncp, allNames)) {
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    private boolean addNewConfig(J2MEProject project, final String newName, J2MEProjectProperties j2meProperties, NewConfigurationPanel ncp, List<ProjectConfiguration> allNames) {
        if (newName != null) {
            ProjectConfiguration cfg = new ProjectConfiguration(){

                public String getDisplayName() {
                    return newName;
                }
            };
            VisualConfigSupport.createFromTemplate(j2meProperties, newName, ncp.getTemplate());
            allNames.add(cfg);
            j2meProperties.setConfigurations(allNames.toArray(new ProjectConfiguration[allNames.size()]));
            j2meProperties.store();
            try {
                project.getConfigurationHelper().setActiveConfiguration(cfg);
                return true;
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return false;
    }
}

