/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerJad
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ActionListener {
    static final String[] PROPERTY_GROUP = new String[]{"manifest.others", "manifest.jad", "manifest.manifest", "deployment.override.jarurl", "deployment.jarurl"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private ButtonGroup buttonGroupModel;
    private JCheckBox cDefault;
    private JCheckBox jCheckBoxOverride;
    private JLabel jLabelExpl;
    private JLabel jLabelModel;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonLIBlet;
    private JRadioButton jRadioButtonSuite;
    private JTextField jTextFieldURL;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerJad() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    CustomizerJad.this.bEditActionPerformed(null);
                }
            }
        });
        this.jCheckBoxOverride.addActionListener(this);
    }

    private void initComponents() {
        this.buttonGroupModel = new ButtonGroup();
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.jCheckBoxOverride = new JCheckBox();
        this.jTextFieldURL = new JTextField();
        this.jLabelExpl = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelModel = new JLabel();
        this.jRadioButtonSuite = new JRadioButton();
        this.jRadioButtonLIBlet = new JRadioButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 4);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJad.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 11, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJad.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJad.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxOverride, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustDeploy_OverrideURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jCheckBoxOverride, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jTextFieldURL, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelExpl, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustDeploy_URLExpl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jLabelExpl, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelModel, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomizerJad_PackagignModel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabelModel, gridBagConstraints);
        this.buttonGroupModel.add(this.jRadioButtonSuite);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonSuite, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomizerJad_MIDletSuite"));
        this.jRadioButtonSuite.setActionCommand("false");
        this.jRadioButtonSuite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJad.this.jRadioButtonSuiteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jRadioButtonSuite, gridBagConstraints);
        this.buttonGroupModel.add(this.jRadioButtonLIBlet);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonLIBlet, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomizerJad_LIBlet"));
        this.jRadioButtonLIBlet.setActionCommand("true");
        this.jRadioButtonLIBlet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJad.this.jRadioButtonLIBletActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jRadioButtonLIBlet, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJad.class, (String)"ACSN_Jad"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJad.class, (String)"ACSD_Jad"));
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddAttributePanel add = new AddAttributePanel();
        add.init(false, this.tableModel, this.tableModel.getKeys(), null, null);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerJad.class, (String)"TITLE_AddAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    int row = CustomizerJad.this.tableModel.addRow(add.getKey(), add.getValue(), add.getPlacement());
                    CustomizerJad.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        final String key = (String)this.tableModel.getValueAt(row, 1);
        String value = (String)this.tableModel.getValueAt(row, 2);
        final AddAttributePanel add = new AddAttributePanel();
        add.init(true, this.tableModel, this.tableModel.getKeys(), key, value);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerJad.class, (String)"TITLE_EditAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    if (key == null || !key.equals(add.getKey())) {
                        if (key != null) {
                            CustomizerJad.this.tableModel.removeKey(key);
                        }
                        int newrow = CustomizerJad.this.tableModel.addRow(add.getKey(), add.getValue(), add.getPlacement());
                        CustomizerJad.this.table.getSelectionModel().setSelectionInterval(newrow, newrow);
                    } else {
                        CustomizerJad.this.tableModel.editRow(add.getKey(), add.getValue(), add.getPlacement());
                        CustomizerJad.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    private void jRadioButtonSuiteActionPerformed(ActionEvent evt) {
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
    }

    private void jRadioButtonLIBletActionPerformed(ActionEvent evt) {
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.configuration = configuration;
        this.configurationProfileValue = (String)props.get(VisualPropertySupport.translatePropertyName(configuration, "platform.profile", false));
        this.defaultProfileValue = (String)props.get("platform.profile");
        this.vps = VisualPropertySupport.getDefault(props);
        this.vps.register(this.cDefault, configuration, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        String value = null;
        if (this.configuration != null) {
            value = this.configurationProfileValue;
        }
        if (value == null) {
            value = this.defaultProfileValue;
        }
        this.tableModel.setMIDP(value);
        this.vps.register(this.jRadioButtonSuite, "manifest.is.liblet", useDefault);
        this.vps.register(this.jRadioButtonLIBlet, "manifest.is.liblet", useDefault);
        this.tableModel.initManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.vps.register(this.tableModel, new String[]{"manifest.others", "manifest.jad", "manifest.manifest"}, useDefault);
        this.vps.register(this.jTextFieldURL, "deployment.jarurl", useDefault);
        this.vps.register(this.jCheckBoxOverride, "deployment.override.jarurl", useDefault);
        this.jLabelModel.setEnabled(!useDefault);
        this.jRadioButtonLIBlet.setEnabled(!useDefault && this.tableModel.getMIDPVersion() == 3);
        this.bAdd.setEnabled(!useDefault);
        this.bEdit.setEnabled(!useDefault);
        this.bRemove.setEnabled(!useDefault);
        this.table.setEnabled(!useDefault);
        this.lTable.setEnabled(!useDefault);
        this.jLabelExpl.setEnabled(!useDefault);
        this.table.setBackground(UIManager.getDefaults().getColor(useDefault ? "Panel.background" : "Table.background"));
        this.tableModel.switchManifestModel(this.jRadioButtonLIBlet.isSelected());
        this.valueChanged(null);
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.jTextFieldURL.setEditable(this.jCheckBoxOverride.isEnabled() && this.jCheckBoxOverride.isSelected());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        boolean enabled = this.table.isEnabled() && row >= 0;
        this.bEdit.setEnabled(enabled);
        this.bRemove.setEnabled(enabled && !this.tableModel.containsInMandatory((String)this.tableModel.getValueAt(row, 1)));
    }

    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private HashMap<String, String> map1 = new HashMap();
        private HashMap<String, String> map2 = new HashMap();
        private HashMap<String, String> map3 = new HashMap();
        private final ArrayList<String> items = new ArrayList();
        private int midpVersion = 1;
        private boolean isLIBlet;
        private String[] additionalAttributes = null;
        private static final String NAME = "MIDlet-Name";
        private static final String VENDOR = "MIDlet-Vendor";
        private static final String VERSION = "MIDlet-Version";
        private static final String ICON = "MIDlet-Icon";
        private static final String DESCRIPTION = "MIDlet-Description";
        private static final String INFOURL = "MIDlet-Info-URL";
        private static final String DATASIZE = "MIDlet-Data-Size";
        private static final String MECONFIG = "MicroEdition-Configuration";
        private static final String MEPROFILE = "MicroEdition-Profile";
        private static final String INSTALL = "MIDlet-Install-Notify";
        private static final String DELETE = "MIDlet-Delete-Notify";
        private static final String CONFIRM = "MIDlet-Delete-Confirm";
        private static final String FONT = "MIDlet-Font";
        private static final String MINCANVAS = "MIDlet-Minimum-Canvas-Size";
        private static final String MAXCANVAS = "MIDlet-Maximum-Canvas-Size";
        private static final String SPLASH = "MIDlet-Splash-Screen-Image";
        private static final String USERDENIED = "MIDlet-UserDenied";
        private static final String UPDATEURL = "MIDlet-Update-URL";
        private static final String IPVERSION = "MIDlet-Required-IP-Version";
        private static final String SCICON = "MIDlet-Scalable-Icon";
        private static final String LNAME = "LIBlet-Name";
        private static final String LVENDOR = "LIBlet-Vendor";
        private static final String LVERSION = "LIBlet-Version";
        private static final String LDESCRIPTION = "LIBlet-Description";
        private static final String LNONSHAREDDATA = "LIBlet-NonShared-Data-Size";
        private static final String LSHAREDDATA = "LIBlet-Shared-Data-Size";
        private static final String LINSTALL = "LIBlet-Install-Notify";
        private static final String LICON = "LIBlet-Icon";
        private static final String LDELETE = "LIBlet-Delete-Notify";
        private static final String LFONT = "LIBlet-Font";
        private static final String[][] mandatoryProperties = new String[][]{{"LIBlet-Name", "LIBlet-Vendor", "LIBlet-Version"}, {"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}, {"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}, {"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}};
        private static final String[][] nonmandatoryProperties = new String[][]{{"LIBlet-Description", "LIBlet-NonShared-Data-Size", "LIBlet-Shared-Data-Size", "LIBlet-Install-Notify", "LIBlet-Icon", "LIBlet-Delete-Notify", "LIBlet-Font"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MIDlet-Font", "MIDlet-Minimum-Canvas-Size", "MIDlet-Maximum-Canvas-Size", "MIDlet-Splash-Screen-Image", "MIDlet-UserDenied", "MIDlet-Update-URL", "MIDlet-Required-IP-Version", "MIDlet-Scalable-Icon", "MicroEdition-Configuration", "MicroEdition-Profile"}};
        private static final String[] riskyProperties = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile"};
        private static final long serialVersionUID = -2195421895353167160L;
        private static final Pattern midpPattern = Pattern.compile("MIDP-([1-3])");

        public void initManifestModel(boolean isLIBlet) {
            this.isLIBlet = isLIBlet;
        }

        public void setMIDP(String midp) {
            if (midp != null) {
                Matcher m = midpPattern.matcher(midp);
                this.midpVersion = m.find() ? Integer.parseInt(m.group(1)) : 2;
            }
        }

        public boolean isMIDP2() {
            return this.midpVersion == 2;
        }

        public int getMIDPVersion() {
            return this.midpVersion;
        }

        public HashSet<String> getKeys() {
            return new HashSet<String>(this.items);
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Type");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Key");
                }
                case 2: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Value");
                }
            }
            return null;
        }

        public void switchManifestModel(boolean toLIBlet) {
            this.isLIBlet = toLIBlet;
            String FROM = toLIBlet ? "MIDlet-" : "LIBlet-";
            String TO = toLIBlet ? "LIBlet-" : "MIDlet-";
            for (int i = 0; i < this.items.size(); ++i) {
                String key = this.items.get(i);
                if (!key.startsWith(FROM)) continue;
                String newKey = TO + key.substring(FROM.length());
                if (!StorableTableModel.contains(this.getMandatory(), newKey) && !StorableTableModel.contains(this.getNonMandatory(), newKey)) continue;
                this.items.set(i, newKey);
                String v = this.map1.remove(key);
                if (v != null) {
                    this.map1.put(newKey, v);
                }
                if ((v = this.map2.remove(key)) != null) {
                    this.map2.put(newKey, v);
                }
                if ((v = this.map3.remove(key)) != null) {
                    this.map3.put(newKey, v);
                }
                this.fireTableRowsUpdated(i, i);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            this.updateMapsFromItems();
            return new Object[]{this.map1, this.map2, this.map3};
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (rowIndex < this.items.size());
            switch (columnIndex) {
                case 0: {
                    String value;
                    String item = this.items.get(rowIndex);
                    if (this.containsInMandatory(item)) {
                        value = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Required");
                    } else if (this.containsInRisky(item)) {
                        value = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Risky");
                    } else if (this.containsInNonMandatory(item)) {
                        value = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Optional");
                    } else {
                        Boolean b = this.getPlacement(item);
                        value = NbBundle.getMessage(CustomizerJad.class, (String)("LBL_CustomJad_Custom" + (b == null ? "" : (b != false ? "_J" : "_M"))));
                    }
                    return value;
                }
                case 1: {
                    return this.items.get(rowIndex);
                }
                case 2: {
                    String value = this.map1.get(this.items.get(rowIndex));
                    if (value == null) {
                        value = this.map2.get(this.items.get(rowIndex));
                    }
                    if (value == null) {
                        value = this.map3.get(this.items.get(rowIndex));
                    }
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
            }
            return null;
        }

        @Override
        public synchronized void setDataDelegates(Object[] data) {
            assert (data != null);
            this.map1 = data[0] == null ? new HashMap() : (HashMap)data[0];
            this.map2 = data[1] == null ? new HashMap() : (HashMap)data[1];
            this.map3 = data[2] == null ? new HashMap() : (HashMap)data[2];
            this.updateItemsFromMaps();
            this.fireTableDataChanged();
        }

        public synchronized void updateItemsFromMaps() {
            this.items.clear();
            ArrayList<String> keys = new ArrayList<String>(this.map1.keySet());
            keys.addAll(this.map2.keySet());
            keys.addAll(this.map3.keySet());
            for (int a = 0; a < this.getMandatory().length; ++a) {
                this.items.add(this.getMandatory()[a]);
                keys.remove(this.getMandatory()[a]);
            }
            Object[] strKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(strKeys);
            for (int a = 0; a < strKeys.length; ++a) {
                this.items.add((String)strKeys[a]);
            }
        }

        public synchronized void updateMapsFromItems() {
            HashMap<String, String> res1 = new HashMap<String, String>();
            HashMap<String, String> res2 = new HashMap<String, String>();
            HashMap<String, String> res3 = new HashMap<String, String>();
            for (int a = 0; a < this.items.size(); ++a) {
                String key = this.items.get(a);
                String value = this.map3.get(key);
                if (value != null) {
                    res3.put(key, value);
                    continue;
                }
                value = this.map2.get(key);
                if (value != null) {
                    res2.put(key, value);
                    continue;
                }
                value = this.map1.get(key);
                res1.put(key, value == null ? "" : value);
            }
            this.map1 = res1;
            this.map2 = res2;
            this.map3 = res3;
        }

        private static boolean contains(String[] array, String item) {
            for (int a = 0; a < array.length; ++a) {
                if (!array[a].equals(item)) continue;
                return true;
            }
            return false;
        }

        public String[] getMandatory() {
            return mandatoryProperties[this.isLIBlet ? 0 : this.getMIDPVersion()];
        }

        public String[] getNonMandatory() {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = this.loadAdditionalAttributes();
            }
            return this.mergeAttributes(nonmandatoryProperties[this.isLIBlet ? 0 : this.getMIDPVersion()], this.additionalAttributes);
        }

        public String[] getAllAttrs() {
            return this.mergeAttributes(this.getMandatory(), this.getNonMandatory());
        }

        public boolean containsInMandatory(String item) {
            return StorableTableModel.contains(this.getMandatory(), item);
        }

        public boolean containsInRisky(String item) {
            return StorableTableModel.contains(riskyProperties, item);
        }

        public boolean containsInNonMandatory(String item) {
            return StorableTableModel.contains(this.getNonMandatory(), item);
        }

        public boolean containsInAllAttrs(String item) {
            return StorableTableModel.contains(this.getAllAttrs(), item);
        }

        public boolean isAcceptable(String key) {
            if (key == null) {
                return false;
            }
            if (!key.startsWith("MIDlet-") && !key.startsWith("LIBlet-")) {
                return true;
            }
            return this.containsInAllAttrs(key);
        }

        public int addRow(String key, String value, Boolean placement) {
            if (key == null || this.items.contains(key)) {
                return -1;
            }
            int row = this.items.size();
            this.map1.remove(key);
            this.map2.remove(key);
            this.map3.remove(key);
            if (placement == null) {
                this.map1.put(key, value);
            } else if (placement.booleanValue()) {
                this.map2.put(key, value);
            } else {
                this.map3.put(key, value);
            }
            this.items.add(key);
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void editRow(String key, String value, Boolean placement) {
            int row = this.items.indexOf(key);
            if (row < 0) {
                return;
            }
            this.map1.remove(key);
            this.map2.remove(key);
            this.map3.remove(key);
            if (placement == null) {
                this.map1.put(key, value);
            } else if (placement.booleanValue()) {
                this.map2.put(key, value);
            } else {
                this.map3.put(key, value);
            }
            this.fireTableRowsUpdated(row, row);
        }

        public Boolean getPlacement(String key) {
            if (this.map2.containsKey(key)) {
                return Boolean.TRUE;
            }
            if (this.map3.containsKey(key)) {
                return Boolean.FALSE;
            }
            return null;
        }

        public void removeRow(int row) {
            assert (row < this.items.size());
            if (this.containsInMandatory(this.items.get(row))) {
                return;
            }
            this.items.remove(row);
            this.fireTableRowsDeleted(row, this.items.size() + 1);
        }

        public void removeKey(String key) {
            int row = this.items.indexOf(key);
            if (row < 0) {
                return;
            }
            this.removeRow(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] loadAdditionalAttributes() {
            ArrayList<String> attrs = new ArrayList<String>();
            FileObject xml = FileUtil.getConfigFile((String)"Buildsystem/ApplicationDescriptor/Attributes");
            if (xml == null) {
                return new String[0];
            }
            FileObject[] entries = xml.getChildren();
            for (FileObject fileObject : Arrays.asList(entries)) {
                InputStream is = null;
                try {
                    is = fileObject.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String s;
                        while ((s = reader.readLine()) != null) {
                            if (attrs.contains(s = s.trim()) || s.length() == 0) continue;
                            attrs.add(s);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return attrs.toArray(new String[attrs.size()]);
        }

        private String[] mergeAttributes(String[] a, String[] b) {
            String[] s = new String[a.length + b.length];
            System.arraycopy(a, 0, s, 0, a.length);
            System.arraycopy(b, 0, s, a.length, b.length);
            return s;
        }
    }
}

