/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MIDletScanner
implements Runnable {
    private final ProjectProperties props;
    private J2MEPlatform activePlatform;
    private final HashMap<FileObject, HashSet<String>> roots2icons = new HashMap();
    private final HashMap<FileObject, HashSet<String>> roots2midlets = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2iconModels = new HashMap();
    private final HashMap<FileObject, HashSet<DefaultComboBoxModel>> roots2midletModelts = new HashMap();
    private final HashSet<ChangeListener> listeners = new HashSet();
    private boolean parsing = false;
    private static Reference<MIDletScanner> cache = new WeakReference<Object>(null);
    private static Pattern p = Pattern.compile("\\s+extends\\s+(javax\\.microedition\\.midlet\\.)?MIDlet");

    public static MIDletScanner getDefault(ProjectProperties props) {
        MIDletScanner sc = cache.get();
        if (sc == null || sc.props != props) {
            sc = new MIDletScanner(props);
            cache = new WeakReference<MIDletScanner>(sc);
        }
        return sc;
    }

    private MIDletScanner(ProjectProperties props) {
        this.props = props;
    }

    public boolean isScanning() {
        return this.parsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(DefaultComboBoxModel midlets, DefaultComboBoxModel icons, String configuration, ChangeListener l) {
        MIDletScanner mIDletScanner = this;
        synchronized (mIDletScanner) {
            for (FileObject root : this.getRootsFor(configuration)) {
                HashSet models;
                if (icons != null) {
                    icons.removeAllElements();
                    models = this.roots2iconModels.get(root);
                    if (models == null) {
                        models = new HashSet();
                        this.roots2iconModels.put(root, models);
                    }
                    models.add(icons);
                }
                if (midlets == null) continue;
                midlets.removeAllElements();
                models = this.roots2midletModelts.get(root);
                if (models == null) {
                    models = new HashSet();
                    this.roots2midletModelts.put(root, models);
                }
                models.add(midlets);
            }
            String platform = (String)this.props.get(VisualPropertySupport.translatePropertyName(configuration, "platform.active", true));
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            for (int i = 0; platform != null && i < platforms.length; ++i) {
                J2MEPlatform pl = (J2MEPlatform)platforms[i];
                if (!platform.equals(pl.getDisplayName())) continue;
                this.activePlatform = pl;
                break;
            }
            this.listeners.add(l);
            if (!this.parsing) {
                this.parsing = true;
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }
    }

    private void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener chl : this.listeners) {
            chl.stateChanged(e);
        }
        this.listeners.clear();
    }

    private Collection<FileObject> getArchiveRoots(FileObject[] fo) {
        ArrayList<FileObject> files = new ArrayList<FileObject>(fo.length);
        for (FileObject foi : fo) {
            files.add(FileUtil.isArchiveFile((FileObject)foi) ? FileUtil.getArchiveRoot((FileObject)foi) : foi);
        }
        return files;
    }

    private HashSet<FileObject> getRootsFor(String configuration) {
        HashSet<FileObject> roots = new HashSet<FileObject>();
        roots.add(this.props.getSourceRoot());
        List cpItems = (List)this.props.get(VisualPropertySupport.translatePropertyName(configuration, "libs.classpath", true));
        if (cpItems == null) {
            cpItems = (List)this.props.get("libs.classpath");
        }
        if (cpItems == null) {
            return roots;
        }
        for (VisualClassPathItem item : cpItems) {
            Library l;
            if (2 == item.getType()) {
                AntArtifact aa = (AntArtifact)item.getElement();
                if (aa == null) continue;
                roots.addAll(this.getArchiveRoots(aa.getArtifactFiles()));
                continue;
            }
            if (0 == item.getType() || 4 == item.getType()) {
                File f = (File)item.getElement();
                if (f == null) continue;
                try {
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (fo == null) continue;
                    roots.add(FileUtil.isArchiveFile((FileObject)fo) ? FileUtil.getArchiveRoot((FileObject)fo) : fo);
                }
                catch (IllegalArgumentException iae) {}
                continue;
            }
            if (1 != item.getType() || (l = (Library)item.getElement()) == null) continue;
            Iterator iter = l.getContent("classpath").iterator();
            while (iter.hasNext()) {
                FileObject fo = URLMapper.findFileObject((URL)((URL)iter.next()));
                if (fo == null) continue;
                roots.add(FileUtil.isArchiveFile((FileObject)fo) ? FileUtil.getArchiveRoot((FileObject)fo) : fo);
            }
        }
        roots.remove(null);
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileObject root = null;
        while (true) {
            HashSet<String> midlets;
            HashSet<String> icons;
            MIDletScanner mIDletScanner = this;
            synchronized (mIDletScanner) {
                HashSet<DefaultComboBoxModel> models = this.roots2iconModels.remove(root);
                if (models != null) {
                    this.fillModels(models, this.roots2icons.get(root));
                }
                if ((models = this.roots2midletModelts.remove(root)) != null) {
                    this.fillModels(models, this.roots2midlets.get(root));
                }
                if ((root = this.getNextRoot()) == null) {
                    this.parsing = false;
                    this.fireStateChanged();
                    return;
                }
                if (this.roots2icons.containsKey(root)) {
                    continue;
                }
                icons = new HashSet<String>();
                midlets = new HashSet<String>();
                this.roots2icons.put(root, icons);
                this.roots2midlets.put(root, midlets);
            }
            try {
                this.scanForMIDletsAndIcons(root, icons, midlets);
            }
            catch (Exception e) {
            }
        }
    }

    private FileObject getNextRoot() {
        if (!this.roots2iconModels.isEmpty()) {
            return this.roots2iconModels.keySet().iterator().next();
        }
        if (!this.roots2midletModelts.isEmpty()) {
            return this.roots2midletModelts.keySet().iterator().next();
        }
        return null;
    }

    private void fillModels(HashSet<DefaultComboBoxModel> models, HashSet<String> elements) {
        for (DefaultComboBoxModel m : models) {
            for (String s : elements) {
                if (m.getIndexOf(s) >= 0) continue;
                m.addElement(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForMIDletsAndIcons(FileObject root, HashSet<String> icons, HashSet<String> midlets) {
        String rootPath = root.getPath();
        int rootLength = rootPath.length();
        Enumeration en = root.getChildren(true);
        while (en.hasMoreElements()) {
            MIDletScanner mIDletScanner;
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isData()) continue;
            String ext = fo.getExt().toLowerCase();
            if ("png".equals(ext)) {
                String name = fo.getPath().substring(rootLength);
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                mIDletScanner = this;
                synchronized (mIDletScanner) {
                    icons.add(name);
                    continue;
                }
            }
            if (!"java".equals(ext) && !"class".equals(ext)) continue;
            J2MEProjectUtilitiesProvider utilProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
            if (!(this.activePlatform != null && utilProvider != null ? utilProvider.isFileObjectMIDlet(root, fo, this.activePlatform.getBootstrapLibraries()) : this.isMIDlet(fo))) continue;
            mIDletScanner = this;
            synchronized (mIDletScanner) {
                String name = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                midlets.add(name.substring(0, name.length() - ext.length() - 1).replace('/', '.').replace('\\', '.'));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMIDlet(FileObject fo) {
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            while ((s = br.readLine()) != null) {
                if (s.indexOf("javax/microedition/midlet/MIDlet") < 0 && !p.matcher(s).find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return false;
    }
}

