/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedNodeRenderer;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedTreeBeanView;
import org.netbeans.modules.mobility.project.ui.customizer.regex.FileObjectCookie;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class CheckedNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    static final long serialVersionUID = -5087358518052291490L;
    CheckedNodeRenderer customRenderer = null;
    final JTree jtree;
    ItemListener itemListener;
    protected CheckedTreeBeanView storage;

    public CheckedNodeEditor(JTree jtree) {
        this.jtree = jtree;
        this.customRenderer = new CheckedNodeRenderer();
    }

    public void setContentStorage(CheckedTreeBeanView storage) {
        this.storage = storage;
        this.customRenderer.setContentStorage(storage);
    }

    @Override
    public Object getCellEditorValue() {
        return this.customRenderer.getRenderer();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        boolean returnValue = false;
        if (e instanceof MouseEvent) {
            Object o;
            Node node;
            if (!this.canEditImmediately(e)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)e;
            TreePath path = this.jtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (path != null && (node = Visualizer.findNode((Object)(o = path.getLastPathComponent()))).getCookie(FileObjectCookie.class) != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected boolean inHitRegion(int x, int y) {
        int lastRow = this.jtree.getRowForLocation(x, y);
        if (lastRow != -1 && this.jtree != null) {
            Rectangle bounds = this.jtree.getRowBounds(lastRow);
            String osName = (String)System.getProperties().get("os.name");
            if (bounds != null && x - bounds.x < 10 && x - bounds.x >= 0) {
                return true;
            }
            if (osName.contains("Mac") && bounds != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getTreeCellEditorComponent(final JTree tree, final Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        final Component editor = this.customRenderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CheckedNodeEditor.this.stopCellEditing()) {
                    Node node;
                    FileObjectCookie doj;
                    if (editor instanceof CheckedNodeRenderer.RendererComponent) {
                        ((CheckedNodeRenderer.RendererComponent)editor).removeItemListener(CheckedNodeEditor.this.itemListener);
                    }
                    if ((doj = (FileObjectCookie)(node = Visualizer.findNode((Object)value)).getCookie(FileObjectCookie.class)) != null) {
                        FileObject fo = doj.getFileObject();
                        CheckedNodeEditor.this.storage.setState(fo, CheckedTreeBeanView.UNSELECTED == CheckedNodeEditor.this.storage.getState(fo));
                        TreePath path = tree.getAnchorSelectionPath();
                        ((DefaultTreeModel)tree.getModel()).reload();
                        tree.setAnchorSelectionPath(path);
                    }
                }
            }
        };
        if (editor instanceof CheckedNodeRenderer.RendererComponent) {
            ((CheckedNodeRenderer.RendererComponent)editor).addItemListener(this.itemListener);
        }
        return editor;
    }
}

