/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel
implements DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String SOURCES_LOCATION = "SourcesLocation";
    public static final String JAD_LOCATION = "JadLocation";
    private static final String JAD = "jad";
    private boolean updateJad;
    private JButton bBrowse;
    private JButton bBrowseJad;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JTextField tJad;
    private JTextField tLocation;

    public SourcesPanel() {
        this.initComponents();
        this.initAccessibility();
        this.updateJad = true;
        this.tJad.getDocument().addDocumentListener(this);
    }

    public synchronized void addListener(DocumentListener listener) {
        this.tLocation.getDocument().addDocumentListener(listener);
        this.tJad.getDocument().addDocumentListener(listener);
    }

    public synchronized void removeListener(DocumentListener listener) {
        this.tLocation.getDocument().removeDocumentListener(listener);
        this.tJad.getDocument().removeDocumentListener(listener);
    }

    public synchronized void readData(TemplateWizard object) {
        Object tmp = object.getProperty(SOURCES_LOCATION);
        if (tmp != null) {
            this.tLocation.setText((String)tmp);
        } else {
            FileObject fo = Templates.getExistingSourcesFolder((WizardDescriptor)object);
            File f = fo == null ? null : FileUtil.toFile((FileObject)fo);
            this.tLocation.setText(f == null ? "" : f.getAbsolutePath());
        }
        tmp = object.getProperty(JAD_LOCATION);
        boolean tmpUpdateJad = this.updateJad;
        this.tJad.setText(tmp != null ? (String)tmp : "");
        this.updateJad = tmpUpdateJad;
    }

    public synchronized void storeData(TemplateWizard object) {
        String location = this.tLocation.getText();
        object.putProperty(SOURCES_LOCATION, (Object)location);
        object.putProperty(JAD_LOCATION, (Object)this.tJad.getText());
        String name = new File(location).getName();
        object.putProperty("ProjectName", (Object)("Imported Project" + (name != null ? " - " + name + '1' : "1")));
        String detectedConfiguration = null;
        String detectedProfile = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            File jadFile = new File(this.tJad.getText());
            J2MEProjectGenerator.loadJadManifest(map, jadFile);
            detectedConfiguration = (String)map.get("MicroEdition-Configuration");
            detectedProfile = (String)map.get("MicroEdition-Profile");
        }
        catch (IOException e) {
            // empty catch block
        }
        object.putProperty("RequiredConfiguration", detectedConfiguration);
        object.putProperty("RequiredProfile", detectedProfile);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    public String getJadLocation() {
        return this.tJad.getText();
    }

    public synchronized void setJadLocation(String jadLocation) {
        boolean tmp = this.updateJad;
        this.tJad.setText(jadLocation);
        this.updateJad = tmp;
    }

    public boolean hasUpdateJad() {
        return this.updateJad;
    }

    @Override
    public synchronized void changedUpdate(DocumentEvent e) {
        this.updateJad = false;
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        this.updateJad = false;
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        this.updateJad = false;
    }

    protected boolean isJadDocumentEvent(DocumentEvent e) {
        return e.getDocument() == this.tJad.getDocument();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.tJad = new JTextField();
        this.bBrowseJad = new JButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Info"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setPreferredSize(new Dimension(400, 54));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Location"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Browse1"));
        this.jLabel3.setLabelFor(this.tJad);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Jad"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tJad, gridBagConstraints);
        this.tJad.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_JAD"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseJad, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_BrowseJad"));
        this.bBrowseJad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.bBrowseJadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowseJad, gridBagConstraints);
        this.bBrowseJad.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Browse2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourcesPanel.class, (String)"ACSN_Sources"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseJadActionPerformed(ActionEvent evt) {
        String jad;
        String location = this.tJad.getText();
        if (location == null || "".equals(location)) {
            location = this.tLocation.getText();
        }
        if (location == null || "".equals(location)) {
            location = System.getProperty("user.home", "");
        }
        if ((jad = Utils.browseFilter(this, location, NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources_JadManifestLocation"), 0, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (!f.exists() || !f.canRead()) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                if (!f.isFile()) {
                    return false;
                }
                String ext = f.getName();
                int i = ext.lastIndexOf(46);
                if (i >= 0) {
                    ext = ext.substring(i + 1);
                }
                return SourcesPanel.JAD.equals(ext = ext.toLowerCase()) || "mf".equals(ext);
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_JadManifestFilter");
            }
        })) != null) {
            this.tJad.setText(jad);
        }
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        String folder;
        String location = this.tLocation.getText();
        if (location == null || "".equals(location)) {
            location = System.getProperty("user.home", "");
        }
        if ((folder = Utils.browseFolder(this, location, NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources_Location"))) != null) {
            this.tLocation.setText(folder);
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener {
        SourcesPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;

        WizardPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new SourcesPanel();
                this.component.addListener(this);
                this.checkValid(true);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SourcesPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public boolean isValid() {
            return this.isValid(false);
        }

        public boolean isValid(boolean allowJadUpdate) {
            Project other;
            String jadLocation;
            boolean valid;
            File f = FileUtil.normalizeFile((File)new File(this.component.getLocationText()).getAbsoluteFile());
            boolean bl = valid = this.component.getLocationText().length() > 0 && f != null && f.exists() && f.isDirectory();
            if (!valid) {
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"ERR_Sources_InvalidLocation"));
                return false;
            }
            FileObject srcRoot = FileUtil.toFileObject((File)f);
            if (allowJadUpdate && this.component.hasUpdateJad()) {
                f = this.findJadManifest(f);
                this.component.removeListener(this);
                this.component.setJadLocation(f != null ? f.getAbsolutePath() : "");
                this.component.addListener(this);
            }
            if (!"".equals(jadLocation = this.component.getJadLocation())) {
                f = new File(jadLocation);
                boolean bl2 = valid = f.exists() && f.isFile() && f.canRead();
                if (!valid) {
                    this.showError(NbBundle.getMessage(SourcesPanel.class, (String)(this.component.hasUpdateJad() ? "ERR_Sources_InvalidAutoJadLocation" : "ERR_Sources_InvalidJadLocation")));
                    return false;
                }
            }
            Project project = other = srcRoot == null ? null : FileOwnerQuery.getOwner((FileObject)srcRoot);
            if (other != null && Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(other)) {
                ProjectInformation pi = (ProjectInformation)other.getLookup().lookup(ProjectInformation.class);
                String name = pi == null ? other.getProjectDirectory().getPath() : pi.getDisplayName();
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"WARN_Sources_Clashing", (Object)name));
            } else {
                this.showError(null);
            }
            return true;
        }

        private File findJadManifest(File dir) {
            File[] dirFiles = dir.listFiles();
            File res = Utils.findSubFile(dirFiles, dir.getName() + ".jad");
            if (res != null) {
                return res;
            }
            res = Utils.findAnyFile(dirFiles, SourcesPanel.JAD);
            if (res != null) {
                return res;
            }
            res = Utils.findSubFile(dirFiles, "manifest.mf");
            if (res != null) {
                return res;
            }
            File metaDir = Utils.findSubFile(dirFiles, "META-INF");
            if (metaDir != null && metaDir.isDirectory()) {
                File[] metaFiles = metaDir.listFiles();
                res = Utils.findSubFile(metaFiles, "manifest.mf");
                if (res != null) {
                    return res;
                }
                res = Utils.findAnyFile(metaFiles, "mf");
                if (res != null) {
                    return res;
                }
                res = Utils.findSubFile(metaFiles, SourcesPanel.JAD);
                if (res != null) {
                    return res;
                }
            }
            if ((res = Utils.findAnyFile(dirFiles, "mf")) != null) {
                return res;
            }
            File parent = dir.getParentFile();
            if (parent != null) {
                File[] parentFiles = parent.listFiles();
                res = Utils.findSubFile(parentFiles, dir.getName() + ".jad");
                if (res != null) {
                    return res;
                }
                res = Utils.findAnyFile(parentFiles, SourcesPanel.JAD);
                if (res != null) {
                    return res;
                }
                res = Utils.findSubFile(parentFiles, "manifest.mf");
                if (res != null) {
                    return res;
                }
                res = Utils.findAnyFile(parentFiles, "mf");
                if (res != null) {
                    return res;
                }
            }
            return null;
        }

        public void readSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((SourcesPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object substitute = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizard.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((SourcesPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid(boolean allowJadUpdate) {
            if (this.isValid(allowJadUpdate) != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkValid(!this.component.isJadDocumentEvent(e));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkValid(!this.component.isJadDocumentEvent(e));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkValid(!this.component.isJadDocumentEvent(e));
        }
    }
}

