/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.openide.filesystems.FileUtil;

public final class CodeModelSourceFileInfoProvider
implements SourceFileInfoProvider {
    private static final boolean TRACE = false;
    private WeakReference<Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>> staticFileCache = new WeakReference<Object>(null);

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(String functionQName, int lineNumber, long offset, Map<String, String> serviceInfo) {
        try {
            String projectFolderName = serviceInfo.get("GizmoProjectFolder");
            if (projectFolderName == null) {
                return null;
            }
            Project prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)new File(projectFolderName)));
            if (prj.getLookup().lookup(NativeProject.class) == null) {
                return null;
            }
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)prj);
            if (csmProject == null) {
                return null;
            }
            SourceFileInfoProvider.SourceFileInfo res = this.findFunction(csmProject, functionQName, lineNumber);
            if (res == null) {
                res = this.findStaticFunction(csmProject, functionQName);
            }
            return res;
        }
        catch (IOException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private SourceFileInfoProvider.SourceFileInfo findFunction(CsmProject csmProject, String name, int lineNumber) {
        CsmFunction function = CodeModelSourceFileInfoProvider.getFunction(csmProject, name);
        if (function == null) {
            return null;
        }
        String sourceFile = ((Object)function.getContainingFile().getAbsolutePath()).toString();
        int startOffset = function.getStartOffset();
        if (lineNumber > 0) {
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)sourceFile, lineNumber, 0);
        }
        return new SourceFileInfoProvider.SourceFileInfo(sourceFile, (long)startOffset);
    }

    private static CsmFunction getFunction(CsmProject project, CharSequence qualifiedName) {
        Iterator iter = CsmSelect.getFunctions((CsmProject)project, (CharSequence)qualifiedName);
        CsmFunction declaration = null;
        while (iter.hasNext()) {
            CsmFunction function = (CsmFunction)iter.next();
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)function)) {
                return function;
            }
            CsmFunctionDefinition definition = function.getDefinition();
            if (definition != null) {
                return definition;
            }
            declaration = function;
        }
        return declaration;
    }

    private SourceFileInfoProvider.SourceFileInfo findStaticFunction(CsmProject project, String qualifiedName) {
        Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> cache = this.getCache(project);
        Set<SourceFileInfoProvider.SourceFileInfo> set = cache.get(qualifiedName);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    private synchronized Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> getCache(CsmProject project) {
        Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> cache = (Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>)this.staticFileCache.get();
        if (cache == null) {
            cache = this.initStaticFunctions(project);
            this.staticFileCache = new WeakReference<Map<String, Set<SourceFileInfoProvider.SourceFileInfo>>>(cache);
        }
        return cache;
    }

    private Map<String, Set<SourceFileInfoProvider.SourceFileInfo>> initStaticFunctions(CsmProject project) {
        HashMap<String, Set<SourceFileInfoProvider.SourceFileInfo>> res = new HashMap<String, Set<SourceFileInfoProvider.SourceFileInfo>>();
        for (CsmFile file : project.getAllFiles()) {
            for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
                if (!CsmKindUtilities.isFileLocalFunction((CsmObject)decl)) continue;
                CsmFunction func = (CsmFunction)decl;
                String name = ((Object)func.getQualifiedName()).toString();
                HashSet<SourceFileInfoProvider.SourceFileInfo> set = (HashSet<SourceFileInfoProvider.SourceFileInfo>)res.get(name);
                if (set == null) {
                    set = new HashSet<SourceFileInfoProvider.SourceFileInfo>();
                    res.put(name, set);
                }
                set.add(new SourceFileInfoProvider.SourceFileInfo(((Object)file.getAbsolutePath()).toString(), (long)func.getStartPosition().getOffset()));
            }
        }
        return res;
    }
}

