/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.WhereUsedElement;
import org.netbeans.modules.refactoring.ruby.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.ruby.plugins.RubyRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RubyWhereUsedQueryPlugin
extends RubyRefactoringPlugin {
    private final WhereUsedQuery refactoring;
    private final RubyElementCtx searchHandle;
    private Set<IndexedClass> subclasses;
    private final String targetName;

    public RubyWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
        this.searchHandle = (RubyElementCtx)refactoring.getRefactoringSource().lookup(RubyElementCtx.class);
        this.targetName = this.searchHandle.getSimpleName();
    }

    public Problem preCheck() {
        if (!this.searchHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(RubyWhereUsedQueryPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(RubyElementCtx tph) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        FileObject file = tph.getFileObject();
        if (file != null) {
            if (this.isFindSubclasses() || this.isFindDirectSubclassesOnly()) {
                set.add(file);
                String name = tph.getName();
                RubyIndex index = RubyIndex.get(RetoucheUtils.getProjectRoots(file));
                String fqn = AstUtilities.getFqnName((AstPath)tph.getPath());
                this.subclasses = index.getSubClasses(null, fqn, name, this.isFindDirectSubclassesOnly());
                return set;
            }
            if (tph.getKind() == ElementKind.VARIABLE || tph.getKind() == ElementKind.PARAMETER) {
                set.add(file);
            } else {
                set.addAll(RetoucheUtils.getRubyFilesInProject(file));
            }
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Set<FileObject> a = this.getRelevantFiles(this.searchHandle);
        this.fireProgressListenerStart(1, a.size());
        this.processFiles(a, new FindTask(elements));
        this.fireProgressListenerStop();
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.targetName == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (this.searchHandle.getKind() == ElementKind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(RubyWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return false;
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private class FindTask
    extends RubyRefactoringPlugin.TransformTask {
        private RefactoringElementsBag elements;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        @Override
        protected Collection<ModificationResult> process(ParserResult parserResult) {
            BaseDocument doc;
            String sourceText;
            if (RubyWhereUsedQueryPlugin.this.isCancelled()) {
                return Collections.emptySet();
            }
            Error error = null;
            RubyElementCtx searchCtx = RubyWhereUsedQueryPlugin.this.searchHandle;
            Node root = AstUtilities.getRoot((Parser.Result)parserResult);
            if (root == null && (sourceText = ((Object)parserResult.getSnapshot().getText()).toString()) != null && sourceText.indexOf(RubyWhereUsedQueryPlugin.this.targetName) != -1) {
                int start = 0;
                int end = 0;
                String desc = "Parse error in file which contains " + RubyWhereUsedQueryPlugin.this.targetName + " reference - skipping it";
                List errors = parserResult.getDiagnostics();
                if (errors.size() > 0) {
                    String errorMsg;
                    for (Error e : errors) {
                        if (e.getSeverity() != Severity.ERROR) continue;
                        error = e;
                        break;
                    }
                    if (error == null) {
                        error = (Error)errors.get(0);
                    }
                    if ((errorMsg = error.getDisplayName()).length() > 80) {
                        errorMsg = errorMsg.substring(0, 77) + "...";
                    }
                    desc = desc + "; " + errorMsg;
                    start = error.getStartPosition();
                    if ((start = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)start)) == -1) {
                        start = 0;
                    }
                    end = start;
                }
                Set modifiers = Collections.emptySet();
                ImageIcon icon = UiUtils.getElementIcon((ElementKind)ElementKind.ERROR, modifiers);
                OffsetRange range = new OffsetRange(start, end);
                WhereUsedElement element = WhereUsedElement.create(parserResult, RubyWhereUsedQueryPlugin.this.targetName, desc, range, icon);
                this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)element);
            }
            if (error == null && RubyWhereUsedQueryPlugin.this.isSearchInComments() && (doc = RetoucheUtils.getDocument(parserResult, RubyUtils.getFileObject((Parser.Result)parserResult))) != null) {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(0);
                this.searchTokenSequence(parserResult, ts);
            }
            if (root == null) {
                return Collections.emptySet();
            }
            AstElement element = AstElement.create((ParserResult)parserResult, (Node)root);
            Node node = searchCtx.getNode();
            RubyElementCtx fileCtx = new RubyElementCtx(root, node, (Element)element, RubyUtils.getFileObject((Parser.Result)parserResult), parserResult);
            if (RubyWhereUsedQueryPlugin.this.isFindSubclasses() || RubyWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly()) {
                assert (RubyWhereUsedQueryPlugin.this.subclasses != null);
                for (IndexedClass clz : RubyWhereUsedQueryPlugin.this.subclasses) {
                    RubyElementCtx matchCtx = new RubyElementCtx((IndexedElement)clz);
                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                }
            } else if (RubyWhereUsedQueryPlugin.this.isFindUsages()) {
                AstPath path;
                Node method = null;
                if (node instanceof ArgumentNode) {
                    path = searchCtx.getPath();
                    assert (path.leaf() == node);
                    Node parent = path.leafParent();
                    if (!(parent instanceof MethodDefNode)) {
                        method = AstUtilities.findLocalScope((Node)node, (AstPath)path);
                    }
                } else if (node instanceof LocalVarNode || node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof DVarNode) {
                    path = searchCtx.getPath();
                    method = AstUtilities.findLocalScope((Node)node, (AstPath)path);
                }
                if (method != null) {
                    this.findLocal(searchCtx, fileCtx, method, RubyWhereUsedQueryPlugin.this.targetName);
                } else {
                    path = new AstPath();
                    path.descend(root);
                    this.find(path, searchCtx, fileCtx, root, RubyWhereUsedQueryPlugin.this.targetName, Character.isUpperCase(RubyWhereUsedQueryPlugin.this.targetName.charAt(0)));
                    path.ascend();
                }
            } else if (RubyWhereUsedQueryPlugin.this.isFindOverridingMethods() || RubyWhereUsedQueryPlugin.this.isSearchFromBaseClass()) {
                // empty if block
            }
            return Collections.emptySet();
        }

        private void searchTokenSequence(ParserResult info, TokenSequence<?> ts) {
            if (ts.moveNext()) {
                do {
                    Token token;
                    TokenId id;
                    String primaryCategory;
                    if ("comment".equals(primaryCategory = (id = (token = ts.token()).id()).primaryCategory()) || "block-comment".equals(primaryCategory)) {
                        int index;
                        assert (RubyWhereUsedQueryPlugin.this.targetName != null);
                        CharSequence tokenText = token.text();
                        if (tokenText == null || RubyWhereUsedQueryPlugin.this.targetName == null || (index = TokenUtilities.indexOf((CharSequence)tokenText, (CharSequence)RubyWhereUsedQueryPlugin.this.targetName)) == -1) continue;
                        String text = ((Object)tokenText).toString();
                        if (index != 0 && Character.isLetterOrDigit(text.charAt(index - 1)) || index + RubyWhereUsedQueryPlugin.this.targetName.length() < text.length() && Character.isLetterOrDigit(text.charAt(index + RubyWhereUsedQueryPlugin.this.targetName.length()))) continue;
                        int start = ts.offset() + index;
                        int end = start + RubyWhereUsedQueryPlugin.this.targetName.length();
                        Set modifiers = Collections.emptySet();
                        if (RubyWhereUsedQueryPlugin.this.searchHandle.getElement() != null) {
                            modifiers = RubyWhereUsedQueryPlugin.this.searchHandle.getElement().getModifiers();
                        }
                        ImageIcon icon = UiUtils.getElementIcon((ElementKind)RubyWhereUsedQueryPlugin.this.searchHandle.getKind(), (Collection)modifiers);
                        OffsetRange range = new OffsetRange(start, end);
                        WhereUsedElement element = WhereUsedElement.create(info, RubyWhereUsedQueryPlugin.this.targetName, range, icon);
                        this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)element);
                        continue;
                    }
                    TokenSequence embedded = ts.embedded();
                    if (embedded == null) continue;
                    this.searchTokenSequence(info, embedded);
                } while (ts.moveNext());
            }
        }

        private void find(AstPath path, RubyElementCtx searchCtx, RubyElementCtx fileCtx, Node node, String name, boolean upperCase) {
            block20: {
                RubyElementCtx matchCtx;
                block21: {
                    block19: {
                        if (node.getNodeType() != NodeType.ALIASNODE) break block19;
                        AliasNode an = (AliasNode)node;
                        if (an.getNewName().equals(name) || an.getOldName().equals(name)) {
                            matchCtx = new RubyElementCtx(fileCtx, node);
                            this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                        }
                        break block20;
                    }
                    if (upperCase) break block21;
                    switch (node.getNodeType()) {
                        case DEFNNODE: 
                        case DEFSNODE: {
                            if (!((MethodDefNode)node).getName().equals(name)) break;
                            boolean skip = false;
                            String fqn = AstUtilities.getFqnName((AstPath)path);
                            if (fqn == null || fqn.length() == 0) {
                                fqn = "Object";
                            }
                            if (!fqn.equals(searchCtx.getDefClass())) {
                                // empty if block
                            }
                            if (!skip && AstUtilities.isCall((Node)searchCtx.getNode()) && !AstUtilities.isCallFor((Node)searchCtx.getNode(), (Arity)searchCtx.getArity(), (Node)node)) {
                                skip = true;
                            }
                            if (!skip) {
                                node = AstUtilities.getDefNameNode((MethodDefNode)((MethodDefNode)node));
                                RubyElementCtx matchCtx2 = new RubyElementCtx(fileCtx, node);
                                this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx2));
                                break;
                            }
                            break block20;
                        }
                        case FCALLNODE: {
                            if (AstUtilities.isAttr((Node)node)) {
                                SymbolNode[] symbols;
                                for (SymbolNode symbol : symbols = AstUtilities.getAttrSymbols((Node)node)) {
                                    if (!symbol.getName().equals(name)) continue;
                                    RubyElementCtx matchCtx3 = new RubyElementCtx(fileCtx, node);
                                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx3));
                                }
                            }
                        }
                        case VCALLNODE: 
                        case CALLNODE: {
                            if (!((INameNode)node).getName().equals(name)) break;
                            RubyElementCtx matchCtx4 = new RubyElementCtx(fileCtx, node);
                            this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx4));
                            break;
                        }
                        case SYMBOLNODE: {
                            if (!((SymbolNode)node).getName().equals(name)) break;
                            RubyElementCtx matchCtx5 = new RubyElementCtx(fileCtx, node);
                            this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx5));
                            break;
                        }
                        case GLOBALVARNODE: 
                        case GLOBALASGNNODE: 
                        case INSTVARNODE: 
                        case INSTASGNNODE: 
                        case CLASSVARNODE: 
                        case CLASSVARASGNNODE: 
                        case CLASSVARDECLNODE: {
                            if (!((INameNode)node).getName().equals(name)) break;
                            RubyElementCtx matchCtx6 = new RubyElementCtx(fileCtx, node);
                            this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx6));
                        }
                    }
                    break block20;
                }
                switch (node.getNodeType()) {
                    case COLON2NODE: {
                        Colon2Node c2n = (Colon2Node)node;
                        if (!c2n.getName().equals(name)) break;
                        matchCtx = new RubyElementCtx(fileCtx, node);
                        this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                        break;
                    }
                    case CONSTNODE: 
                    case CONSTDECLNODE: {
                        if (!((INameNode)node).getName().equals(name)) break;
                        RubyElementCtx matchCtx7 = new RubyElementCtx(fileCtx, node);
                        this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx7));
                    }
                }
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible()) continue;
                path.descend(child);
                this.find(path, searchCtx, fileCtx, child, name, upperCase);
                path.ascend();
            }
        }

        private void findLocal(RubyElementCtx searchCtx, RubyElementCtx fileCtx, Node node, String name) {
            switch (node.getNodeType()) {
                case ARGUMENTNODE: {
                    if (!((ArgumentNode)node).getName().equals(name)) break;
                    RubyElementCtx matchCtx = new RubyElementCtx(fileCtx, node);
                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                    break;
                }
                case LOCALVARNODE: 
                case LOCALASGNNODE: {
                    if (!((INameNode)node).getName().equals(name)) break;
                    RubyElementCtx matchCtx = new RubyElementCtx(fileCtx, node);
                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                    break;
                }
                case DVARNODE: 
                case DASGNNODE: {
                    if (!((INameNode)node).getName().equals(name)) break;
                    RubyElementCtx matchCtx = new RubyElementCtx(fileCtx, node);
                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                    break;
                }
                case SYMBOLNODE: {
                    if (!((SymbolNode)node).getName().equals(name)) break;
                    RubyElementCtx matchCtx = new RubyElementCtx(fileCtx, node);
                    this.elements.add((AbstractRefactoring)RubyWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(matchCtx));
                }
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible()) continue;
                this.findLocal(searchCtx, fileCtx, child, name);
            }
        }
    }
}

