/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class Generator {
    public static Generator NONE = new Generator("NONE", null, 0);
    public static Generator CONTROLLER = new Generator("controller", null, null, "Views", null, 1);
    public static Generator INTEGRATION_TEST = new Generator("integration_test", null, 1);
    public static Generator MAILER = new Generator("mailer", null, null, "Views", null, 1);
    public static Generator MIGRATION = new Generator("migration", null, 1);
    public static Generator MODEL = new Generator("model", null, 1);
    public static Generator METAL = new Generator("metal", null, 1);
    public static Generator PLUGIN = new Generator("plugin", null, 1);
    public static Generator SCAFFOLD_ONE = new Generator("scaffold", null, "ModelName", "ScaffControllerName", "ScaffoldActions", 1);
    public static Generator SCAFFOLD_TWO = new Generator("scaffold", null, "ModelName", "ScaffoldAttrs", null, 1);
    public static Generator SESSION_MIGRATION = new Generator("session_migration", null, 1);
    public static Generator WEB_SERVICE = new Generator("web_service", null, null, "ApiMethods", null, 1);
    private final String name;
    private FileObject location;
    private final String nameKey;
    private final String arg1Key;
    private final String arg2Key;
    private final int argsRequired;

    public Generator(String name, FileObject location, int argsRequired) {
        this(name, location, "Arguments", null, null, argsRequired);
    }

    private Generator(String name, FileObject location, String nameKey, String arg1Key, String arg2Key, int argsRequired) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.argsRequired = argsRequired;
        this.name = name;
        this.location = location;
        this.nameKey = nameKey;
        this.arg1Key = arg1Key;
        this.arg2Key = arg2Key;
    }

    static List<Generator> getBuiltinGenerators(String railsVersion, List<Generator> foundBuiltin) {
        boolean isRailsOne = railsVersion != null && railsVersion.startsWith("1.");
        ArrayList<Generator> list = new ArrayList<Generator>();
        list.add(CONTROLLER);
        list.add(INTEGRATION_TEST);
        list.add(MODEL);
        list.add(MIGRATION);
        list.add(MAILER);
        list.add(PLUGIN);
        if (isRailsOne) {
            list.add(SCAFFOLD_ONE);
        } else {
            list.add(SCAFFOLD_TWO);
        }
        list.add(SESSION_MIGRATION);
        if (isRailsOne) {
            list.add(WEB_SERVICE);
        }
        return Generator.configureBuiltins(list, foundBuiltin);
    }

    private static List<Generator> configureBuiltins(List<Generator> builtin, List<Generator> foundBuiltin) {
        for (Generator found : foundBuiltin) {
            boolean match = false;
            for (Generator preConfigured : builtin) {
                if (!found.name.equals(preConfigured.name)) continue;
                preConfigured.location = found.location;
                match = true;
            }
            if (match) continue;
            builtin.add(found);
        }
        return builtin;
    }

    public int getArgsRequired() {
        return this.argsRequired;
    }

    public String getName() {
        return this.name;
    }

    public FileObject getDir() {
        return this.location;
    }

    public String getUsage(Project project) {
        if (this == NONE) {
            return null;
        }
        File generatorDir = null;
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (this.location == null) {
            File gemLocation = null;
            FileObject railsInstall = project.getProjectDirectory().getFileObject("vendor/rails/railties");
            if (railsInstall != null) {
                gemLocation = FileUtil.toFile((FileObject)railsInstall);
            } else {
                File railsDir;
                File rubyHome;
                String version = platform.getGemManager().getLatestVersion("rails");
                if (version != null) {
                    gemLocation = new File(platform.getGemManager().getGemHome() + File.separator + "gems" + File.separator + "rails" + "-" + version);
                } else if (!Utilities.isWindows() && (rubyHome = platform.getHome()) != null && (railsDir = new File(rubyHome, "/share/rails/railties")).exists()) {
                    gemLocation = railsDir;
                }
            }
            if (gemLocation != null) {
                generatorDir = new File(gemLocation, "lib" + File.separator + "rails_generator" + File.separator + "generators" + File.separator + "components" + File.separator + this.name);
            }
        } else {
            generatorDir = FileUtil.toFile((FileObject)this.location);
        }
        File usageFile = this.findUsageFile(generatorDir);
        return usageFile != null ? RailsProjectUtil.asText(usageFile) : null;
    }

    private File findUsageFile(File generatorDir) {
        String[] filesToTry = new String[]{"USAGE", "templates" + File.separator + "USAGE", "README.rdoc", "README"};
        ArrayList<File> dirsToTry = new ArrayList<File>(3);
        dirsToTry.add(generatorDir);
        File parent = generatorDir.getParentFile();
        if (parent.exists() && "generators".equals(parent.getName())) {
            dirsToTry.add(parent);
            File grandParent = parent.getParentFile();
            if (grandParent.exists()) {
                dirsToTry.add(grandParent);
            }
        }
        for (File dir : dirsToTry) {
            for (String file : filesToTry) {
                File result = new File(dir, file);
                if (!result.exists()) continue;
                return result;
            }
        }
        return null;
    }

    String getNameLabel() {
        if (this.nameKey != null) {
            return NbBundle.getMessage(Generator.class, (String)this.nameKey);
        }
        return NbBundle.getMessage(Generator.class, (String)"Name");
    }

    String getArg1Label() {
        if (this.arg1Key != null) {
            return NbBundle.getMessage(Generator.class, (String)this.arg1Key);
        }
        return null;
    }

    String getArg2Label() {
        if (this.arg2Key != null) {
            return NbBundle.getMessage(Generator.class, (String)this.arg2Key);
        }
        return null;
    }

    static final class Script {
        final String script;
        final List<String> args = new ArrayList<String>();

        public Script(String script) {
            this.script = script;
        }

        Script addArgs(String ... argsToAdd) {
            if (argsToAdd == null) {
                return this;
            }
            for (String each : argsToAdd) {
                this.args.add(each);
            }
            return this;
        }
    }
}

