/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;

final class SourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String PROP_BUILD_DIR = "build.dir";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private final SourceRoots sourceRoots;
    private final RakeProjectHelper projectHelper;
    private final PropertyEvaluator evaluator;
    private String urlString;

    public SourcePathImplementation(SourceRoots sourceRoots) {
        assert (sourceRoots != null);
        this.sourceRoots = sourceRoots;
        this.projectHelper = null;
        this.evaluator = null;
        sourceRoots.addPropertyChangeListener(this);
    }

    public SourcePathImplementation(SourceRoots sourceRoots, RakeProjectHelper projectHelper, PropertyEvaluator evaluator) {
        assert (sourceRoots != null && projectHelper != null && evaluator != null);
        this.sourceRoots = sourceRoots;
        sourceRoots.addPropertyChangeListener(this);
        this.projectHelper = projectHelper;
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            if (this.resources != null) {
                return this.resources;
            }
        }
        URL[] roots = this.sourceRoots.getRootURLs();
        SourcePathImplementation sourcePathImplementation2 = this;
        synchronized (sourcePathImplementation2) {
            if (this.resources == null) {
                ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(roots.length);
                for (URL root : roots) {
                    this.urlString = root.toExternalForm();
                    if (this.urlString.endsWith("/vendor/") || this.urlString.endsWith("/WEB-INF/")) continue;
                    result.add(ClassPathSupport.createResource((URL)root));
                }
                if (this.projectHelper != null) {
                    try {
                        String buildDir = this.evaluator.getProperty(PROP_BUILD_DIR);
                        if (buildDir != null) {
                            File f = new File(this.projectHelper.resolveFile(buildDir), "generated/wsclient");
                            URL url = f.toURI().toURL();
                            if (!f.exists()) {
                                assert (!url.toExternalForm().endsWith("/"));
                                url = new URL(url.toExternalForm() + '/');
                            }
                            result.add(ClassPathSupport.createResource((URL)url));
                            f = new File(this.projectHelper.resolveFile(buildDir), "generated/wsimport/client");
                            url = f.toURI().toURL();
                            if (!f.exists()) {
                                assert (!url.toExternalForm().endsWith("/"));
                                url = new URL(url.toExternalForm() + '/');
                            }
                            result.add(ClassPathSupport.createResource((URL)url));
                        }
                    }
                    catch (MalformedURLException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                this.resources = Collections.unmodifiableList(result);
            }
            return this.resources;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            SourcePathImplementation sourcePathImplementation = this;
            synchronized (sourcePathImplementation) {
                this.resources = null;
            }
            this.support.firePropertyChange("resources", null, null);
        } else if (this.evaluator != null && evt.getSource() == this.evaluator && (evt.getPropertyName() == null || PROP_BUILD_DIR.equals(evt.getPropertyName()))) {
            SourcePathImplementation sourcePathImplementation = this;
            synchronized (sourcePathImplementation) {
                this.resources = null;
            }
            this.support.firePropertyChange("resources", null, null);
        }
    }
}

