/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class RailsJdbcAsAdapterConnection
extends RailsDatabaseConfiguration {
    private static final Pattern PATTERN = Pattern.compile("jdbc:(\\w+)://(.+):(\\d+)/(\\w+)");
    private final DatabaseConnection development;
    private final DatabaseConnection test;
    private final DatabaseConnection production;

    public RailsJdbcAsAdapterConnection(DatabaseConnection development, DatabaseConnection test, DatabaseConnection production) {
        this.development = development;
        this.test = test;
        this.production = production;
    }

    @Override
    public String railsGenerationParam() {
        return null;
    }

    @Override
    public void editConfig(RailsProject project) {
        this.editDatabaseYml(project.getProjectDirectory());
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatabaseYml(FileObject projectDir) {
        FileObject fo = projectDir.getFileObject("config/database.yml");
        if (fo != null) {
            BaseDocument bdoc = null;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    if (doc instanceof BaseDocument) {
                        bdoc = (BaseDocument)doc;
                        bdoc.atomicLock();
                    }
                    doc.remove(0, doc.getLength());
                    String insert = null;
                    String projectName = projectDir.getName();
                    insert = "development:\n" + this.buildConnectionConf(this.development) + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + this.buildConnectionConf(this.test) + "\n" + "production:\n" + this.buildConnectionConf(this.production);
                    doc.insertString(0, insert, null);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            finally {
                if (bdoc != null) {
                    bdoc.atomicUnlock();
                }
            }
        }
    }

    private String buildConnectionConf(DatabaseConnection connection) {
        AdapterParameters adapterParameters = connection != null ? RailsJdbcAsAdapterConnection.resolveAdapterParams(connection.getDatabaseURL()) : AdapterParameters.DEFAULT;
        String hostAndAdapter = "      host: " + adapterParameters.getHostName() + "\n" + "      adapter: " + adapterParameters.getAdapterName() + "\n";
        if (connection == null) {
            return hostAndAdapter;
        }
        String password = connection.getPassword() == null ? "" : connection.getPassword();
        return hostAndAdapter + "      database: " + adapterParameters.getDatabase() + "\n" + "      port: " + adapterParameters.getPort() + "\n" + "      username: " + connection.getUser() + "\n" + "      password: " + password + "\n";
    }

    static AdapterParameters resolveAdapterParams(String databaseURL) {
        Matcher m = PATTERN.matcher(databaseURL);
        if (!m.find() || m.groupCount() < 4) {
            return AdapterParameters.DEFAULT;
        }
        return new AdapterParameters(m.group(1), m.group(2), m.group(3), m.group(4));
    }

    @Override
    public String getDatabaseName(String projectName) {
        return projectName + "_development";
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return RailsAdapters.getTestDatabaseName(developmentDbName);
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return RailsAdapters.getProductionDatabaseName(developmentDbName);
    }

    static class AdapterParameters {
        private final String adapterName;
        private final String hostName;
        private final String port;
        private final String database;
        static final AdapterParameters DEFAULT = new AdapterParameters("mysql", "localhost", "3306", "");

        AdapterParameters(String adapterName, String hostName, String port, String database) {
            this.adapterName = adapterName;
            this.hostName = hostName;
            this.port = port;
            this.database = database;
        }

        public String getAdapterName() {
            return this.adapterName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getPort() {
            return this.port;
        }

        public String getDatabase() {
            return this.database;
        }
    }
}

