/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class RailsServerUiUtils {
    public static JComboBox getServerComboBox(RubyPlatform platform) {
        JComboBox result = new JComboBox();
        if (platform != null) {
            result.setModel(new ServerListModel(platform));
        }
        result.setRenderer(new ServerListCellRendered());
        return result;
    }

    public static void addDefaultGlassFishGem(ComboBoxModel servers, RubyPlatform platform) {
        if (platform == null || !platform.isJRuby()) {
            return;
        }
        for (int i = 0; i < servers.getSize(); ++i) {
            Object server = servers.getElementAt(i);
            if (!(server instanceof GlassFishGem)) continue;
            return;
        }
        ServerListModel model = (ServerListModel)servers;
        FakeGlassFishGem fakeGfGem = new FakeGlassFishGem();
        model.addServer(fakeGfGem);
    }

    public static boolean isValidServer(Object server) {
        return !(server instanceof FakeGlassFishGem);
    }

    public static boolean isGlassFishGem(Object server) {
        return server instanceof FakeGlassFishGem || server instanceof GlassFishGem;
    }

    public static void replaceFakeGlassFish(WizardDescriptor descriptor) {
        GemInfo glassFishGemInfo;
        RubyInstance server = (RubyInstance)descriptor.getProperty("serverInstance");
        if (!(server instanceof FakeGlassFishGem)) {
            return;
        }
        RubyPlatform platform = (RubyPlatform)descriptor.getProperty("platform");
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null) {
            return;
        }
        List versions = gemManager.getVersions("glassfish");
        GemInfo gemInfo = glassFishGemInfo = versions.isEmpty() ? null : (GemInfo)versions.get(0);
        if (glassFishGemInfo == null) {
            return;
        }
        GlassFishGem gfGem = new GlassFishGem(platform, glassFishGemInfo);
        descriptor.putProperty("serverInstance", (Object)gfGem);
    }

    private static class FakeGlassFishGem
    implements RubyInstance {
        @Override
        public String getServerUri() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(RailsServerUiUtils.class, (String)"LBL_FakeGlassFish");
        }

        @Override
        public RubyInstance.ServerState getServerState() {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> startServer(RubyPlatform platform) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> stopServer() {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> deploy(String applicationName, File applicationDir) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> stop(String applicationName) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> runApplication(RubyPlatform platform, String applicationName, File applicationDir) {
            return null;
        }

        @Override
        public boolean isPlatformSupported(RubyPlatform platform) {
            return false;
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
        }

        @Override
        public String getContextRoot(String applicationName) {
            return "";
        }

        @Override
        public int getRailsPort() {
            return -1;
        }

        @Override
        public String getServerCommand(RubyPlatform platform, String classpath, File applicationDir, int httpPort, boolean debug) {
            return null;
        }
    }

    private static class ServerListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public ServerListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            RubyInstance server = (RubyInstance)value;
            if (server != null) {
                this.setText(server.getDisplayName());
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            return this;
        }
    }

    public static class ServerListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<RubyInstance> servers;
        private Object selected;

        public ServerListModel(RubyPlatform platform) {
            this.servers = ServerRegistry.getDefault().getServers(platform);
            if (!this.servers.isEmpty()) {
                this.selected = this.servers.get(0);
            }
        }

        @Override
        public int getSize() {
            return this.servers.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.servers.get(index);
        }

        @Override
        public void setSelectedItem(Object server) {
            if (this.selected != server) {
                this.selected = server;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        void addServer(RubyInstance server) {
            boolean preludeFound = false;
            for (RubyInstance each : this.servers) {
                if (each instanceof RubyServer) continue;
                preludeFound = true;
                break;
            }
            if (!preludeFound) {
                this.servers.add(0, server);
                this.setSelectedItem(server);
            } else {
                this.servers.add(1, server);
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

