/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.customizer;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.util.EditableProperties;

public class RailsProjectProperties
extends SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(RailsProjectProperties.class.getName());
    public static final String RAILS_PORT = "rails.port";
    public static final String RAILS_SERVERTYPE = "rails.servertype";
    public static final String RAILS_URL = "rails.url";
    public static final String RAILS_SERVER_ARGS = "rails.serverargs";
    private static final String[] CONFIG_PROPS = new String[]{"rails.port", "rails.servertype", "rake.args", "rails.env", "rails.url", "main.file", "application.args", "ruby.options", "rails.serverargs", "platform.active"};
    private static final String[] CONFIG_PRIVATE_PROPS = new String[]{"rails.port", "rails.env", "rake.args", "application.args", "rails.serverargs", "platform.active"};
    private RubyInstance server;
    private String railsEnvironment;

    public RailsProjectProperties(RubyBaseProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        super(project, evaluator, updateHelper, genFileHelper, refHelper);
    }

    RailsProject getRailsProject() {
        return (RailsProject)((Object)this.getProject().getLookup().lookup(RailsProject.class));
    }

    protected String[] getConfigProperties() {
        return CONFIG_PROPS;
    }

    protected String[] getConfigPrivateProperties() {
        return CONFIG_PRIVATE_PROPS;
    }

    protected void prePropertiesStore() throws IOException {
    }

    protected void storeProperties(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        RubyPlatform platform;
        if (this.server != null) {
            privateProperties.remove((Object)RAILS_SERVERTYPE);
            projectProperties.setProperty(RAILS_SERVERTYPE, this.server.getServerUri());
        }
        if (this.getRailsEnvironment() != null) {
            privateProperties.setProperty("rails.env", this.getRailsEnvironment());
        }
        if ((platform = this.getPlatform()) == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        RubyPlatform.Info info = platform.getInfo();
        Util.logUsage(RailsProjectProperties.class, (String)"USG_PROJECT_CONFIG_RAILS", (Object[])new Object[]{info.getKind(), info.getPlatformVersion(), info.getGemVersion(), this.getServerIdForLogging(), "", ""});
    }

    private String getServerIdForLogging() {
        if (this.server != null) {
            return this.server.getDisplayName();
        }
        String serverURI = this.evaluator.getProperty(RAILS_SERVERTYPE);
        RubyInstance serverInstance = ServerRegistry.getDefault().getServer(serverURI, this.getPlatform());
        return serverInstance != null ? serverInstance.getDisplayName() : "";
    }

    RubyInstance getServer() {
        return this.server;
    }

    void setServer(RubyInstance server, String config) {
        ((Map)this.getRunConfigs().get(config)).put(RAILS_SERVERTYPE, server.getServerUri());
        this.server = server;
    }

    String getRailsEnvironment() {
        return this.railsEnvironment;
    }

    void setRailsEnvironment(String railsEnvironment, String config) {
        if (RailsProjectProperties.isEmpty(railsEnvironment)) {
            ((Map)this.getRunConfigs().get(config)).remove("rails.env");
        } else {
            ((Map)this.getRunConfigs().get(config)).put("rails.env", railsEnvironment);
        }
        this.railsEnvironment = railsEnvironment;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }
}

