/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public final class BreakpointsReader
implements Properties.Reader {
    private static final Logger LOGGER = Logger.getLogger(BreakpointsReader.class.getName());
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE_NUMBER = "lineNumber";
    private static final String PROPERTY_CONDITION = "condition";
    private static final String PROPERTY_EXCEPTION = "exception";

    public String[] getSupportedClassNames() {
        return new String[]{RubyBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties props) {
        if (typeID.equals(RubyLineBreakpoint.class.getName())) {
            Line line = BreakpointsReader.getLine(props.getString(PROPERTY_URL, null), props.getInt(PROPERTY_LINE_NUMBER, 1));
            if (line != null) {
                String condition = props.getString(PROPERTY_CONDITION, null);
                return RubyBreakpointManager.createLineBreakpoint(line, condition);
            }
        } else if (typeID.equals(RubyExceptionBreakpoint.class.getName())) {
            String exception = props.getString(PROPERTY_EXCEPTION, null);
            return RubyBreakpointManager.createExceptionBreakpoint(exception);
        }
        return null;
    }

    public void write(Object object, Properties props) {
        if (object instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint bp = (RubyLineBreakpoint)((Object)object);
            FileObject fo = bp.getFileObject();
            try {
                props.setString(PROPERTY_URL, fo.getURL().toString());
                props.setInt(PROPERTY_LINE_NUMBER, bp.getLine().getLineNumber());
                props.setString(PROPERTY_CONDITION, bp.getCondition());
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (object instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint bp = (RubyExceptionBreakpoint)((Object)object);
            props.setString(PROPERTY_EXCEPTION, bp.getException());
        } else {
            throw new IllegalArgumentException("Unknown breakpoint type: " + object);
        }
    }

    private static Line getLine(String url, int lineNumber) {
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            LOGGER.finer("Did not find FileObject. Malformed URL '" + url + "'");
            return null;
        }
        if (fo == null) {
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fo);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
        }
        return null;
    }
}

