/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.SecurityMechanismRetriever;

public class SecurityMechanismHelper {
    private static final String LIBERTY_PREFIX = "Liberty";
    private Collection<SecurityMechanism> allSecurityMechs;
    private Collection<SecurityMechanism> allMsgLevelSecurityMechs;
    private Collection<SecurityMechanism> allWSPLibertySecurityMechs;
    private Collection<SecurityMechanism> allWSCLibertySecurityMechs;
    private Collection<SecurityMechanism> allWSPSecurityMechs;
    private Collection<SecurityMechanism> allWSCSecurityMechs;
    private SecurityMechanismRetriever retriever;

    public SecurityMechanismHelper(String id) {
        this.retriever = new SecurityMechanismRetriever(id);
    }

    public Collection<SecurityMechanism> getAllSecurityMechanisms() {
        if (this.allSecurityMechs == null) {
            ArrayList<SecurityMechanism> list = new ArrayList<SecurityMechanism>();
            list.addAll(this.getAllMessageLevelSecurityMechanisms());
            list.addAll(this.getAllWSPLibertySecurityMechanisms());
            list.addAll(this.getAllWSCLibertySecurityMechanisms());
            this.allSecurityMechs = Collections.unmodifiableCollection(list);
        }
        return this.allSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllMessageLevelSecurityMechanisms() {
        if (this.allMsgLevelSecurityMechs == null) {
            this.allMsgLevelSecurityMechs = this.retriever.getAllMessageLevelSecurityMechanism();
        }
        return this.allMsgLevelSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSPLibertySecurityMechanisms() {
        if (this.allWSPLibertySecurityMechs == null) {
            Collection<SecurityMechanism> secMechs = this.retriever.getAllWSPLibertySecurityMechanisms();
            this.allWSPLibertySecurityMechs = new ArrayList<SecurityMechanism>();
            for (SecurityMechanism secMech : secMechs) {
                if (!secMech.getName().startsWith(LIBERTY_PREFIX)) continue;
                this.allWSPLibertySecurityMechs.add(secMech);
            }
            this.allWSPLibertySecurityMechs = Collections.unmodifiableCollection(this.allWSPLibertySecurityMechs);
        }
        return this.allWSPLibertySecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSCLibertySecurityMechanisms() {
        if (this.allWSCLibertySecurityMechs == null) {
            Collection<SecurityMechanism> secMechs = this.retriever.getAllWSCLibertySecurityMechanisms();
            this.allWSCLibertySecurityMechs = new ArrayList<SecurityMechanism>();
            for (SecurityMechanism secMech : secMechs) {
                if (!secMech.getName().startsWith(LIBERTY_PREFIX)) continue;
                this.allWSCLibertySecurityMechs.add(secMech);
            }
            this.allWSCLibertySecurityMechs = Collections.unmodifiableCollection(this.allWSCLibertySecurityMechs);
        }
        return this.allWSCLibertySecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSPSecurityMechanisms() {
        if (this.allWSPSecurityMechs == null) {
            this.allWSPSecurityMechs = new ArrayList<SecurityMechanism>();
            this.allWSPSecurityMechs.addAll(this.getAllMessageLevelSecurityMechanisms());
            this.allWSPSecurityMechs.addAll(this.getAllWSPLibertySecurityMechanisms());
            this.allWSPSecurityMechs = Collections.unmodifiableCollection(this.allWSPSecurityMechs);
        }
        return this.allWSPSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSCSecurityMechanisms() {
        if (this.allWSCSecurityMechs == null) {
            this.allWSCSecurityMechs = new ArrayList<SecurityMechanism>();
            this.allWSCSecurityMechs.addAll(this.getAllMessageLevelSecurityMechanisms());
            this.allWSCSecurityMechs.addAll(this.getAllWSCLibertySecurityMechanisms());
            this.allWSCSecurityMechs = Collections.unmodifiableCollection(this.allWSCSecurityMechs);
        }
        return this.allWSCSecurityMechs;
    }

    public Collection<String> getSecurityMechanismURIs(Collection<SecurityMechanism> secMechs) {
        ArrayList<String> uris = new ArrayList<String>();
        if (secMechs != null) {
            for (SecurityMechanism secMech : secMechs) {
                uris.add(secMech.getURI());
            }
        }
        return uris;
    }

    public Collection<SecurityMechanism> getSecurityMechanismsFromURIs(Collection<String> uris) {
        ArrayList<SecurityMechanism> secMechs = new ArrayList<SecurityMechanism>();
        Collection<SecurityMechanism> allMechs = this.getAllSecurityMechanisms();
        if (uris != null) {
            block0: for (String uri : uris) {
                for (SecurityMechanism mech : allMechs) {
                    if (!uri.equals(mech.getURI())) continue;
                    secMechs.add(mech);
                    continue block0;
                }
            }
        }
        return secMechs;
    }

    public Collection<String> getSecurityMechanismURIsFromNames(Collection<String> secMechNames) {
        ArrayList<String> uris = new ArrayList<String>();
        Collection<SecurityMechanism> allMechs = this.getAllSecurityMechanisms();
        for (String name : secMechNames) {
            for (SecurityMechanism mech : allMechs) {
                if (!name.equals(mech.getName())) continue;
                uris.add(mech.getURI());
            }
        }
        return uris;
    }
}

