/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class ProjectClassPathImplementation
implements ClassPathImplementation {
    private static final Logger LOGGER = Logger.getLogger(ProjectClassPathImplementation.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ProjectConfigListener projectConfigListener = new ProjectConfigListener();
    private final BuildConfigListener buildConfigListener = new BuildConfigListener();
    private List<PathResourceImplementation> resources;
    private final GrailsProjectConfig projectConfig;
    private GrailsPlatform.Version version;
    private final File projectRoot;
    private File pluginsDir;
    private File globalPluginsDir;
    private PluginsLibListener listenerPluginsLib;

    private ProjectClassPathImplementation(GrailsProjectConfig grailsProjectConfig) {
        this.projectConfig = grailsProjectConfig;
        this.projectRoot = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
        this.version = grailsProjectConfig.getGrailsPlatform().getVersion();
    }

    public static ProjectClassPathImplementation forProject(Project project) {
        GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)project);
        ProjectClassPathImplementation projectClassPathImplementation = new ProjectClassPathImplementation(grailsProjectConfig);
        BuildConfig buildConfig = ((GrailsProject)grailsProjectConfig.getProject()).getBuildConfig();
        buildConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)projectClassPathImplementation.buildConfigListener, (Object)buildConfig));
        grailsProjectConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)projectClassPathImplementation.projectConfigListener, (Object)grailsProjectConfig));
        return projectClassPathImplementation;
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    private List<PathResourceImplementation> getPath() {
        Comparable<GrailsPlugin> comparable;
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        this.addLibs(this.projectRoot, arrayList);
        GrailsPluginSupport grailsPluginSupport = GrailsPluginSupport.forProject(this.projectConfig.getProject());
        if (grailsPluginSupport != null && grailsPluginSupport.usesPlugin("gwt") && ((File)(object2 = new File(new File(this.projectRoot, SourceCategory.LIB.getRelativePath()), "gwt"))).exists() && ((File)object2).isDirectory()) {
            ProjectClassPathImplementation.addJars((File)object2, arrayList, false);
        }
        if (grailsPluginSupport != null && grailsPluginSupport.usesPlugin("app-engine") && (object2 = System.getenv("APPENGINE_HOME")) != null) {
            object = new File(new File((String)object2), "lib");
            comparable = new File((File)object, "shared");
            if (((File)comparable).exists() && ((File)comparable).isDirectory()) {
                ProjectClassPathImplementation.addJars(comparable, arrayList, true);
            }
            if (((File)(comparable = new File((File)object, "user"))).exists() && ((File)comparable).isDirectory()) {
                ProjectClassPathImplementation.addJars(comparable, arrayList, true);
            }
        }
        object2 = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig().getLocalPlugins();
        object = object2.iterator();
        while (object.hasNext()) {
            comparable = (GrailsPlugin)object.next();
            if (((GrailsPlugin)comparable).getPath() == null) continue;
            this.addLibs(((GrailsPlugin)comparable).getPath(), arrayList);
        }
        object = this.pluginsDir;
        comparable = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig().getProjectPluginsDir();
        if (this.pluginsDir == null || !this.pluginsDir.equals(comparable)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, comparable});
            this.pluginsDir = comparable;
        }
        if (grailsPluginSupport != null && this.pluginsDir.isDirectory()) {
            this.addPlugins(this.pluginsDir, arrayList, grailsPluginSupport.getProjectPluginFilter());
        }
        File file = this.globalPluginsDir;
        File file2 = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig().getGlobalPluginsDir();
        if (this.globalPluginsDir == null || !this.globalPluginsDir.equals(file2)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, comparable});
            this.globalPluginsDir = file2;
        }
        if (this.globalPluginsDir != null && this.globalPluginsDir.isDirectory()) {
            this.addPlugins(this.globalPluginsDir, arrayList, null);
        }
        if (this.listenerPluginsLib == null) {
            File file3 = FileUtil.normalizeFile((File)new File(this.projectRoot, "lib"));
            this.listenerPluginsLib = new PluginsLibListener(this);
            FileUtil.addFileChangeListener((FileChangeListener)this.listenerPluginsLib, (File)file3);
        }
        this.updateListener(this.listenerPluginsLib, (File)object, (File)comparable);
        this.updateListener(this.listenerPluginsLib, file, file2);
        return Collections.unmodifiableList(arrayList);
    }

    private void updateListener(FileChangeListener fileChangeListener, File file, File file2) {
        if (file == null || !file.equals(file2)) {
            if (file != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)fileChangeListener, (File)file);
            }
            if (file2 != null) {
                FileUtil.addFileChangeListener((FileChangeListener)fileChangeListener, (File)file2);
            }
        }
    }

    private void addPlugins(File file, List<PathResourceImplementation> list, GrailsPluginSupport.FolderFilter folderFilter) {
        for (String string : file.list()) {
            File file2 = new File(file, string);
            if (!file2.isDirectory() || folderFilter != null && !folderFilter.accept(string)) continue;
            this.addLibs(file2, list);
        }
    }

    private void addLibs(File file, List<PathResourceImplementation> list) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File file2 = new File(file, SourceCategory.LIB.getRelativePath());
        if (!file2.exists() || !file2.isDirectory()) {
            return;
        }
        ProjectClassPathImplementation.addJars(file2, list, false);
    }

    private static void addJars(File file, List<PathResourceImplementation> list, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    if (file2.isFile()) {
                        URL uRL = file2.toURI().toURL();
                        if (!FileUtil.isArchiveFile((URL)uRL)) continue;
                        uRL = FileUtil.getArchiveRoot((URL)uRL);
                        list.add(ClassPathSupport.createResource((URL)uRL));
                        continue;
                    }
                    if (!bl || !file2.isDirectory()) continue;
                    ProjectClassPathImplementation.addJars(file2, list, bl);
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private static class PluginsLibListener
    implements FileChangeListener {
        private final ProjectClassPathImplementation impl;

        public PluginsLibListener(ProjectClassPathImplementation projectClassPathImplementation) {
            this.impl = projectClassPathImplementation;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ProjectClassPathImplementation projectClassPathImplementation = this.impl;
            synchronized (projectClassPathImplementation) {
                this.impl.resources = null;
            }
            this.impl.support.firePropertyChange("resources", null, null);
        }
    }

    private class BuildConfigListener
    implements PropertyChangeListener {
        private BuildConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BuildConfig.BUILD_CONFIG_PLUGINS.equals(propertyChangeEvent.getPropertyName())) {
                LOGGER.log(Level.INFO, "Project classpath changed due to change in {0}", propertyChangeEvent.getPropertyName());
                ProjectClassPathImplementation projectClassPathImplementation = ProjectClassPathImplementation.this;
                synchronized (projectClassPathImplementation) {
                    ProjectClassPathImplementation.this.resources = null;
                }
                ProjectClassPathImplementation.this.support.firePropertyChange("resources", null, null);
            }
        }
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("grails.platform".equals(propertyChangeEvent.getPropertyName())) {
                GrailsPlatform grailsPlatform = ((GrailsProjectConfig)propertyChangeEvent.getSource()).getGrailsPlatform();
                GrailsPlatform.Version version = grailsPlatform.getVersion();
                if (GrailsPlatform.Version.VERSION_1_1.compareTo(version) <= 0 && GrailsPlatform.Version.VERSION_1_1.compareTo(ProjectClassPathImplementation.this.version) > 0 || GrailsPlatform.Version.VERSION_1_1.compareTo(version) > 0 && GrailsPlatform.Version.VERSION_1_1.compareTo(ProjectClassPathImplementation.this.version) <= 0) {
                    LOGGER.log(Level.INFO, "Project classpath changed due to change in {0}", propertyChangeEvent.getPropertyName());
                    ProjectClassPathImplementation projectClassPathImplementation = ProjectClassPathImplementation.this;
                    synchronized (projectClassPathImplementation) {
                        ProjectClassPathImplementation.this.resources = null;
                    }
                    ProjectClassPathImplementation.this.support.firePropertyChange("resources", null, null);
                }
                ProjectClassPathImplementation.this.version = version;
            }
        }
    }
}

