/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.templates;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.templates.GrailsArtifacts;
import org.netbeans.modules.groovy.grailsproject.templates.GrailsTemplates;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.ProgressLineProcessor;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewGrailsArtifactWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(NewGrailsArtifactWizardIterator.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private GrailsProject project;
    private SourceCategory sourceCategory;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup sourceGroup = GrailsArtifacts.getSourceGroupForCategory(this.project, GroovySources.getGroovySourceGroups((Sources)sources), this.sourceCategory);
        assert (sourceGroup != null);
        if (sourceGroup == null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)this.project, (SourceGroup[])sourceGroupArray)};
        }
        return new WizardDescriptor.Panel[]{GrailsTemplates.createArtifactChooser(this.project, sourceGroup, this.sourceCategory.getSuffix())};
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        assert (panelArray != null);
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(final ProgressHandle progressHandle) throws IOException {
        Object object;
        String string;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String string2 = Templates.getTargetName((WizardDescriptor)this.wiz);
        String string3 = NewGrailsArtifactWizardIterator.getPackageName(fileObject);
        String string4 = string3 == null || "".equals(string3.trim()) ? string2 : string3 + "." + string2;
        progressHandle.start(100);
        try {
            string = this.sourceCategory.getCommand();
            object = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
            String string5 = object.getDisplayName() + " (" + string + ")";
            final Callable callable = ExecutionSupport.getInstance().createSimpleCommand(string, GrailsProjectConfig.forProject((Project)this.project), new String[]{string4});
            final DialogLineProcessor dialogLineProcessor = new DialogLineProcessor();
            Callable<Process> callable2 = new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    Process process = (Process)callable.call();
                    dialogLineProcessor.setWriter(new OutputStreamWriter(process.getOutputStream()));
                    return process;
                }
            };
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, InputProcessors.bridge((LineProcessor)new ProgressLineProcessor(progressHandle, 100, 9))});
                }
            });
            executionDescriptor = executionDescriptor.errProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, InputProcessors.bridge((LineProcessor)dialogLineProcessor)});
                }
            });
            executionDescriptor = executionDescriptor.postExecution((Runnable)new RefreshProjectRunnable(this.project));
            ExecutionService executionService = ExecutionService.newService((Callable)callable2, (ExecutionDescriptor)executionDescriptor, (String)string5);
            Future future = executionService.run();
            try {
                Integer n = (Integer)future.get();
                if (n != 0) {
                    String string6 = NbBundle.getMessage(NewGrailsArtifactWizardIterator.class, (String)"WIZARD_ERROR_MESSAGE_ARTIFACT");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string6, 2));
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException.getCause());
            }
        }
        finally {
            progressHandle.progress(100);
            progressHandle.finish();
        }
        LOG.log(Level.FINEST, "Artifact Name  {0}", string4);
        fileObject.refresh();
        object = this.sourceCategory.getSuffix();
        string = object == null ? fileObject.getFileObject(string2, Templates.getTemplate((WizardDescriptor)this.wiz).getExt()) : fileObject.getFileObject(string2 + (String)object);
        if (string != null) {
            return Collections.singleton(string);
        }
        LOG.log(Level.WARNING, "Problem creating FileObject for {0} ", string4);
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)wizardDescriptor);
        this.sourceCategory = GrailsArtifacts.getCategoryForTemplate(fileObject);
        assert (this.sourceCategory != null);
        this.project = (GrailsProject)Templates.getProject((WizardDescriptor)wizardDescriptor).getLookup().lookup(GrailsProject.class);
        this.index = 0;
        this.panels = this.createPanels(wizardDescriptor);
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz = null;
        this.panels = null;
        this.sourceCategory = null;
        this.project = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private static String getPackageName(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Sources sources = ProjectUtils.getSources((Project)project);
        List list = GroovySources.getGroovySourceGroups((Sources)sources);
        String string = null;
        for (int i = 0; i < list.size() && string == null; ++i) {
            string = FileUtil.getRelativePath((FileObject)((SourceGroup)list.get(i)).getRootFolder(), (FileObject)fileObject);
        }
        if (string != null) {
            string = string.replaceAll("/", ".");
        }
        return string;
    }

    private static class DialogLineProcessor
    implements LineProcessor {
        private static final Pattern OVERWRITE_PATTERN = Pattern.compile("^.*\\s([^\\s]+\\.groovy) already exists\\. Overwrite\\? \\[y/n\\]$");
        private Writer writer;

        private DialogLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String string) {
            Writer writer = null;
            Object object = this;
            synchronized (object) {
                writer = this.writer;
            }
            if (writer != null && ((Matcher)(object = OVERWRITE_PATTERN.matcher(string))).matches()) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(NewGrailsArtifactWizardIterator.class, (String)"MSG_overwrite_file", (Object)((Matcher)object).group(1)), 0);
                try {
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                        writer.write("y\n");
                    } else {
                        writer.write("n\n");
                    }
                    writer.flush();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWriter(Writer writer) {
            DialogLineProcessor dialogLineProcessor = this;
            synchronized (dialogLineProcessor) {
                this.writer = writer;
            }
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

