/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertAnonymousToInner
extends AbstractHint {
    public ConvertAnonymousToInner() {
        super(true, true, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.NEW_CLASS);
    }

    static Fix computeFix(CompilationInfo compilationInfo, TreePath treePath, int n) {
        long l;
        if (treePath.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
            return null;
        }
        NewClassTree newClassTree = (NewClassTree)treePath.getLeaf();
        if (newClassTree.getClassBody() == null) {
            return null;
        }
        if (n != -1 && (long)n > (l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), newClassTree.getClassBody()))) {
            return null;
        }
        return new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getJavaSource(), compilationInfo.getFileObject());
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
        Fix fix = ConvertAnonymousToInner.computeFix(compilationInfo, treePath, n);
        if (fix == null) {
            return null;
        }
        List<Fix> list = Collections.singletonList(fix);
        String string = NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"HINT_ConvertAnonymousToInner");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)string, list, (FileObject)compilationInfo.getFileObject(), (int)n, (int)n));
    }

    @Override
    public String getId() {
        return ConvertAnonymousToInner.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"DN_ConvertAnonymousToInner");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"DESC_ConvertAnonymousToInner");
    }

    private static boolean isParent(TreePath treePath, TreePath treePath2) {
        while (treePath2 != null && treePath.getLeaf() != treePath2.getLeaf()) {
            treePath2 = treePath2.getParentPath();
        }
        if (treePath2 == null) {
            return false;
        }
        return treePath.getLeaf() == treePath2.getLeaf();
    }

    private static String generateName(CompilationInfo compilationInfo, TreePath treePath, String string) {
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        Integer n = null;
        if (scope == null) {
            return string + "Impl";
        }
        while (true) {
            String string2 = string + "Impl" + (n == null ? "" : n.toString());
            boolean bl = false;
            block1: for (Scope scope2 = scope; scope2 != null; scope2 = scope2.getEnclosingScope()) {
                for (Element element : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        return true;
                    }
                })) {
                    String string3;
                    if (!element.getKind().isClass() && !element.getKind().isInterface() || !string2.equals(string3 = element.getSimpleName().toString())) continue;
                    bl = true;
                    break block1;
                }
            }
            if (!bl) {
                return string2;
            }
            n = n != null ? n + 1 : 1;
        }
    }

    static void convertAnonymousToInner(WorkingCopy workingCopy, TreePath treePath) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object6;
        Object object7;
        Element element;
        TreePath treePath2;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        NewClassTree newClassTree = (NewClassTree)treePath.getLeaf();
        newClassTree = (NewClassTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importComments((Tree)newClassTree, treePath.getCompilationUnit());
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        new DetectUsedVars((CompilationInfo)workingCopy, treePath).scan(new TreePath(treePath, newClassTree.getClassBody()), linkedHashSet);
        boolean bl = new DetectUseOfNonStaticMembers((CompilationInfo)workingCopy, treePath).scan(new TreePath(treePath, newClassTree.getClassBody()), null) == Boolean.TRUE;
        for (treePath2 = treePath; treePath2 != null && treePath2.getLeaf().getKind() != Tree.Kind.CLASS; treePath2 = treePath2.getParentPath()) {
        }
        ClassTree classTree = (ClassTree)treePath2.getLeaf();
        Element element2 = workingCopy.getTrees().getElement(treePath2);
        boolean bl2 = false;
        for (TreePath treePath3 = treePath.getParentPath(); treePath3 != null; treePath3 = treePath3.getParentPath()) {
            if (treePath3.getLeaf().getKind() != Tree.Kind.NEW_CLASS) continue;
            bl2 = true;
            break;
        }
        TypeMirror typeMirror = workingCopy.getTrees().getTypeMirror(new TreePath(treePath, newClassTree.getIdentifier()));
        Element element3 = workingCopy.getTrees().getElement(new TreePath(treePath, newClassTree.getIdentifier()));
        boolean bl3 = true;
        Element element4 = element3;
        while (element4.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            if (!element4.getModifiers().contains((Object)Modifier.STATIC)) {
                bl3 = false;
                break;
            }
            element4 = element4.getEnclosingElement();
        }
        if (bl3) {
            while (element2.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                if (!element2.getModifiers().contains((Object)Modifier.STATIC)) {
                    bl3 = false;
                    break;
                }
                element2 = element2.getEnclosingElement();
            }
        }
        Tree tree = treeMaker.Type(typeMirror);
        Logger.getLogger(ConvertAnonymousToInner.class.getName()).log(Level.FINE, "usesNonStaticMembers = {0}", bl);
        TreePath treePath4 = ConvertAnonymousToInner.findSuperConstructorCall(treePath);
        boolean bl4 = element == null || element.asType() == null || element.asType().getKind() == TypeKind.ERROR;
        boolean bl5 = false;
        for (element = workingCopy.getTrees().getElement(treePath); element != null && element.getEnclosingElement() != null && element.getKind() != ElementKind.METHOD; element = element.getEnclosingElement()) {
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            bl5 = true;
            break;
        }
        EnumSet<Modifier> enumSet = null;
        enumSet = bl2 ? (bl3 && !bl || bl5 ? EnumSet.of(Modifier.STATIC) : EnumSet.noneOf(Modifier.class)) : (bl3 && !bl || bl5 ? EnumSet.of(Modifier.PRIVATE, Modifier.STATIC) : EnumSet.of(Modifier.PRIVATE));
        ModifiersTree modifiersTree = treeMaker.Modifiers(enumSet);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> arrayList3 = new ArrayList<ExpressionStatementTree>();
        ArrayList<? extends ExpressionTree> arrayList4 = new ArrayList<ExpressionTree>();
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<IdentifierTree> linkedList = null;
        if (treePath4 != null && !bl4) {
            object7 = workingCopy.getTrees().getElement(treePath4);
            if (object7 != null && object7.getKind() == ElementKind.CONSTRUCTOR) {
                object6 = (ExecutableElement)object7;
                object5 = workingCopy.getTrees().getTypeMirror(treePath);
                assert (object5.getKind() == TypeKind.DECLARED);
                object42 = (ExecutableType)workingCopy.getTypes().asMemberOf((DeclaredType)object5, (Element)object6);
                if (!object6.getParameters().isEmpty()) {
                    linkedList = new LinkedList();
                    object3 = object6.getParameters().iterator();
                    object2 = object42.getParameterTypes().iterator();
                    while (object3.hasNext() && object2.hasNext()) {
                        object = ((VariableElement)object3.next()).getSimpleName();
                        arrayList2.add(treeMaker.Variable(modifiersTree2, (CharSequence)object, treeMaker.Type(object2.next()), null));
                        linkedList.add(treeMaker.Identifier((CharSequence)object));
                    }
                }
            }
        } else if (bl4 && (object7 = Utilities.resolveArguments((CompilationInfo)workingCopy, treePath, newClassTree.getArguments())) != null) {
            linkedList = new LinkedList<IdentifierTree>();
            object6 = ((List)((Pair)object7).getA()).iterator();
            object5 = ((List)((Pair)object7).getB()).iterator();
            while (object6.hasNext() && object5.hasNext()) {
                object42 = (TypeMirror)object6.next();
                object3 = (String)object5.next();
                arrayList2.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)object3, treeMaker.Type((TypeMirror)object42), null));
                linkedList.add(treeMaker.Identifier((CharSequence)object3));
            }
        }
        if (linkedList != null) {
            arrayList3.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"super"), linkedList)));
        }
        arrayList4.addAll(newClassTree.getArguments());
        object7 = treeMaker.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        object6 = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        for (Object object42 : linkedHashSet) {
            arrayList.add(treeMaker.Variable((ModifiersTree)object7, (CharSequence)object42.getSimpleName(), treeMaker.Type(object42.asType()), null));
            arrayList2.add(treeMaker.Variable((ModifiersTree)object6, (CharSequence)object42.getSimpleName(), treeMaker.Type(object42.asType()), null));
            arrayList3.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object42.getSimpleName()), (ExpressionTree)treeMaker.Identifier((CharSequence)object42.getSimpleName()))));
            arrayList4.add(treeMaker.Identifier((CharSequence)object42.getSimpleName()));
        }
        object5 = new ArrayList<Tree>(newClassTree.getClassBody().getMembers());
        object5.remove(0);
        object42 = treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC));
        object3 = treeMaker.Method((ModifiersTree)object42, (CharSequence)"<init>", null, Collections.emptyList(), arrayList2, Collections.emptyList(), treeMaker.Block(arrayList3, false), null);
        arrayList.add(object3);
        arrayList.addAll((Collection<Object>)object5);
        object2 = ConvertAnonymousToInner.generateName((CompilationInfo)workingCopy, treePath, element3.getSimpleName().toString());
        object = treeMaker.Class(modifiersTree, (CharSequence)object2, Collections.emptyList(), element3.getKind().isClass() ? tree : null, element3.getKind().isClass() ? Collections.emptyList() : Collections.singletonList(tree), arrayList);
        workingCopy.rewrite((Tree)classTree, (Tree)treeMaker.addClassMember(classTree, (Tree)object));
        NewClassTree newClassTree2 = treeMaker.NewClass(null, Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)object2), arrayList4, null);
        workingCopy.rewrite((Tree)newClassTree, (Tree)newClassTree2);
    }

    @Override
    public void cancel() {
    }

    private static TreePath findSuperConstructorCall(TreePath treePath) {
        class FindSuperConstructorCall
        extends TreePathScanner<TreePath, Void> {
            private boolean stop;

            FindSuperConstructorCall() {
            }

            @Override
            public TreePath scan(Tree tree, Void void_) {
                if (this.stop) {
                    return null;
                }
                return (TreePath)super.scan(tree, void_);
            }

            @Override
            public TreePath visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
                if (methodInvocationTree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals(((IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString())) {
                    this.stop = true;
                    return this.getCurrentPath();
                }
                return null;
            }

            @Override
            public TreePath reduce(TreePath treePath, TreePath treePath2) {
                if (treePath == null) {
                    return treePath2;
                }
                return treePath;
            }
        }
        return (TreePath)new FindSuperConstructorCall().scan(treePath, null);
    }

    private static final class DetectUseOfNonStaticMembers
    extends TreePathScanner<Boolean, Void> {
        private CompilationInfo info;
        private TreePath newClassToConvert;

        private DetectUseOfNonStaticMembers(CompilationInfo compilationInfo, TreePath treePath) {
            this.info = compilationInfo;
            this.newClassToConvert = treePath;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree identifierTree, Void void_) {
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && (element.getKind().isField() || element.getKind() == ElementKind.METHOD) && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                return true;
            }
            return (Boolean)super.visitIdentifier(identifierTree, void_);
        }

        @Override
        public Boolean reduce(Boolean bl, Boolean bl2) {
            return bl == Boolean.TRUE || bl2 == Boolean.TRUE;
        }
    }

    private static final class DetectUsedVars
    extends TreePathScanner<Void, Set<VariableElement>> {
        private CompilationInfo info;
        private TreePath newClassToConvert;
        private static final Set<ElementKind> VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE);

        private DetectUsedVars(CompilationInfo compilationInfo, TreePath treePath) {
            this.info = compilationInfo;
            this.newClassToConvert = treePath;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Set<VariableElement> set) {
            TreePath treePath;
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            TreePath treePath2 = treePath = element != null ? this.info.getTrees().getPath(element) : null;
            if (element != null && treePath != null && VARIABLES.contains((Object)element.getKind()) && !ConvertAnonymousToInner.isParent(this.newClassToConvert, treePath)) {
                set.add((VariableElement)element);
            }
            return (Void)super.visitIdentifier(identifierTree, set);
        }
    }

    private static class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle tph;
        private JavaSource js;
        private FileObject file;
        private Position instantRenamePosition;

        public FixImpl(TreePathHandle treePathHandle, JavaSource javaSource, FileObject fileObject) {
            this.tph = treePathHandle;
            this.js = javaSource;
            this.file = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"FIX_ConvertAnonymousToInner");
        }

        public ChangeInfo implement() throws IOException {
            this.js.runModificationTask((Task)this).commit();
            if (this.instantRenamePosition != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)FixImpl.this.file).getLookup().lookup(EditorCookie.class);
                            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                            if (jEditorPaneArray == null) {
                                return;
                            }
                            jEditorPaneArray[0].setCaretPosition(FixImpl.this.instantRenamePosition.getOffset());
                            InstantRenamePerformer.invokeInstantRename((JTextComponent)jEditorPaneArray[0]);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                        }
                    }
                });
            }
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreePath treePath = this.tph.resolve((CompilationInfo)workingCopy);
            ConvertAnonymousToInner.convertAnonymousToInner(workingCopy, treePath);
            final int n = (int)workingCopy.getTrees().getSourcePositions().getStartPosition(workingCopy.getCompilationUnit(), ((NewClassTree)treePath.getLeaf()).getIdentifier());
            final Document document = workingCopy.getDocument();
            if (document != null) {
                document.render(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FixImpl.this.instantRenamePosition = document.createPosition(n);
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.getLogger(ConvertAnonymousToInner.class.getName()).log(Level.INFO, null, badLocationException);
                        }
                    }
                });
            }
        }
    }
}

