/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.UncaughtException;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

final class MagicSurroundWithTryCatchFix
implements Fix {
    private JavaSource js;
    private List<TypeMirrorHandle> thandles;
    private int offset;
    private ElementHandle<ExecutableElement> method;
    List<String> fqns;
    private static final String[] STREAM_ALIKE_CLASSES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer"};

    public MagicSurroundWithTryCatchFix(JavaSource javaSource, List<TypeMirrorHandle> list, int n, ElementHandle<ExecutableElement> elementHandle, List<String> list2) {
        this.js = javaSource;
        this.thandles = list;
        this.offset = n;
        this.method = elementHandle;
        this.fqns = list2;
    }

    public String getText() {
        return NbBundle.getMessage(MagicSurroundWithTryCatchFix.class, (String)"LBL_SurroundBlockWithTryCatch");
    }

    private boolean isStreamAlike(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        for (String string : STREAM_ALIKE_CLASSES) {
            TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
            if (!compilationInfo.getTypes().isAssignable(typeMirror, typeElement.asType())) continue;
            return true;
        }
        return false;
    }

    public ChangeInfo implement() throws IOException {
        this.js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                Object object;
                Object object2;
                TreePath treePath;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                for (treePath = workingCopy.getTreeUtilities().pathFor(MagicSurroundWithTryCatchFix.this.offset + 1); treePath != null && !UncaughtException.STATEMENT_KINDS.contains((Object)treePath.getLeaf().getKind()); treePath = treePath.getParentPath()) {
                }
                TreePath treePath2 = treePath;
                boolean bl = false;
                if (treePath2.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    object2 = workingCopy.getTrees().getElement(treePath2);
                    bl = MagicSurroundWithTryCatchFix.this.isStreamAlike((CompilationInfo)workingCopy, object2.asType());
                }
                for (object2 = treePath; object2 != null && ((TreePath)object2).getLeaf().getKind() != Tree.Kind.TRY && ((TreePath)object2).getLeaf().getKind() != Tree.Kind.CLASS && ((TreePath)object2).getLeaf().getKind() != Tree.Kind.CATCH; object2 = ((TreePath)object2).getParentPath()) {
                }
                boolean bl2 = false;
                if (((TreePath)object2).getLeaf().getKind() == Tree.Kind.TRY) {
                    object = (TryTree)((TreePath)object2).getLeaf();
                    for (Tree tree : treePath) {
                        if (object.getFinallyBlock() != tree) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        new TransformerImpl(workingCopy, MagicSurroundWithTryCatchFix.this.thandles, bl, treePath2).scan((TreePath)object2, null);
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    for (object = treePath; object != null && ((TreePath)object).getLeaf().getKind() != Tree.Kind.BLOCK; object = ((TreePath)object).getParentPath()) {
                    }
                    GeneratorUtilities.get((WorkingCopy)workingCopy).importComments(((TreePath)object).getLeaf(), ((TreePath)object).getCompilationUnit());
                    new TransformerImpl(workingCopy, MagicSurroundWithTryCatchFix.this.thandles, bl, treePath2).scan((TreePath)object, null);
                }
            }
        }).commit();
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MagicSurroundWithTryCatchFix magicSurroundWithTryCatchFix = (MagicSurroundWithTryCatchFix)object;
        if (!(this.js == magicSurroundWithTryCatchFix.js || this.js != null && this.js.equals(magicSurroundWithTryCatchFix.js))) {
            return false;
        }
        if (!((Object)this.fqns).equals(magicSurroundWithTryCatchFix.fqns)) {
            return false;
        }
        return this.method == magicSurroundWithTryCatchFix.method || this.method != null && this.method.equals(magicSurroundWithTryCatchFix.method);
    }

    public int hashCode() {
        int n = 5;
        n = 23 * n + (this.js != null ? this.js.hashCode() : 0);
        n = 23 * n + (this.method != null ? this.method.hashCode() : 0);
        return n;
    }

    private static StatementTree createExceptionsStatement(CompilationInfo compilationInfo, TreeMaker treeMaker, String string) {
        if (!ErrorFixesFakeHint.isUseExceptions()) {
            return null;
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("org.openide.util.Exceptions");
        if (typeElement == null) {
            return null;
        }
        return treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(treeMaker.QualIdent((Element)typeElement), (CharSequence)"printStackTrace"), Arrays.asList(treeMaker.Identifier((CharSequence)string))));
    }

    private static StatementTree createLogStatement(CompilationInfo compilationInfo, TreeMaker treeMaker, TreePath treePath, String string) {
        if (!ErrorFixesFakeHint.isUseLogger()) {
            return null;
        }
        if (!GeneratorUtils.supportsOverride((CompilationInfo)compilationInfo)) {
            return null;
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.util.logging.Logger");
        TypeElement typeElement2 = compilationInfo.getElements().getTypeElement("java.util.logging.Level");
        if (typeElement == null || typeElement2 == null) {
            return null;
        }
        ClassTree classTree = null;
        for (Tree tree2 : treePath) {
            if (Tree.Kind.CLASS != tree2.getKind()) continue;
            classTree = (ClassTree)tree2;
        }
        ExpressionTree expressionTree = classTree != null ? treeMaker.Identifier((CharSequence)(classTree.getSimpleName() + ".class.getName()")) : treeMaker.Literal((Object)"global");
        boolean bl = false;
        for (ImportTree tree3 : compilationInfo.getCompilationUnit().getImports()) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree3.getQualifiedIdentifier();
            if (!"Logger".equals(memberSelectTree.getIdentifier()) || "java.util.logging.Logger".equals(memberSelectTree.toString())) continue;
            bl = true;
        }
        MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(bl ? treeMaker.Identifier((CharSequence)typeElement.toString()) : treeMaker.QualIdent((Element)typeElement), (CharSequence)"getLogger"), Collections.singletonList(expressionTree));
        MemberSelectTree memberSelectTree = treeMaker.MemberSelect(treeMaker.QualIdent((Element)typeElement2), (CharSequence)"SEVERE");
        return treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)methodInvocationTree, (CharSequence)"log"), Arrays.asList(memberSelectTree, treeMaker.Literal(null), treeMaker.Identifier((CharSequence)string))));
    }

    private static StatementTree createPrintStackTraceStatement(CompilationInfo compilationInfo, TreeMaker treeMaker, String string) {
        return treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)string), (CharSequence)"printStackTrace"), Collections.emptyList()));
    }

    private static CatchTree createCatch(CompilationInfo compilationInfo, TreeMaker treeMaker, TreePath treePath, String string, TypeMirror typeMirror) {
        StatementTree statementTree = MagicSurroundWithTryCatchFix.createExceptionsStatement(compilationInfo, treeMaker, string);
        if (statementTree == null) {
            statementTree = MagicSurroundWithTryCatchFix.createLogStatement(compilationInfo, treeMaker, treePath, string);
        }
        if (statementTree == null) {
            statementTree = MagicSurroundWithTryCatchFix.createPrintStackTraceStatement(compilationInfo, treeMaker, string);
        }
        return treeMaker.Catch(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), null), treeMaker.Block(Collections.singletonList(statementTree), false));
    }

    static List<CatchTree> createCatches(CompilationInfo compilationInfo, TreeMaker treeMaker, List<TypeMirrorHandle> list, TreePath treePath) {
        String string = MagicSurroundWithTryCatchFix.inferName(compilationInfo, treePath);
        ArrayList<CatchTree> arrayList = new ArrayList<CatchTree>();
        for (TypeMirrorHandle typeMirrorHandle : list) {
            TypeMirror typeMirror = typeMirrorHandle.resolve(compilationInfo);
            if (typeMirror == null) continue;
            arrayList.add(MagicSurroundWithTryCatchFix.createCatch(compilationInfo, treeMaker, treePath, string, typeMirror));
        }
        return arrayList;
    }

    private static String inferName(CompilationInfo compilationInfo, TreePath treePath) {
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : compilationInfo.getElementUtilities().getLocalVars(scope, new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                return element != null && (element.getKind() == ElementKind.PARAMETER || element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.EXCEPTION_PARAMETER);
            }
        })) {
            hashSet.add(object.getSimpleName().toString());
        }
        int n = 0;
        Object object;
        while (hashSet.contains(object = "ex" + (n == 0 ? "" : "" + n))) {
            ++n;
        }
        return object;
    }

    private final class TransformerImpl
    extends TreePathScanner<Void, Void> {
        private WorkingCopy info;
        private List<TypeMirrorHandle> thandles;
        private boolean streamAlike;
        private TreePath statement;
        private TreeMaker make;

        public TransformerImpl(WorkingCopy workingCopy, List<TypeMirrorHandle> list, boolean bl, TreePath treePath) {
            this.info = workingCopy;
            this.thandles = list;
            this.streamAlike = bl;
            this.statement = treePath;
            this.make = workingCopy.getTreeMaker();
        }

        @Override
        public Void visitTry(TryTree tryTree, Void void_) {
            List<CatchTree> list = MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)this.info, this.make, this.thandles, this.statement);
            list.addAll(tryTree.getCatches());
            if (!this.streamAlike) {
                this.info.rewrite((Tree)tryTree, (Tree)this.make.Try(tryTree.getBlock(), list, tryTree.getFinallyBlock()));
            } else {
                VariableTree variableTree = (VariableTree)this.statement.getLeaf();
                VariableTree variableTree2 = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)variableTree.getName(), variableTree.getType(), (ExpressionTree)this.make.Literal(null));
                ExpressionStatementTree expressionStatementTree = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)variableTree.getName()), variableTree.getInitializer()));
                ArrayList arrayList = new ArrayList(tryTree.getFinallyBlock() != null ? tryTree.getFinallyBlock().getStatements() : Collections.emptyList());
                arrayList.add(this.createFinallyCloseBlockStatement(variableTree));
                BlockTree blockTree = this.make.Block(arrayList, false);
                this.info.rewrite((Tree)variableTree, (Tree)expressionStatementTree);
                TryTree tryTree2 = this.make.Try(tryTree.getBlock(), list, blockTree);
                TreePath treePath = this.statement;
                while (treePath.getLeaf() != tryTree) {
                    treePath = treePath.getParentPath();
                }
                if (treePath.getLeaf().getKind() == Tree.Kind.BLOCK) {
                    BlockTree blockTree2 = (BlockTree)treePath.getLeaf();
                    ArrayList<? extends StatementTree> arrayList2 = new ArrayList<StatementTree>(blockTree2.getStatements());
                    int n = arrayList2.indexOf(tryTree);
                    arrayList2.remove(n);
                    arrayList2.add(n, tryTree2);
                    arrayList2.add(n, variableTree2);
                    this.info.rewrite((Tree)blockTree2, (Tree)this.make.Block(arrayList2, false));
                } else {
                    BlockTree blockTree3 = this.make.Block(Arrays.asList(variableTree2, tryTree2), false);
                    this.info.rewrite((Tree)tryTree, (Tree)blockTree3);
                }
            }
            return null;
        }

        private StatementTree createFinallyCloseBlockStatement(VariableTree variableTree) {
            Object object22;
            Trees trees = this.info.getTrees();
            TypeMirror typeMirror = trees.getTypeMirror(this.statement);
            ElementUtilities elementUtilities = this.info.getElementUtilities();
            Iterable iterable = elementUtilities.getMembers(typeMirror, new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element element, TypeMirror typeMirror) {
                    return element.getKind() == ElementKind.METHOD && "close".equals(element.getSimpleName().toString());
                }
            });
            boolean bl = false;
            block0: for (Object object22 : iterable) {
                if (!object22.getParameters().isEmpty()) continue;
                for (TypeMirror typeMirror2 : object22.getThrownTypes()) {
                    if (!"java.io.IOException".equals(((Object)typeMirror2).toString())) continue;
                    bl = true;
                    continue block0;
                }
            }
            Name name = variableTree.getName();
            Object object3 = object22 = this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)name), (CharSequence)"close"), Collections.emptyList()));
            if (bl) {
                object3 = this.make.Try(this.make.Block(Collections.singletonList(object22), false), Collections.singletonList(MagicSurroundWithTryCatchFix.createCatch((CompilationInfo)this.info, this.make, this.statement, MagicSurroundWithTryCatchFix.inferName((CompilationInfo)this.info, this.statement), this.info.getElements().getTypeElement("java.io.IOException").asType())), null);
            }
            return object3;
        }

        private BlockTree createBlock(StatementTree ... statementTreeArray) {
            LinkedList<StatementTree> linkedList = new LinkedList<StatementTree>();
            for (StatementTree statementTree : statementTreeArray) {
                if (statementTree == null) continue;
                linkedList.add(statementTree);
            }
            return this.make.Block(linkedList, false);
        }

        @Override
        public Void visitBlock(BlockTree blockTree, Void void_) {
            Tree tree;
            List<CatchTree> list = MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)this.info, this.make, this.thandles, this.statement);
            BlockTree blockTree2 = blockTree;
            StatementTree statementTree = null;
            Tree tree2 = this.getCurrentPath().getParentPath().getLeaf();
            if (tree2.getKind() == Tree.Kind.METHOD && blockTree.getStatements().size() > 0 && (tree = (MethodTree)tree2).getReturnType() == null) {
                statementTree = blockTree.getStatements().get(0);
                blockTree2 = this.make.Block(blockTree.getStatements().subList(1, blockTree.getStatements().size()), false);
            }
            if (!this.streamAlike) {
                this.info.rewrite((Tree)blockTree, (Tree)this.createBlock(statementTree, this.make.Try(blockTree2, list, null)));
            } else {
                tree = (VariableTree)this.statement.getLeaf();
                VariableTree variableTree = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)tree.getName(), tree.getType(), (ExpressionTree)this.make.Identifier((CharSequence)"null"));
                ExpressionStatementTree expressionStatementTree = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)tree.getName()), tree.getInitializer()));
                BlockTree blockTree3 = this.make.Block(Collections.singletonList(this.createFinallyCloseBlockStatement((VariableTree)tree)), false);
                this.info.rewrite(tree, (Tree)expressionStatementTree);
                this.info.rewrite((Tree)blockTree, (Tree)this.createBlock(statementTree, variableTree, this.make.Try(blockTree2, list, blockTree3)));
            }
            return null;
        }
    }
}

