/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.AID;
import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.FileModelEntry;
import com.sun.javacard.filemodels.ParseErrorHandler;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DeploymentXmlInstanceEntry
implements FileModelEntry,
Cloneable {
    private AID instanceAID;
    private String deploymentParams = "";
    private int order;

    public DeploymentXmlInstanceEntry(AID instanceAID, String deploymentParams, int order) {
        this.setInstanceAID(instanceAID);
        this.setDeploymentParams(deploymentParams);
        this.order = order;
    }

    public DeploymentXmlInstanceEntry() {
    }

    public DeploymentXmlInstanceEntry(Element instanceElement, int instanceOrder, ParseErrorHandler handler) throws IOException {
        if (handler == null) {
            handler = ParseErrorHandler.DEFAULT;
        }
        this.order = instanceOrder;
        NodeList kids = instanceElement.getChildNodes();
        int len = kids.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = kids.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            if ("instance-AID".equals(el.getNodeName())) {
                String aidString = el.getTextContent();
                try {
                    AID aid = AID.parse(aidString);
                    this.setInstanceAID(aid);
                }
                catch (IllegalArgumentException e) {
                    handler.handleBadAIDError(e, aidString);
                }
                continue;
            }
            if (!"deployment-params".equals(el.getNodeName())) continue;
            this.setDeploymentParams(el.getTextContent());
        }
    }

    public Object clone() {
        DeploymentXmlInstanceEntry nue = new DeploymentXmlInstanceEntry();
        nue.instanceAID = this.instanceAID;
        nue.order = this.order;
        nue.deploymentParams = this.deploymentParams;
        return nue;
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder("        <instance>\n");
        sb.append("            <instance-AID>");
        sb.append(this.getInstanceAID());
        sb.append("</instance-AID>\n");
        sb.append("            <deployment-params><![CDATA[");
        sb.append(this.getDeploymentParams());
        sb.append("]]></deployment-params>\n");
        sb.append("        </instance>\n");
        return sb.toString();
    }

    public boolean isValid() {
        return this.getInstanceAID() != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentXmlInstanceEntry other = (DeploymentXmlInstanceEntry)obj;
        if (!(this.getInstanceAID() == other.getInstanceAID() || this.getInstanceAID() != null && this.getInstanceAID().equals(other.getInstanceAID()))) {
            return false;
        }
        return !(this.getDeploymentParams() == null ? other.getDeploymentParams() != null : !this.getDeploymentParams().equals(other.getDeploymentParams()));
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.getInstanceAID() != null ? this.getInstanceAID().hashCode() : 0);
        hash = 47 * hash + (this.getDeploymentParams() != null ? this.getDeploymentParams().hashCode() : 0);
        return hash;
    }

    public AID getInstanceAID() {
        return this.instanceAID;
    }

    public void setInstanceAID(AID instanceAID) {
        this.instanceAID = instanceAID;
    }

    public String getDeploymentParams() {
        return this.deploymentParams;
    }

    public void setDeploymentParams(String deploymentParams) {
        this.deploymentParams = deploymentParams;
    }

    public int getOrder() {
        return this.order;
    }

    public int compareTo(FileModelEntry o) {
        assert (o == null || o.getClass() == this.getClass());
        return this.getOrder() - o.getOrder();
    }

    public String getProblem() {
        if (this.getInstanceAID() == null) {
            return Portability.getString("MSG_NO_INSTANCE_AID");
        }
        return null;
    }
}

