/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;

public class WebServiceGroup {
    Set listeners = new HashSet();
    String groupId = null;
    String groupName = null;
    boolean userDefined = true;
    Set<String> webserviceIds = new HashSet<String>();

    public WebServiceGroup() {
        this(WebServiceListModel.getInstance().getUniqueWebServiceGroupId());
    }

    public WebServiceGroup(String id) {
        this.setId(id);
    }

    public void addWebServiceGroupListener(WebServiceGroupListener listener) {
        this.listeners.add(listener);
    }

    public void removeWebServiceGroupListener(WebServiceGroupListener listener) {
        this.listeners.remove(listener);
    }

    public void setId(String id) {
        this.groupId = id;
    }

    public String getId() {
        return this.groupId;
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String name) {
        this.modelDirty();
        this.groupName = name;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean v) {
        this.userDefined = v;
    }

    public void add(String webServiceId) {
        this.add(webServiceId, false);
    }

    public void remove(String webServiceId) {
        this.remove(webServiceId, false);
    }

    public void add(String webServiceId, boolean quietly) {
        block4: {
            block3: {
                if (this.webserviceIds.contains(webServiceId)) break block3;
                WebServiceData wsData = WebServiceListModel.getInstance().getWebService(webServiceId);
                wsData.setGroupId(this.getId());
                this.webserviceIds.add(webServiceId);
                if (quietly) {
                    return;
                }
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId, this.getId());
                    ((WebServiceGroupListener)iter.next()).webServiceAdded(evt);
                }
                break block4;
            }
            if (quietly) break block4;
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId, this.getId());
                ((WebServiceGroupListener)iter.next()).webServiceAdded(evt);
            }
        }
    }

    public void remove(String webServiceId, boolean quietly) {
        if (this.webserviceIds.contains(webServiceId)) {
            this.webserviceIds.remove(webServiceId);
            if (quietly) {
                return;
            }
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId, this.getId());
                ((WebServiceGroupListener)iter.next()).webServiceRemoved(evt);
            }
        }
    }

    public void modify(String webServiceId) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WebServiceGroupEvent evt = new WebServiceGroupEvent(webServiceId, this.getId());
            ((WebServiceGroupListener)iter.next()).webServiceRemoved(evt);
        }
    }

    public void setWebServiceIds(Set ids) {
        this.webserviceIds = ids;
        Iterator<String> iter = this.webserviceIds.iterator();
        while (iter.hasNext()) {
            WebServiceData wsData = WebServiceListModel.getInstance().getWebService(iter.next());
            wsData.setGroupId(this.getId());
        }
    }

    public Set<String> getWebServiceIds() {
        return this.webserviceIds;
    }

    private void modelDirty() {
        WebServiceListModel.getInstance().setDirty(true);
    }

    public boolean equals(Object o) {
        try {
            WebServiceGroup g2 = (WebServiceGroup)o;
            return g2.getId().equals(this.getId());
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            return false;
        }
    }
}

