/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DataraceImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DeadlockImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.threads.api.Datarace;
import org.netbeans.modules.dlight.threads.api.Deadlock;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

public final class PerfanDataStorage
implements PersistentDataStorage {
    public static final String ID = "PerfanDataStorage";
    public static final DataStorageType storageType = DataStorageTypeFactory.getInstance().getDataStorageType("PerfanDataStorage");
    private static final Logger log = DLightLogger.getLogger(PerfanDataStorage.class);
    private volatile ErprintSession er_print;
    private String experimentDirectory = null;
    private ExecutionEnvironment env;
    private final List<DataTableMetadata> tableMetadatas = new ArrayList<DataTableMetadata>();
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private volatile boolean isOMPExperiment = false;

    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
    }

    public boolean shutdown() {
        if (this.er_print != null) {
            this.er_print.close();
        }
        if (this.experimentDirectory != null) {
            StringWriter writer = new StringWriter();
            CommonTasksSupport.rmDir((ExecutionEnvironment)this.env, (String)this.experimentDirectory, (boolean)true, (Writer)writer);
            return writer.toString().trim().equals("");
        }
        return true;
    }

    public void setFilter(String filter) {
        this.er_print.setFilter(filter);
    }

    public boolean hasOMPCollected() {
        try {
            this.isOMPExperiment = false;
            Metrics metrics = this.er_print.getMetrics(true);
            if (metrics.mspec.indexOf("omp") != -1) {
                this.isOMPExperiment = true;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.isOMPExperiment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ExecutionEnvironment execEnv, String sproHome, String experimentDirectory, SunStudioFiltersProvider dataFiltersProvider) {
        PerfanDataStorage perfanDataStorage = this;
        synchronized (perfanDataStorage) {
            if (this.er_print != null) {
                this.er_print.close();
            }
            this.er_print = ErprintSession.createNew(execEnv, sproHome, experimentDirectory, dataFiltersProvider);
        }
    }

    public Object[] getCallees(long ref) {
        return null;
    }

    public Object[] getCallers(long ref) {
        return null;
    }

    public String[] getTopFunctions(Metrics metrics, int limit) {
        String[] result = null;
        try {
            result = this.er_print.getHotFunctions(metrics, limit, 0, true);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "getTopFunctions: " + ex.toString());
        }
        return result == null ? new String[]{} : result;
    }

    public Metrics getCollectedMetrics() {
        try {
            return this.er_print.getMetrics(true);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "getMetrics: " + ex.toString());
        }
        return Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_name), Arrays.asList(SunStudioDCConfiguration.c_name));
    }

    public String[] getTopFunctions(ErprintCommand command, Metrics metrics, int limit) throws InterruptedException {
        String[] result = null;
        try {
            result = this.er_print.getHotFunctions(command, metrics, limit, true);
        }
        catch (InterruptedIOException ex) {
            throw new InterruptedException();
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "getTopFunctions: " + ex.toString());
        }
        return result;
    }

    public FunctionStatistic getFunctionStatistic(String function) {
        FunctionStatistic result = null;
        try {
            result = this.er_print.getFunctionStatistic(function, false);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.WARNING, null, ex);
        }
        return result;
    }

    public FunctionStatistic getFunctionStatistic(FunctionCallImpl functionCall) {
        FunctionStatistic result = null;
        try {
            result = this.er_print.getFunctionStatistic(functionCall, false);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.WARNING, null, ex);
        }
        return result;
    }

    public List<? extends Datarace> getDataraces() {
        List<DataraceImpl> result = null;
        try {
            result = this.er_print.getDataRaces(true);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.INFO, null, ex);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public List<? extends Deadlock> getDeadlocks() {
        List<DeadlockImpl> result = null;
        try {
            result = this.er_print.getDeadlocks(true);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.INFO, null, ex);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public ExperimentStatistics fetchSummaryData() {
        ExperimentStatistics result = null;
        try {
            result = this.er_print.getExperimentStatistics(0, true);
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            log.log(Level.WARNING, null, ex);
        }
        return result;
    }

    public Collection<DataStorageType> getStorageTypes() {
        return PerfanDataStorageFactory.supportedTypes;
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public boolean hasData(DataTableMetadata data) {
        return data.isProvidedBy(this.tableMetadatas);
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        this.tableMetadatas.addAll(tableMetadatas);
    }

    public void addData(String tableName, List<DataRow> data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void syncAddData(String tableName, List<DataRow> data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadSchema() {
    }
}

