/*
 * Decompiled with CFR 0.152.
 */
package ricoh;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ByteArrayToolkit {
    public static final String LITTLE_ENDIAN = new String("little");
    public static final String BIG_ENDIAN = new String("big");
    private boolean isLittleEndian;
    private static ByteArrayToolkit instance = null;

    private ByteArrayToolkit() {
        String osArch = System.getProperty("os.arch");
        this.isLittleEndian = osArch.matches(".*86.*");
    }

    public static ByteArrayToolkit getToolkit() {
        if (instance == null) {
            instance = new ByteArrayToolkit();
        }
        return instance;
    }

    public void setEndianType(String type) {
        if (type.equals(LITTLE_ENDIAN)) {
            this.isLittleEndian = true;
        } else if (type.equals(BIG_ENDIAN)) {
            this.isLittleEndian = false;
        }
    }

    public int getInt(byte[] array, int offset) {
        int answer;
        if (this.isLittleEndian) {
            answer = array[offset + 3] & 0xFF;
            answer = answer << 8 | array[offset + 2] & 0xFF;
            answer = answer << 8 | array[offset + 1] & 0xFF;
            answer = answer << 8 | array[offset + 0] & 0xFF;
        } else {
            answer = array[offset + 0] & 0xFF;
            answer = answer << 8 | array[offset + 1] & 0xFF;
            answer = answer << 8 | array[offset + 2] & 0xFF;
            answer = answer << 8 | array[offset + 3] & 0xFF;
        }
        return answer;
    }

    public short getShort(byte[] array, int offset) {
        short answer;
        if (this.isLittleEndian) {
            answer = (short)(array[offset + 1] & 0xFF);
            answer = (short)(answer << 8 | (short)(array[offset + 0] & 0xFF));
        } else {
            answer = (short)(array[offset + 0] & 0xFF);
            answer = (short)(answer << 8 | (short)(array[offset + 1] & 0xFF));
        }
        return answer;
    }

    public long getLong(byte[] array, int offset) {
        long answer;
        if (this.isLittleEndian) {
            answer = array[offset + 7] & 0xFF;
            answer = answer << 8 | (long)(array[offset + 6] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 5] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 4] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 3] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 2] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 1] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 0] & 0xFF);
        } else {
            answer = array[offset + 0] & 0xFF;
            answer = answer << 8 | (long)(array[offset + 1] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 2] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 3] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 4] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 5] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 6] & 0xFF);
            answer = answer << 8 | (long)(array[offset + 7] & 0xFF);
        }
        return answer;
    }

    public double getDouble(byte[] array, int offset) {
        long answer = this.getLong(array, offset);
        return Double.longBitsToDouble(answer);
    }

    public static void main(String[] args) {
        if (args == null || args[0] == null) {
            System.out.println("Usage:");
            System.out.println("> java ByteArrayToolkit bmpfile");
            System.exit(1);
        }
        byte b = 66;
        byte m = 77;
        byte bHex = 66;
        byte mHex = 77;
        File testFile = new File(args[0]);
        byte[] array = new byte[10];
        long filesize = testFile.length();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(testFile));
            in.read(array, 0, 10);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File not found.");
            System.exit(0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("IO Error.\n" + ioe.getMessage());
            System.exit(0);
        }
        ByteArrayToolkit instance = ByteArrayToolkit.getToolkit();
        instance.setEndianType(LITTLE_ENDIAN);
        if (array[0] == bHex && array[0] == b) {
            System.out.println("matched b");
        }
        if (array[1] == mHex && array[1] == m) {
            System.out.println("matched m");
        }
        if (filesize == instance.getLong(array, 2)) {
            System.out.println("filesize matched");
        } else {
            System.out.println("fs filesize = " + filesize);
            System.out.println("bmp filesize = " + instance.getLong(array, 2));
        }
        System.out.println("end program");
        System.exit(1);
    }
}

