/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.FactoryMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PropertyHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.ResourceHyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class SpringXMLConfigHyperlinkProvider
implements HyperlinkProvider {
    private static final String P_NAMESPACE = "http://www.springframework.org/schema/p";
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();
    private PHyperlinkProcessor pHyperlinkProcessor = new PHyperlinkProcessor();

    public SpringXMLConfigHyperlinkProvider() {
        JavaClassHyperlinkProcessor javaClassHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueProcessor("bean", "class", javaClassHyperlinkProcessor);
        JavaMethodHyperlinkProcessor javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, 0);
        this.registerAttribValueProcessor("bean", "init-method", javaMethodHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "destroy-method", javaMethodHyperlinkProcessor);
        FactoryMethodHyperlinkProcessor factoryMethodHyperlinkProcessor = new FactoryMethodHyperlinkProcessor();
        this.registerAttribValueProcessor("bean", "factory-method", factoryMethodHyperlinkProcessor);
        javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, 0);
        this.registerAttribValueProcessor("lookup-method", "name", javaMethodHyperlinkProcessor);
        javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, -1);
        this.registerAttribValueProcessor("replaced-method", "name", javaMethodHyperlinkProcessor);
        ResourceHyperlinkProcessor resourceHyperlinkProcessor = new ResourceHyperlinkProcessor();
        this.registerAttribValueProcessor("import", "resource", resourceHyperlinkProcessor);
        PropertyHyperlinkProcessor propertyHyperlinkProcessor = new PropertyHyperlinkProcessor();
        this.registerAttribValueProcessor("property", "name", propertyHyperlinkProcessor);
        BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);
        this.registerAttribValueProcessor("bean", "factory-bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "depends-on", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "parent", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("lookup-method", "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("replaced-method", "replacer", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("property", "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("alias", "name", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("constructor-arg", "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("ref", "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("idref", "bean", beansRefHyperlinkProcessor);
        beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(false);
        this.registerAttribValueProcessor("idref", "local", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("ref", "local", beansRefHyperlinkProcessor);
    }

    private void registerAttribValueProcessor(String string, String string2, HyperlinkProcessor hyperlinkProcessor) {
        this.attribValueProcessors.put(this.createRegisteredName(string, string2), hyperlinkProcessor);
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        if (!(baseDocument.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        HyperlinkProcessor hyperlinkProcessor = this.locateProcessor(hyperlinkEnv);
        return hyperlinkProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        HyperlinkProcessor hyperlinkProcessor = this.locateProcessor(hyperlinkEnv);
        if (hyperlinkProcessor == null) {
            return new int[]{-1, -1};
        }
        return hyperlinkProcessor.getSpan(hyperlinkEnv);
    }

    public void performClickAction(Document document, int n) {
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        HyperlinkProcessor hyperlinkProcessor = this.locateProcessor(hyperlinkEnv);
        if (hyperlinkProcessor != null) {
            hyperlinkProcessor.process(hyperlinkEnv);
        }
    }

    private HyperlinkProcessor locateProcessor(HyperlinkEnv hyperlinkEnv) {
        HyperlinkProcessor hyperlinkProcessor = null;
        if (hyperlinkEnv.getType().isValueHyperlink()) {
            hyperlinkProcessor = this.locateAttributeValueProcessor(hyperlinkEnv.getTagName(), hyperlinkEnv.getAttribName());
            if (hyperlinkProcessor == null && this.isPNamespaceName(hyperlinkEnv, hyperlinkEnv.getAttribName())) {
                hyperlinkProcessor = this.pHyperlinkProcessor;
            }
        } else if (hyperlinkEnv.getType().isAttributeHyperlink() && this.isPNamespaceName(hyperlinkEnv, hyperlinkEnv.getAttribName())) {
            hyperlinkProcessor = this.pHyperlinkProcessor;
        }
        return hyperlinkProcessor;
    }

    protected String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.hasText(string)) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (StringUtils.hasText(string2)) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private HyperlinkProcessor locateAttributeValueProcessor(String string, String string2) {
        String string3 = this.createRegisteredName(string, string2);
        if (this.attribValueProcessors.containsKey(string3)) {
            return this.attribValueProcessors.get(string3);
        }
        string3 = this.createRegisteredName("*", string2);
        if (this.attribValueProcessors.containsKey(string3)) {
            return this.attribValueProcessors.get(string3);
        }
        return null;
    }

    private boolean isPNamespaceName(HyperlinkEnv hyperlinkEnv, String string) {
        String string2;
        String string3 = ContextUtilities.getPrefixFromNodeName(string);
        return string3 != null && P_NAMESPACE.equals(string2 = hyperlinkEnv.lookupNamespacePrefix(string3));
    }
}

