/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMapper {
    private static final EnumMapper mapper = new EnumMapper();
    private final Map<Class<? extends Enum>, Entry> enums = new ConcurrentHashMap<Class<? extends Enum>, Entry>();

    public static EnumMapper getInstance() {
        return mapper;
    }

    private static final int getIntegerValue(Enum e) {
        if (e instanceof IntegerEnum) {
            return ((IntegerEnum)((Object)e)).intValue();
        }
        return e.ordinal();
    }

    private Entry createEntry(Class<? extends Enum> enumClass) {
        Entry entry = new Entry();
        for (Enum e : enumClass.getEnumConstants()) {
            int intValue = EnumMapper.getIntegerValue(e);
            entry.enumMap.put(intValue, e);
            entry.valueMap.put(e, intValue);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Class<? extends Enum> enumClass) {
        Entry entry = this.enums.get(enumClass);
        if (entry == null) {
            Class<? extends Enum> clazz = enumClass;
            synchronized (clazz) {
                if (!this.enums.containsKey(enumClass)) {
                    entry = this.createEntry(enumClass);
                    this.enums.put(enumClass, entry);
                } else {
                    entry = this.enums.get(enumClass);
                }
            }
        }
        return entry;
    }

    public int intValue(Enum value2) {
        return EnumMapper.getIntegerValue(value2);
    }

    public <E extends Enum<E>> E valueOf(int value2, Class<E> enumClass) {
        Enum e = this.getEntry(enumClass).enumMap.get(value2);
        if (e == null) {
            try {
                return Enum.valueOf(enumClass, "__UNKNOWN_NATIVE_VALUE");
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("No known Enum mapping for value " + value2 + " of type " + enumClass.getName());
            }
        }
        return (E)((Enum)enumClass.cast(e));
    }

    private static final class Entry {
        Map<Integer, Enum> enumMap = new HashMap<Integer, Enum>();
        Map<Enum, Integer> valueMap = new HashMap<Enum, Integer>();

        private Entry() {
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }
}

