/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.util.BufferPool;
import com.kenai.jaffl.util.SimpleBufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBufferPool
implements BufferPool {
    private final int maxBufferSize;
    private final int maxItemsPerSize;
    private final int maxPoolIndex;
    private SimpleBufferPool[] pools;

    public MultiBufferPool(int maxBufferSize, int maxItemsPerSize, boolean threadSafe) {
        this.maxBufferSize = maxBufferSize;
        this.maxItemsPerSize = maxItemsPerSize;
        this.maxPoolIndex = MultiBufferPool.getSizeIndex(maxBufferSize);
        this.pools = new SimpleBufferPool[this.maxPoolIndex + 1];
        for (int i = 0; i <= this.maxPoolIndex; ++i) {
            this.pools[i] = threadSafe ? new SynchronizedPool(1 << i, maxItemsPerSize) : new SimpleBufferPool(1 << i, maxItemsPerSize);
        }
    }

    public MultiBufferPool(int maxBufferSize, int maxItemsPerSize) {
        this(maxBufferSize, maxItemsPerSize, false);
    }

    private static final int getSizeIndex(int size2) {
        int start2 = 0;
        int ssize = size2;
        if (ssize > 65535) {
            start2 += 16;
            ssize >>= 16;
        }
        if (ssize > 255) {
            start2 += 8;
            ssize >>= 8;
        }
        if (ssize > 15) {
            start2 += 4;
        }
        for (int i = start2; i < 32; ++i) {
            if (1 << i < size2) continue;
            return i;
        }
        return 32;
    }

    @Override
    public ByteBuffer get(int size2) {
        int index2 = MultiBufferPool.getSizeIndex(size2);
        if (index2 <= this.maxPoolIndex) {
            return this.pools[index2].get(size2);
        }
        return ByteBuffer.allocateDirect(size2).order(ByteOrder.nativeOrder());
    }

    @Override
    public void put(ByteBuffer buf) {
        int index2 = MultiBufferPool.getSizeIndex(buf.capacity());
        if (index2 <= this.maxPoolIndex) {
            this.pools[index2].put(buf);
        }
    }

    @Override
    public void putAll(List<ByteBuffer> list2) {
        for (ByteBuffer buf : list2) {
            this.put(buf);
        }
    }

    static class SynchronizedPool
    extends SimpleBufferPool {
        public SynchronizedPool(int bufferSize, int poolSize) {
            super(bufferSize, poolSize);
        }

        public synchronized ByteBuffer get(int size2) {
            return super.get(size2);
        }

        public synchronized void put(ByteBuffer buf) {
            super.put(buf);
        }
    }
}

