/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;

public final class Function
implements CallInfo {
    private final long contextAddress;
    private final long functionAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    private final Type returnType;
    private final Type[] paramTypes;
    private volatile boolean disposed = false;

    public Function(long address2, Type returnType, Type ... paramTypes) {
        this(address2, returnType, paramTypes, CallingConvention.DEFAULT, true);
    }

    public Function(long address2, Type returnType, Type[] paramTypes, CallingConvention convention) {
        this(address2, returnType, paramTypes, convention, true);
    }

    public Function(long address2, Type returnType, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        this.functionAddress = address2;
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0);
        long h = Foreign.getInstance().newFunction(address2, returnType.handle(), Type.nativeHandles(paramTypes), flags);
        if (h == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h;
        this.returnType = returnType;
        this.paramTypes = (Type[])paramTypes.clone();
        this.parameterCount = paramTypes.length;
        this.rawParameterSize = Foreign.getInstance().getFunctionRawParameterSize(h);
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getContextAddress() {
        return this.contextAddress;
    }

    public final long getFunctionAddress() {
        return this.functionAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index2) {
        return this.paramTypes[index2];
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("function already freed");
        }
        Foreign.getInstance().freeFunction(this.contextAddress);
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L && !this.disposed) {
                Foreign.getInstance().freeFunction(this.contextAddress);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            super.finalize();
        }
    }
}

