/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Enumerable::Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private String method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyEnumerator(runtime2, klass);
        }
    };

    public static void defineEnumerator(Ruby runtime2) {
        runtime2.getKernel().defineAnnotatedMethods(RubyEnumeratorKernel.class);
        RubyModule enm = runtime2.getClassFromPath("Enumerable");
        enm.defineAnnotatedMethods(RubyEnumeratorEnumerable.class);
        RubyClass enmr = runtime2.is1_9() ? runtime2.defineClass("Enumerator", runtime2.getObject(), ENUMERATOR_ALLOCATOR) : enm.defineClassUnder("Enumerator", runtime2.getObject(), ENUMERATOR_ALLOCATOR);
        enmr.includeModule(enm);
        enmr.defineAnnotatedMethods(RubyEnumerator.class);
        runtime2.setEnumerator(enmr);
        if (runtime2.is1_9()) {
            runtime2.getLoadService().lockAndRequire("generator_internal");
            RubyYielder.createYielderClass(runtime2);
        }
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.object = runtime2.getNil();
        this.initialize(runtime2.getNil(), (IRubyObject)RubyString.newEmptyString(runtime2), IRubyObject.NULL_ARRAY);
    }

    private RubyEnumerator(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] args2) {
        super(runtime2, runtime2.getEnumerator());
        this.initialize(object, method2, args2);
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), IRubyObject.NULL_ARRAY);
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject[] args2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), args2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        IRubyObject obj = context.getRuntime().getClass("Generator").callMethod(context, "new", new IRubyObject[0], block);
        return this.initialize19(context, obj, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object) {
        return this.initialize(object, (IRubyObject)context.getRuntime().fastNewSymbol("each"), NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, Block block) {
        return this.initialize(object, (IRubyObject)context.getRuntime().fastNewSymbol("each"), NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2) {
        return this.initialize(object, method2, NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, Block block) {
        return this.initialize(object, method2, NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg) {
        return this.initialize(object, method2, new IRubyObject[]{methodArg});
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg, Block block) {
        return this.initialize(object, method2, new IRubyObject[]{methodArg});
    }

    @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] methArgs = new IRubyObject[args2.length - 2];
        System.arraycopy(args2, 2, methArgs, 0, methArgs.length);
        return this.initialize(args2[0], args2[1], methArgs);
    }

    private IRubyObject initialize(IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs2) {
        this.object = object;
        this.method = method2.asJavaString();
        this.methodArgs = methodArgs2;
        this.setInstanceVariable("@__object__", object);
        this.setInstanceVariable("@__method__", method2);
        this.setInstanceVariable("@__args__", RubyArray.newArrayNoCopyLight(this.getRuntime(), methodArgs2));
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        return this.object.callMethod(context, this.method, this.methodArgs, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        Ruby runtime2 = context.getRuntime();
        ByteList bytes2 = new ByteList();
        bytes2.append((byte)35).append((byte)60);
        bytes2.append(this.getMetaClass().getName().getBytes());
        bytes2.append((byte)58).append((byte)32);
        if (recurse) {
            bytes2.append("...>".getBytes());
            return RubyString.newStringNoCopy(runtime2, bytes2).taint(context);
        }
        boolean tainted = this.isTaint();
        bytes2.append(RubyObject.inspect(context, this.object).getByteList());
        bytes2.append((byte)58);
        bytes2.append(this.method.getBytes());
        if (this.methodArgs.length > 0) {
            bytes2.append((byte)40);
            for (int i = 0; i < this.methodArgs.length; ++i) {
                bytes2.append(RubyObject.inspect(context, this.methodArgs[i]).getByteList());
                if (i < this.methodArgs.length - 1) {
                    bytes2.append((byte)44).append((byte)32);
                } else {
                    bytes2.append((byte)41);
                }
                if (!this.methodArgs[i].isTaint()) continue;
                tainted = true;
            }
        }
        bytes2.append((byte)62);
        RubyString result = RubyString.newStringNoCopy(runtime2, bytes2);
        if (tainted) {
            result.setTaint(true);
        }
        return result;
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getEnumerator().callMethod(context, "new", arg2);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getEnumerator(), "new", arg1, arg2);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getEnumerator(), "new", arg1, arg2, arg3);
    }

    private static IRubyObject with_index_common(ThreadContext context, IRubyObject self, Block block, String rubyMethodName, IRubyObject arg2) {
        int index2;
        Ruby runtime2 = context.getRuntime();
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorize(runtime2, self, rubyMethodName) : RubyEnumerator.enumeratorize(runtime2, self, rubyMethodName, runtime2.newFixnum(index2));
        }
        IRubyObject[] args2 = new IRubyObject[]{};
        RubyEnumerator e = (RubyEnumerator)self;
        if (e.methodArgs != null) {
            args2 = e.methodArgs;
        }
        return RubyEnumerable.callEach(runtime2, context, self, args2, new EachWithIndex(context, block, index2));
    }

    @JRubyMethod(name={"each_with_index"}, frame=true)
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "each_with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(name={"with_index"}, frame=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject with_index(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(name={"with_index"}, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject with_index19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(name={"with_index"}, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject with_index19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", arg2);
    }

    @JRubyMethod(name={"next"}, frame=true)
    public static IRubyObject next(ThreadContext context, IRubyObject self) {
        context.getRuntime().getLoadService().lockAndRequire("generator_internal");
        return self.callMethod(context, "next");
    }

    @JRubyMethod(name={"rewind"}, frame=true)
    public static IRubyObject rewind(ThreadContext context, IRubyObject self) {
        context.getRuntime().getLoadService().lockAndRequire("generator_internal");
        return self.callMethod(context, "rewind");
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext ctx, Block block, int index2) {
            this.block = block;
            this.runtime = ctx.getRuntime();
            this.index = index2;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            return this.block.call(context, new IRubyObject[]{this.runtime.newArray(RubyEnumerable.checkArgs(this.runtime, iargs), (IRubyObject)this.runtime.newFixnum(this.index++))});
        }
    }

    public static final class RubyEnumeratorEnumerable {
        public static IRubyObject each_slice(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = RubyNumeric.num2int(arg2);
            final Ruby runtime2 = context.getRuntime();
            if (size2 <= 0) {
                throw runtime2.newArgumentError("invalid slice size");
            }
            final RubyArray[] result = new RubyArray[]{runtime2.newArray(size2)};
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    result[0].append(largs[0]);
                    if (result[0].size() == size2) {
                        block.yield(ctx, result[0]);
                        result[0] = runtime2.newArray(size2);
                    }
                    return runtime2.getNil();
                }
            });
            if (result[0].size() > 0) {
                block.yield(context, result[0]);
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"each_slice"})
        public static IRubyObject each_slice19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_slice(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_slice", arg2);
        }

        @JRubyMethod(name={"enum_slice"})
        public static IRubyObject enum_slice19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_slice(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "enum_slice", arg2);
        }

        public static IRubyObject each_cons(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = (int)RubyNumeric.num2long(arg2);
            final Ruby runtime2 = context.getRuntime();
            if (size2 <= 0) {
                throw runtime2.newArgumentError("invalid size");
            }
            final RubyArray result = runtime2.newArray(size2);
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result.size() == size2) {
                        result.shift(ctx);
                    }
                    result.append(largs[0]);
                    if (result.size() == size2) {
                        block.yield(ctx, result.aryDup());
                    }
                    return runtime2.getNil();
                }
            });
            return runtime2.getNil();
        }

        @JRubyMethod(name={"each_cons"})
        public static IRubyObject each_cons19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_cons(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_cons", arg2);
        }

        @JRubyMethod(name={"enum_cons"})
        public static IRubyObject enum_cons19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_cons(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "enum_cons", arg2);
        }

        @JRubyMethod(name={"each_with_object"}, frame=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject each_with_object(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RubyEnumeratorEnumerable.with_object_common(context, self, arg2, block, "each_with_object");
        }

        @JRubyMethod(name={"with_object"}, frame=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject with_object(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RubyEnumeratorEnumerable.with_object_common(context, self, arg2, block, "with_object");
        }

        private static IRubyObject with_object_common(ThreadContext context, IRubyObject self, final IRubyObject arg2, final Block block, String rubyMethodName) {
            final Ruby runtime2 = context.getRuntime();
            if (!block.isGiven()) {
                return RubyEnumerator.enumeratorize(runtime2, self, rubyMethodName, arg2);
            }
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    block.call(ctx, new IRubyObject[]{runtime2.newArray(largs[0], arg2)});
                    return runtime2.getNil();
                }
            });
            return arg2;
        }
    }

    public static final class RubyEnumeratorKernel {
        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, Block block) {
            return RubyEnumerator.newEnumerator(context, self);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RubyEnumerator.newEnumerator(context, self, arg2);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RubyEnumerator.newEnumerator(context, self, arg0, arg1);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = self;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return context.getRuntime().getEnumerator().callMethod(context, "new", newArgs);
        }
    }
}

