/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarDeclNode
extends AssignableNode
implements INameNode {
    private String name;

    public ClassVarDeclNode(ISourcePosition position, String name2, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSVARDECLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassVarDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return ClassVarDeclNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            throw runtime2.newTypeError("no class/module to define class variable");
        }
        return rubyClass.fastSetClassVar(this.name, this.getValueNode().interpret(runtime2, context, self, aBlock));
    }

    @Override
    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        if (runtime2.isVerbose() && context.getRubyClass().isSingleton()) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.DECLARING_SCLASS_VARIABLE, this.getPosition(), "Declaring singleton class variable.", new Object[0]);
        }
        ASTInterpreter.getClassVariableBase(context, runtime2).fastSetClassVar(this.name, value2);
        return runtime2.getNil();
    }
}

