/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundArray
extends Operand {
    Operand _a1;
    Operand _a2;

    public CompoundArray(Operand a1, Operand a2) {
        this._a1 = a1;
        this._a2 = a2;
    }

    @Override
    public boolean isConstant() {
        return this._a1.isConstant() && this._a2.isConstant();
    }

    public String toString() {
        return this._a1 + ", *" + this._a2;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        Operand p2;
        this._a1 = this._a1.getSimplifiedOperand(valueMap);
        this._a2 = this._a2.getSimplifiedOperand(valueMap);
        Operand p1 = this._a1;
        if (p1 instanceof Variable) {
            p1 = ((Variable)p1).getValue(valueMap);
        }
        if ((p2 = this._a2) instanceof Variable) {
            p2 = ((Variable)p2).getValue(valueMap);
        }
        if (p1 instanceof Array && p2 instanceof Array) {
            Operand[] p1Elts = ((Array)p1)._elts;
            Operand[] p2Elts = ((Array)p2)._elts;
            Operand[] newElts = new Operand[p1Elts.length + p2Elts.length];
            System.arraycopy(p1Elts, 0, newElts, 0, p1Elts.length);
            System.arraycopy(p2Elts, 0, newElts, p1Elts.length, p2Elts.length);
            return new Array(newElts);
        }
        return this;
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return null;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this._a1.addUsedVariables(l);
        this._a2.addUsedVariables(l);
    }
}

