/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private ScriptingContainer container;
    private Node node;
    private ManyVarsDynamicScope scope;
    private Script script;

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope) {
        this(container, node, scope, null);
    }

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope, Script script) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
    }

    public Node getNode() {
        return this.node;
    }

    public ManyVarsDynamicScope getScope() {
        return this.scope;
    }

    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        BiVariableMap vars = this.container.getVarMap();
        boolean sharing_variables = true;
        Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
        if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            sharing_variables = false;
        }
        try {
            RubyInstanceConfig.CompileMode mode2;
            if (sharing_variables) {
                vars.inject(this.scope, 0, null);
                runtime2.getCurrentContext().pushScope(this.scope);
            }
            IRubyObject ret = (mode2 = runtime2.getInstanceConfig().getCompileMode()) == RubyInstanceConfig.CompileMode.FORCE ? runtime2.runScriptBody(this.script) : runtime2.runInterpreter(this.node);
            if (sharing_variables) {
                vars.retrieve(ret);
            }
            IRubyObject iRubyObject = ret;
            return iRubyObject;
        }
        catch (RaiseException e) {
            runtime2.printError(e.getException());
            throw new EvalFailedException(e.getMessage(), e);
        }
        catch (StackOverflowError soe) {
            throw runtime2.newSystemStackError("stack level too deep", soe);
        }
        catch (Throwable e) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    throw new EvalFailedException(ex);
                }
            }
            throw new EvalFailedException(e);
        }
        finally {
            if (sharing_variables) {
                runtime2.getCurrentContext().popScope();
            }
            vars.terminate();
        }
    }
}

