/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Pointer"}, parent="AbstractMemory")
public class Pointer
extends AbstractMemory {
    public static RubyClass createPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Pointer", module.getClass("AbstractMemory"), PointerAllocator.INSTANCE);
        result.defineAnnotatedMethods(Pointer.class);
        result.defineAnnotatedConstants(Pointer.class);
        module.defineClassUnder("NullPointerError", runtime2.getRuntimeError(), runtime2.getRuntimeError().getAllocator());
        result.fastSetConstant("NULL", new Pointer(runtime2, result, new NullMemoryIO(runtime2)));
        return result;
    }

    Pointer(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz, new NullMemoryIO(runtime2), 0L);
    }

    public Pointer(Ruby runtime2, DirectMemoryIO io2) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2);
    }

    public Pointer(Ruby runtime2, DirectMemoryIO io2, long size2, int typeSize) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2, size2, typeSize);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2) {
        super(runtime2, klass, io2, Long.MAX_VALUE);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2, long size2) {
        super(runtime2, klass, io2, size2);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2, long size2, int typeSize) {
        super(runtime2, klass, io2, size2, typeSize);
    }

    public static final RubyClass getPointerClass(Ruby runtime2) {
        return runtime2.fastGetModule("FFI").fastGetClass("Pointer");
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject address2) {
        this.io = Factory.getInstance().wrapDirectMemory(context.getRuntime(), RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = 1;
        return this;
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject address2) {
        this.io = Factory.getInstance().wrapDirectMemory(context.getRuntime(), RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = Pointer.calculateSize(context, type2);
        return this;
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getMemoryIO().isNull());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        return RubyString.newString(context.getRuntime(), String.format("Pointer [address=%x]", this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex2 = Long.toHexString(this.getAddress());
        return RubyString.newString(context.getRuntime(), String.format("#<Pointer address=0x%s>", hex2));
    }

    @JRubyMethod(name={"address", "to_i"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getAddress());
    }

    public final long getAddress() {
        return ((DirectMemoryIO)this.getMemoryIO()).getAddress();
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), (DirectMemoryIO)this.getMemoryIO().slice(offset2), this.size == Long.MAX_VALUE ? Long.MAX_VALUE : this.size - offset2, this.typeSize);
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2, long size2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), (DirectMemoryIO)this.getMemoryIO().slice(offset2, size2), size2, this.typeSize);
    }

    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), this.getMemoryIO().getMemoryIO(offset2), Long.MAX_VALUE);
    }

    private static final class PointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new PointerAllocator();

        private PointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new Pointer(runtime2, klazz);
        }
    }
}

