/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatUsers;
import org.netbeans.modules.tomcat5.wizard.InstallPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AddInstanceIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String[] CONTENT_DATA = new String[]{NbBundle.getMessage(AddInstanceIterator.class, (String)"LBL_InstallationAndLoginDetails")};
    private WizardDescriptor wizard;
    private InstallPanel panel;
    private final TomcatManager.TomcatVersion tomcatVersion;

    public AddInstanceIterator(TomcatManager.TomcatVersion tomcatVersion) {
        this.tomcatVersion = tomcatVersion;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public String name() {
        return null;
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> hashSet = new HashSet<InstanceProperties>();
        String string = this.getDisplayName();
        String string2 = this.panel.getVisual().getUrl();
        String string3 = this.panel.getVisual().getUsername();
        String string4 = this.panel.getVisual().getPassword();
        try {
            Object object;
            InstanceProperties instanceProperties = InstanceProperties.createInstanceProperties((String)string2, (String)string3, (String)string4, (String)string);
            Properties properties = this.panel.getVisual().getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                instanceProperties.setProperty((String)object, properties.getProperty((String)object));
            }
            instanceProperties.setProperty("runningCheckTimeout", Integer.toString(2000));
            hashSet.add(instanceProperties);
            this.checkStartupScript(this.panel.getVisual().getHomeDir());
            object = null;
            try {
                switch (this.panel.getVisual().getTomcatVersion()) {
                    case TOMCAT_50: {
                        object = (TomcatManager)TomcatFactory.create50().getDeploymentManager(string2, string3, string4);
                        break;
                    }
                    case TOMCAT_55: {
                        object = (TomcatManager)TomcatFactory.create55().getDeploymentManager(string2, string3, string4);
                        break;
                    }
                    default: {
                        object = (TomcatManager)TomcatFactory.create60().getDeploymentManager(string2, string3, string4);
                        break;
                    }
                }
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                Logger.getLogger(AddInstanceIterator.class.getName()).log(Level.SEVERE, null, deploymentManagerCreationException);
                return hashSet;
            }
            ((TomcatManager)object).ensureCatalinaBaseReady();
            if (this.panel.getVisual().createUserEnabled()) {
                File file = new File(((TomcatManager)object).getTomcatProperties().getCatalinaDir(), "conf/tomcat-users.xml");
                TomcatUsers.createUser(file, string3, string4);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(AddInstanceIterator.class.getName()).log(Level.WARNING, null, iOException);
        }
        return hashSet;
    }

    public boolean hasPrevious() {
        return false;
    }

    public boolean hasNext() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        if (this.panel == null) {
            this.panel = new InstallPanel(this.tomcatVersion);
        }
        this.setContentData((JComponent)this.panel.getComponent());
        this.setContentSelectedIndex((JComponent)this.panel.getComponent());
        return this.panel;
    }

    private void setContentData(JComponent jComponent) {
        if (jComponent.getClientProperty(PROP_CONTENT_DATA) == null) {
            jComponent.putClientProperty(PROP_CONTENT_DATA, CONTENT_DATA);
        }
    }

    private void setContentSelectedIndex(JComponent jComponent) {
        if (jComponent.getClientProperty(PROP_CONTENT_SELECTED_INDEX) == null) {
            jComponent.putClientProperty(PROP_CONTENT_SELECTED_INDEX, 0);
        }
    }

    private String getDisplayName() {
        return (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
    }

    private void checkStartupScript(File file) {
        String string = Utilities.isWindows() ? "catalina.bat" : "catalina.sh";
        boolean bl = new File(file, "bin/" + string).exists();
        String string2 = Utilities.isWindows() ? "setclasspath.bat" : "setclasspath.sh";
        boolean bl2 = new File(file, "bin/" + string2).exists();
        if (!bl || !bl2) {
            File file2 = TomcatInstallUtil.getBundledHome();
            if (this.tomcatVersion != TomcatManager.TomcatVersion.TOMCAT_55 || file2 == null || !file2.exists()) {
                String string3 = !bl && !bl2 ? NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_scripts_fix_by_hand", (Object)string, (Object)string2) : NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_script_fix_by_hand", (Object)(!bl ? string : string2));
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                String string4 = !bl && !bl2 ? NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_scripts", (Object)string, (Object)string2) : NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_script", (Object)(!bl ? string : string2));
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string4, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                    try {
                        if (file2 != null) {
                            if (!bl) {
                                FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(file2, "bin/" + string)), (FileObject)FileUtil.toFileObject((File)new File(file, "bin")), (String)string.substring(0, string.indexOf(".")));
                            }
                            if (!bl2) {
                                FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(file2, "bin/" + string2)), (FileObject)FileUtil.toFileObject((File)new File(file, "bin")), (String)string2.substring(0, string2.indexOf(".")));
                            }
                        }
                    }
                    catch (IOException iOException) {
                        string4 = NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_startup_scripts_copy_failed");
                        confirmation = new NotifyDescriptor.Message((Object)string4, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    }
                }
            }
        }
    }
}

