/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.input;

import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;

public class RobotDriver
extends LightSupportiveDriver {
    private boolean haveOldPos;
    private boolean smooth = false;
    private double oldX;
    private double oldY;
    private static final double CONSTANT1 = 0.75;
    private static final double CONSTANT2 = 12.0;
    protected ClassReference robotReference = null;
    protected QueueTool qtool = new QueueTool();
    protected Timeout autoDelay;

    public RobotDriver(Timeout autoDelay, String[] supported) {
        super(supported);
        this.qtool.setOutput(TestOut.getNullOutput());
        this.autoDelay = autoDelay;
    }

    public RobotDriver(Timeout autoDelay, String[] supported, boolean smooth) {
        this(autoDelay, supported);
        this.smooth = smooth;
    }

    public RobotDriver(Timeout autoDelay) {
        this(autoDelay, new String[]{"org.netbeans.jemmy.operators.ComponentOperator"});
    }

    public RobotDriver(Timeout autoDelay, boolean smooth) {
        this(autoDelay);
        this.smooth = smooth;
    }

    public void pressMouse(int mouseButton, int modifiers) {
        this.pressModifiers(modifiers);
        this.makeAnOperation("mousePress", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
    }

    public void releaseMouse(int mouseButton, int modifiers) {
        this.makeAnOperation("mouseRelease", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
        this.releaseModifiers(modifiers);
    }

    public void moveMouse(int x, int y) {
        if (!this.smooth) {
            this.makeAnOperation("mouseMove", new Object[]{new Integer(x), new Integer(y)}, new Class[]{Integer.TYPE, Integer.TYPE});
        } else {
            double targetX = x;
            double targetY = y;
            if (this.haveOldPos) {
                double currX = this.oldX;
                double currY = this.oldY;
                double vx = 0.0;
                double vy = 0.0;
                while (Math.round(currX) != Math.round(targetX) || Math.round(currY) != Math.round(targetY)) {
                    vx = vx * 0.75 + (targetX - currX) / 12.0 * 0.25;
                    vy = vy * 0.75 + (targetY - currY) / 12.0 * 0.25;
                    this.makeAnOperation("mouseMove", new Object[]{new Integer((int)Math.round(currX += vx)), new Integer((int)Math.round(currY += vy))}, new Class[]{Integer.TYPE, Integer.TYPE});
                }
            } else {
                this.makeAnOperation("mouseMove", new Object[]{new Integer((int)Math.round(targetX)), new Integer((int)Math.round(targetY))}, new Class[]{Integer.TYPE, Integer.TYPE});
            }
            this.haveOldPos = true;
            this.oldX = targetX;
            this.oldY = targetY;
        }
    }

    public void clickMouse(int x, int y, int clickCount, int mouseButton, int modifiers, Timeout mouseClick) {
        this.pressModifiers(modifiers);
        this.moveMouse(x, y);
        this.makeAnOperation("mousePress", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
        for (int i = 1; i < clickCount; ++i) {
            this.makeAnOperation("mouseRelease", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
            this.makeAnOperation("mousePress", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
        }
        mouseClick.sleep();
        this.makeAnOperation("mouseRelease", new Object[]{new Integer(mouseButton)}, new Class[]{Integer.TYPE});
        this.releaseModifiers(modifiers);
    }

    public void dragMouse(int x, int y, int mouseButton, int modifiers) {
        this.moveMouse(x, y);
    }

    public void dragNDrop(int start_x, int start_y, int end_x, int end_y, int mouseButton, int modifiers, Timeout before, Timeout after) {
        this.moveMouse(start_x, start_y);
        this.pressMouse(mouseButton, modifiers);
        before.sleep();
        this.moveMouse(end_x, end_y);
        after.sleep();
        this.releaseMouse(mouseButton, modifiers);
    }

    public void pressKey(int keyCode, int modifiers) {
        this.pressModifiers(modifiers);
        this.makeAnOperation("keyPress", new Object[]{new Integer(keyCode)}, new Class[]{Integer.TYPE});
    }

    public void releaseKey(int keyCode, int modifiers) {
        this.releaseModifiers(modifiers);
        this.makeAnOperation("keyRelease", new Object[]{new Integer(keyCode)}, new Class[]{Integer.TYPE});
    }

    protected void makeAnOperation(String method, Object[] params, Class[] paramClasses) {
        if (this.robotReference == null) {
            this.initRobot();
        }
        try {
            this.robotReference.invokeMethod(method, params, paramClasses);
            this.synchronizeRobot();
        }
        catch (InvocationTargetException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (IllegalStateException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (NoSuchMethodException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (IllegalAccessException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
    }

    protected void synchronizeRobot() {
        RobotDriver robotDriver = this;
        if (!robotDriver.qtool.isDispatchThread() && (JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.QUEUE_MODEL_MASK) != 0) {
            if (this.robotReference == null) {
                this.initRobot();
            }
            try {
                this.robotReference.invokeMethod("waitForIdle", null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void pressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.pressKey(16, modifiers & 0xFFFFFFFE);
        } else if ((modifiers & 0x20) != 0) {
            this.pressKey(65406, modifiers & 0xFFFFFFDF);
        } else if ((modifiers & 8) != 0) {
            this.pressKey(18, modifiers & 0xFFFFFFF7);
        } else if ((modifiers & 4) != 0) {
            this.pressKey(157, modifiers & 0xFFFFFFFB);
        } else if ((modifiers & 2) != 0) {
            this.pressKey(17, modifiers & 0xFFFFFFFD);
        }
    }

    protected void releaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.releaseKey(16, modifiers & 0xFFFFFFFE);
        } else if ((modifiers & 0x20) != 0) {
            this.releaseKey(65406, modifiers & 0xFFFFFFDF);
        } else if ((modifiers & 8) != 0) {
            this.releaseKey(18, modifiers & 0xFFFFFFF7);
        } else if ((modifiers & 4) != 0) {
            this.releaseKey(157, modifiers & 0xFFFFFFFB);
        } else if ((modifiers & 2) != 0) {
            this.releaseKey(17, modifiers & 0xFFFFFFFD);
        }
    }

    private void initRobot() {
        RobotDriver robotDriver = this;
        if (robotDriver.qtool.isDispatchThread()) {
            this.doInitRobot();
        } else {
            this.qtool.invokeAndWait(new Runnable(){

                public void run() {
                    RobotDriver.this.doInitRobot();
                }
            });
        }
    }

    private void doInitRobot() {
        try {
            ClassReference robotClassReverence = new ClassReference("java.awt.Robot");
            this.robotReference = new ClassReference(robotClassReverence.newInstance(null, null));
            this.robotReference.invokeMethod("setAutoDelay", new Object[]{new Integer((int)(this.autoDelay != null ? this.autoDelay.getValue() : 0L))}, new Class[]{Integer.TYPE});
        }
        catch (InvocationTargetException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (IllegalStateException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (NoSuchMethodException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (IllegalAccessException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (ClassNotFoundException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
        catch (InstantiationException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", e);
        }
    }
}

