/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task.support;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.util.Assert;

public class ConcurrentExecutorAdapter
implements Executor {
    private final TaskExecutor taskExecutor;

    public ConcurrentExecutorAdapter(TaskExecutor taskExecutor) {
        Assert.notNull(taskExecutor, "TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public void execute(Runnable command) {
        try {
            this.taskExecutor.execute(command);
        }
        catch (TaskRejectedException ex) {
            throw new RejectedExecutionException(ex.getMessage(), ex);
        }
    }
}

