/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SQLHistoryManager {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history.xml";
    public static final String SAVE_STATEMENTS_MAX_LIMIT_ENTERED = "100";
    private static SQLHistoryManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(SQLHistory.class.getName());
    private List<SQLHistory> sqlList = new ArrayList<SQLHistory>();
    private int listSize;
    private FileObject historyRoot;

    private SQLHistoryManager() {
    }

    public static SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return this.listSize;
    }

    public FileObject getHistoryRoot() {
        return this.historyRoot;
    }

    public void setHistoryRoot(FileObject root) {
        this.historyRoot = root;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }

    public void saveSQL(SQLHistory sqlStored) {
        this.sqlList.add(sqlStored);
    }

    public void save(FileObject userdirRoot) {
        try {
            this.setHistoryRoot(userdirRoot.getFileObject(SQL_HISTORY_FOLDER));
            if (null == this.historyRoot || !this.historyRoot.isValid()) {
                this.historyRoot = FileUtil.createFolder((FileObject)userdirRoot, (String)SQL_HISTORY_FOLDER);
            }
            SQLHistoryPersistenceManager.getInstance().create(this.historyRoot, this.sqlList);
            this.sqlList.clear();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage());
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryManager.class, (String)"MSG_ErrorParsingHistoryFile"));
        }
    }

    public List<SQLHistory> getSQLHistory() {
        return this.sqlList;
    }

    public List<SQLHistory> retrieve() {
        return new ArrayList<SQLHistory>();
    }

    public List<String> retrieve(String url) {
        ArrayList<String> sqlAsString = new ArrayList<String>();
        if (!this.getUrlsUsed().isEmpty()) {
            for (SQLHistory historyItem : this.sqlList) {
                String sql = historyItem.getSql();
                if (!url.equals(historyItem.getUrl())) continue;
                sqlAsString.add(sql);
            }
        }
        return sqlAsString;
    }

    private List<String> getUrlsUsed() {
        ArrayList<String> urls = new ArrayList<String>();
        for (SQLHistory historyItem : this.sqlList) {
            String url = historyItem.getUrl();
            if (urls.contains(url)) continue;
            urls.add(url);
        }
        return urls;
    }

    public int updateList(int limit, String historyFilePath, FileObject root) throws SQLHistoryException {
        List<Object> updatedSQLHistoryList = new ArrayList();
        int numItemsToRemove = 0;
        try {
            updatedSQLHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve(root);
            if (limit >= updatedSQLHistoryList.size()) {
                return -1;
            }
            numItemsToRemove = updatedSQLHistoryList.size() - limit;
            for (int i = 0; i < numItemsToRemove; ++i) {
                updatedSQLHistoryList.remove(0);
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryPanel.class, (String)"MSG_RuntimeErrorRetrievingHistory") + ex);
        }
        this.sqlList = updatedSQLHistoryList;
        return numItemsToRemove;
    }
}

