/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public class NamespaceAliasImpl
extends OffsetableDeclarationBase<CsmNamespaceAlias>
implements CsmNamespaceAlias,
RawNamable {
    private final CharSequence alias;
    private final CharSequence namespace;
    private final CharSequence[] rawName;
    private CsmUID<CsmNamespace> referencedNamespaceUID = null;
    private CsmUID<CsmScope> scopeUID = null;

    public NamespaceAliasImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) {
        super(aST, csmFile);
        AST aST2;
        this._setScope(csmScope);
        this.rawName = NamespaceAliasImpl.createRawName(aST);
        this.alias = NameCache.getManager().getString((CharSequence)aST.getText());
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 6; aST2 = aST2.getNextSibling()) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (aST2 == null) {
            if (FileImpl.reportErrors) {
                int n = aST.getLine();
                int n2 = aST.getColumn();
                AST aST3 = aST.getFirstChild();
                if (aST3 != null) {
                    n = aST3.getLine();
                    n2 = aST3.getColumn();
                }
                System.err.println("Corrupted AST for namespace alias in " + csmFile.getAbsolutePath() + ' ' + n + ":" + n2);
            }
            this.namespace = CharSequences.empty();
        } else {
            for (aST2 = aST2.getNextSibling(); aST2 != null; aST2 = aST2.getNextSibling()) {
                stringBuilder.append(aST2.getText());
            }
            this.namespace = QualifiedNameCache.getManager().getString((CharSequence)stringBuilder.toString());
        }
        if (!bl) {
            Utils.setSelfUID(this);
        }
    }

    private void _setScope(CsmScope csmScope) {
        this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
        assert (this.scopeUID != null || csmScope == null);
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        assert (csmScope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        return csmScope;
    }

    public CsmNamespace getReferencedNamespace() {
        CsmScope csmScope;
        CsmNamespace csmNamespace = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(this.namespace, true);
        if (csmNamespace == null && (csmScope = this.getScope()) instanceof CsmNamespace) {
            StringBuilder stringBuilder = new StringBuilder(((CsmNamespace)csmScope).getQualifiedName());
            stringBuilder.append("::");
            stringBuilder.append(this.namespace);
            csmNamespace = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(stringBuilder, true);
        }
        return csmNamespace;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_ALIAS;
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public CharSequence getName() {
        return this.getAlias();
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmScope csmScope = this.getScope();
        if ((csmScope instanceof CsmNamespace || csmScope instanceof CsmNamespaceDefinition) && (charSequence = ((CsmQualifiedNamedElement)csmScope).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    private static CharSequence[] createRawName(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 6; aST2 = aST2.getNextSibling()) {
        }
        if (aST2 != null && (aST2 = aST2.getNextSibling()) != null && aST2.getType() == 500) {
            return AstUtil.getRawName(aST2.getFirstChild());
        }
        return new CharSequence[0];
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.alias + '=' + this.namespace;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope csmScope = this._getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.alias != null);
        PersistentUtils.writeUTF(this.alias, dataOutput);
        assert (this.namespace != null);
        PersistentUtils.writeUTF(this.namespace, dataOutput);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedNamespaceUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public NamespaceAliasImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.alias = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.alias != null);
        this.namespace = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.namespace != null);
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedNamespaceUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

