/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.RequestProcessor;

final class CreateFilesWorker {
    private final ProjectBase project;
    private final RequestProcessor PROJECT_FILES_WORKER = new RequestProcessor("Project Files", CndUtils.getNumberCndWorkerThreads());

    CreateFilesWorker(ProjectBase projectBase) {
        this.project = projectBase;
    }

    void createProjectFilesIfNeed(List<NativeFileItem> list, boolean bl, Set<NativeFileItem> set, ProjectSettingsValidator projectSettingsValidator) {
        ArrayList<FileImpl> arrayList = new ArrayList<FileImpl>();
        ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        int n = list.size();
        int n2 = CndUtils.getNumberCndWorkerThreads() * 3;
        CountDownLatch countDownLatch = new CountDownLatch(n2);
        int n3 = n / n2 + 1;
        Iterator<NativeFileItem> iterator = list.iterator();
        for (int i = 0; i < n2; ++i) {
            ArrayList<NativeFileItem> arrayList3 = new ArrayList<NativeFileItem>(n3);
            for (int j = 0; j < n3 && iterator.hasNext(); ++j) {
                arrayList3.add(iterator.next());
            }
            CreateFileRunnable createFileRunnable = new CreateFileRunnable(countDownLatch, arrayList3, bl, set, projectSettingsValidator, this.project, arrayList, arrayList2, atomicBoolean);
            this.PROJECT_FILES_WORKER.post((Runnable)createFileRunnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!arrayList.isEmpty()) {
            DeepReparsingUtils.reparseOnEdit(arrayList, this.project, true);
        }
        if (!arrayList2.isEmpty()) {
            DeepReparsingUtils.reparseOnPropertyChanged(arrayList2, this.project);
        }
    }

    private static class CreateFileRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<NativeFileItem> nativeFileItems;
        private final boolean sources;
        private final Set<NativeFileItem> removedFiles;
        private final ProjectSettingsValidator validator;
        private final ProjectBase project;
        private final List<FileImpl> reparseOnEdit;
        private final List<NativeFileItem> reparseOnPropertyChanged;
        private final AtomicBoolean enougth;

        private CreateFileRunnable(CountDownLatch countDownLatch, List<NativeFileItem> list, boolean bl, Set<NativeFileItem> set, ProjectSettingsValidator projectSettingsValidator, ProjectBase projectBase, List<FileImpl> list2, List<NativeFileItem> list3, AtomicBoolean atomicBoolean) {
            this.countDownLatch = countDownLatch;
            this.nativeFileItems = list;
            this.sources = bl;
            this.removedFiles = set;
            this.validator = projectSettingsValidator;
            this.project = projectBase;
            this.reparseOnEdit = list2;
            this.reparseOnPropertyChanged = list3;
            this.enougth = atomicBoolean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (NativeFileItem nativeFileItem : this.nativeFileItems) {
                    if (this.createProjectFilesIfNeedRun(nativeFileItem, this.sources, this.removedFiles, this.validator, this.reparseOnEdit, this.reparseOnPropertyChanged, this.enougth)) continue;
                    return;
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }

        private boolean createProjectFilesIfNeedRun(NativeFileItem nativeFileItem, boolean bl, Set<NativeFileItem> set, ProjectSettingsValidator projectSettingsValidator, List<FileImpl> list, List<NativeFileItem> list2, AtomicBoolean atomicBoolean) {
            if (atomicBoolean.get()) {
                return false;
            }
            if (this.project.isDisposing()) {
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", this.project.getName());
                }
                return false;
            }
            if (set.contains(nativeFileItem)) {
                return true;
            }
            assert (nativeFileItem.getFile() != null) : "native file item must have valid File object";
            if (TraceFlags.DEBUG) {
                ModelSupport.trace(nativeFileItem);
            }
            try {
                this.project.createIfNeed(nativeFileItem, bl, projectSettingsValidator, list, list2);
                if (this.project.isValidating() && RepositoryUtils.getRepositoryErrorCount(this.project) > 0) {
                    atomicBoolean.set(true);
                    return false;
                }
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
            return true;
        }
    }
}

