/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;
import org.openide.util.Lookup;

public class ListenersImpl
extends CsmListeners {
    private final WeakList<CsmModelListener> modelListeners = new WeakList();
    private final WeakList<CsmModelStateListener> modelStateListeners = new WeakList();

    public void addModelListener(CsmModelListener csmModelListener) {
        this.modelListeners.add(csmModelListener);
    }

    public void removeModelListener(CsmModelListener csmModelListener) {
        this.modelListeners.remove(csmModelListener);
    }

    public void addProgressListener(CsmProgressListener csmProgressListener) {
        ProgressSupport.instance().addProgressListener(csmProgressListener);
    }

    public void removeProgressListener(CsmProgressListener csmProgressListener) {
        ProgressSupport.instance().removeProgressListener(csmProgressListener);
    }

    public void addModelStateListener(CsmModelStateListener csmModelStateListener) {
        this.modelStateListeners.add(csmModelStateListener);
    }

    public void removeModelStateListener(CsmModelStateListener csmModelStateListener) {
        this.modelStateListeners.remove(csmModelStateListener);
    }

    static ListenersImpl getImpl() {
        return (ListenersImpl)CsmListeners.getDefault();
    }

    private Iterable<? extends CsmModelListener> getModelListeners() {
        Collection collection = Lookup.getDefault().lookupAll(CsmModelListener.class);
        return collection.isEmpty() ? this.modelListeners : this.modelListeners.join(collection);
    }

    private Iterable<? extends CsmModelStateListener> getModelStateListeners() {
        Collection collection = Lookup.getDefault().lookupAll(CsmModelStateListener.class);
        return collection.isEmpty() ? this.modelStateListeners : this.modelStateListeners.join(collection);
    }

    void fireProjectOpened(ProjectBase projectBase) {
        projectBase.onAddedToModel();
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.projectOpened((CsmProject)projectBase);
            }
            catch (AssertionError assertionError) {
                DiagnosticExceptoins.register((Throwable)((Object)assertionError));
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireProjectClosed(CsmProject csmProject) {
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.projectClosed(csmProject);
            }
            catch (AssertionError assertionError) {
                DiagnosticExceptoins.register((Throwable)((Object)assertionError));
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireModelChanged(CsmChangeEvent csmChangeEvent) {
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.modelChanged(csmChangeEvent);
            }
            catch (AssertionError assertionError) {
                DiagnosticExceptoins.register((Throwable)((Object)assertionError));
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    void fireModelStateChanged(CsmModelState csmModelState, CsmModelState csmModelState2) {
        for (CsmModelStateListener csmModelStateListener : this.getModelStateListeners()) {
            try {
                csmModelStateListener.modelStateChanged(csmModelState, csmModelState2);
            }
            catch (AssertionError assertionError) {
                DiagnosticExceptoins.register((Throwable)((Object)assertionError));
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }
}

