/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.text.NbDocument;

public class GsfSemanticLayer
extends AbstractHighlightsContainer
implements DocumentListener {
    private SortedSet<SequenceElement> colorings;
    private int version;
    private List<Edit> edits;
    private Map<Language, Map<ColoringAttributes.Coloring, AttributeSet>> CACHE = new HashMap<Language, Map<ColoringAttributes.Coloring, AttributeSet>>();
    private Document doc;
    private static final SortedSet<SequenceElement> EMPTY_TREE_SET = new TreeSet<SequenceElement>();

    public static GsfSemanticLayer getLayer(Class id, Document doc) {
        GsfSemanticLayer l = (GsfSemanticLayer)doc.getProperty(id);
        if (l == null) {
            l = new GsfSemanticLayer(doc);
            doc.putProperty(id, l);
        }
        return l;
    }

    private GsfSemanticLayer(Document doc) {
        this.doc = doc;
        this.colorings = EMPTY_TREE_SET;
        this.version = -1;
    }

    void setColorings(final SortedSet<SequenceElement> colorings, final int version) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GsfSemanticLayer gsfSemanticLayer = GsfSemanticLayer.this;
                synchronized (gsfSemanticLayer) {
                    GsfSemanticLayer.this.colorings = colorings;
                    GsfSemanticLayer.this.edits = new ArrayList();
                    GsfSemanticLayer.this.version = version;
                    GsfSemanticLayer.this.fireHighlightsChange(0, GsfSemanticLayer.this.doc.getLength());
                    DocumentUtilities.removeDocumentListener((Document)GsfSemanticLayer.this.doc, (DocumentListener)GsfSemanticLayer.this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
                    DocumentUtilities.addDocumentListener((Document)GsfSemanticLayer.this.doc, (DocumentListener)GsfSemanticLayer.this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
                }
            }
        });
    }

    synchronized SortedSet<SequenceElement> getColorings() {
        return this.colorings;
    }

    synchronized int getVersion() {
        return this.version;
    }

    public synchronized HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (this.colorings.isEmpty()) {
            return HighlightsSequence.EMPTY;
        }
        return new GsfHighlightSequence(this, this.doc, startOffset, endOffset, this.colorings);
    }

    public synchronized void clearColoringCache() {
        this.CACHE.clear();
    }

    synchronized AttributeSet getColoring(ColoringAttributes.Coloring c, Language language) {
        Map<ColoringAttributes.Coloring, AttributeSet> map = this.CACHE.get(language);
        if (map == null) {
            AttributeSet a = language.getColoringManager().getColoringImpl(c);
            map = new HashMap<ColoringAttributes.Coloring, AttributeSet>();
            map.put(c, a);
            this.CACHE.put(language, map);
            return a;
        }
        AttributeSet a = map.get(c);
        if (a == null) {
            a = language.getColoringManager().getColoringImpl(c);
            map.put(c, a);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        GsfSemanticLayer gsfSemanticLayer = this;
        synchronized (gsfSemanticLayer) {
            this.edits.add(new Edit(e.getOffset(), e.getLength(), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent e) {
        GsfSemanticLayer gsfSemanticLayer = this;
        synchronized (gsfSemanticLayer) {
            this.edits.add(new Edit(e.getOffset(), e.getLength(), false));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public int getShiftedPos(int pos) {
        List<Edit> list = this.edits;
        int len = list.size();
        if (len == 0) {
            return pos;
        }
        for (int i = 0; i < len; ++i) {
            Edit edit = list.get(i);
            if (pos <= edit.offset) continue;
            if (edit.insert) {
                pos += edit.len;
                continue;
            }
            if (pos < edit.offset + edit.len) {
                pos = edit.offset;
                continue;
            }
            pos -= edit.len;
        }
        if (pos < 0) {
            pos = 0;
        }
        return pos;
    }

    private static final class GsfHighlightSequence
    implements HighlightsSequence {
        private Iterator<SequenceElement> iterator;
        private SequenceElement element;
        private final GsfSemanticLayer layer;
        private final int endOffset;

        GsfHighlightSequence(GsfSemanticLayer layer, Document doc, int startOffset, int endOffset, SortedSet<SequenceElement> colorings) {
            this.layer = layer;
            this.endOffset = endOffset;
            SequenceElement.ComparisonItem fromInclusive = new SequenceElement.ComparisonItem(startOffset);
            SortedSet<SequenceElement> subMap = colorings.tailSet(fromInclusive);
            this.iterator = subMap.iterator();
        }

        public boolean moveNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                this.element = this.iterator.next();
                if (this.element.range.getStart() < this.endOffset) {
                    return true;
                }
                this.iterator = null;
                return false;
            }
            return false;
        }

        public int getStartOffset() {
            return this.layer.getShiftedPos(this.element.range.getStart());
        }

        public int getEndOffset() {
            return this.layer.getShiftedPos(this.element.range.getEnd());
        }

        public AttributeSet getAttributes() {
            ColoringAttributes.Coloring coloring = this.element.coloring;
            return this.layer.getColoring(coloring, this.element.language);
        }
    }

    private class Edit {
        int offset;
        int len;
        boolean insert;

        public Edit(int offset, int len, boolean insert) {
            this.offset = offset;
            this.len = len;
            this.insert = insert;
        }
    }
}

