/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.device;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.device.DummyDisplayPresenter;
import org.netbeans.modules.vmd.screen.device.TopPanel;

public class DevicePanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = new Color(16513523);
    private final ScreenDisplayPresenter dummyPresenter = new DummyDisplayPresenter();
    private ScreenAccessController controller;
    private JPanel displayPanel;
    private TopPanel topPanel;

    public DevicePanel(ScreenAccessController controller) {
        this.controller = controller;
        this.setBackground(BACKGROUND_COLOR);
        this.topPanel = new TopPanel(this);
        this.displayPanel = new JPanel();
        this.displayPanel.setLayout(new BorderLayout());
        this.displayPanel.setBackground(BACKGROUND_COLOR);
        this.initializeUI();
    }

    private ScreenDeviceInfo getDeviceInfo() {
        final ScreenDeviceInfo[] screenDevice = new ScreenDeviceInfo[1];
        final DesignDocument document = this.controller.getDocument();
        if (document == null) {
            return null;
        }
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent rootComponent = document.getRootComponent();
                ScreenDeviceInfoPresenter presenter = (ScreenDeviceInfoPresenter)rootComponent.getPresenter(ScreenDeviceInfoPresenter.class);
                assert (presenter != null) : "No ScreenDevice attached to the root component";
                screenDevice[0] = presenter.getScreenDeviceInfo();
            }
        });
        return screenDevice[0];
    }

    public ScreenAccessController getController() {
        return this.controller;
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.gridheight = 3;
        constraints.fill = 1;
        this.add((Component)this.topPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP_LEFT), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP_RIGHT), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 3;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.LEFT), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        this.add((Component)this.displayPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.fill = 3;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.RIGHT), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM_LEFT), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 2;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM_RIGHT), constraints);
        JPanel fillPanel = new JPanel();
        fillPanel.setBackground(BACKGROUND_COLOR);
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.weighty = 1.0;
        this.add((Component)fillPanel, constraints);
    }

    public void reload() {
        Component[] content;
        ScreenDisplayPresenter presenter;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        DesignComponent editedScreen = this.controller.getEditedScreen();
        ScreenDisplayPresenter screenDisplayPresenter = presenter = editedScreen != null ? (ScreenDisplayPresenter)editedScreen.getPresenter(ScreenDisplayPresenter.class) : null;
        if (presenter == null) {
            presenter = this.dummyPresenter;
        }
        this.displayPanel.setVisible(false);
        this.displayPanel.removeAll();
        this.displayPanel.setPreferredSize(null);
        this.displayPanel.add((Component)presenter.getView(), "Center");
        this.displayPanel.setBackground(this.getDeviceInfo().getDeviceTheme().getColor(DeviceTheme.Colors.BACKGROUND));
        presenter.reload(this.getDeviceInfo());
        int requiredHeight = 0;
        for (Component jComponent : content = presenter.getView().getComponents()) {
            requiredHeight = (int)((double)requiredHeight + jComponent.getPreferredSize().getHeight());
        }
        Dimension size = this.getDeviceInfo().getCurrentScreenSize();
        this.displayPanel.setMinimumSize(size);
        if (size.height >= requiredHeight) {
            this.displayPanel.setPreferredSize(size);
        } else {
            this.displayPanel.setPreferredSize(new Dimension(size.width, requiredHeight));
        }
        this.displayPanel.setMaximumSize(new Dimension(size.width, Integer.MAX_VALUE));
        this.displayPanel.setVisible(true);
        this.displayPanel.validate();
        this.topPanel.reload();
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public DesignComponent getDesignComponentAt(Point point) {
        return DevicePanel.getDesignComponentAt(this.controller.getEditedScreen(), this, point);
    }

    private static DesignComponent getDesignComponentAt(DesignComponent component, JComponent parentView, Point point) {
        if (component == null) {
            return null;
        }
        ScreenDisplayPresenter presenter = (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class);
        if (presenter == null) {
            return null;
        }
        JComponent view = presenter.getView();
        Point viewLocation = presenter.getLocation();
        if (viewLocation != null && !viewLocation.equals(view.getLocation())) {
            view.setLocation(viewLocation);
        }
        Container c = view;
        Point viewPoint = new Point(point);
        while (true) {
            if (c == null) {
                return null;
            }
            if (c == parentView) break;
            Point childPoint = c.getLocation();
            viewPoint.x -= childPoint.x;
            viewPoint.y -= childPoint.y;
            c = c.getParent();
        }
        for (DesignComponent child : presenter.getChildren()) {
            DesignComponent ret = DevicePanel.getDesignComponentAt(child, view, viewPoint);
            if (ret == null) continue;
            return ret;
        }
        Shape shape = presenter.getSelectionShape();
        if (shape != null && shape.contains(viewPoint)) {
            return presenter.getRelatedComponent();
        }
        return null;
    }

    public Point calculateTranslation(Container view, Point viewLocation) {
        Point point = new Point();
        if (viewLocation != null && !viewLocation.equals(view.getLocation())) {
            view.setLocation(viewLocation);
        }
        while (true) {
            if (view == null) {
                return null;
            }
            if (view == this) break;
            Point childPoint = view.getLocation();
            point.x += childPoint.x;
            point.y += childPoint.y;
            view = view.getParent();
        }
        return point;
    }

    public void setScreenSize(Dimension deviceScreenSize) {
        ScreenDeviceInfo deviceInfo = this.getDeviceInfo();
        if (deviceScreenSize == null) {
            deviceScreenSize = new Dimension(240, 320);
        }
        if (deviceScreenSize.equals(deviceInfo.getCurrentScreenSize())) {
            return;
        }
        deviceInfo.setArbitraryScreenSize(deviceScreenSize);
        this.reload();
    }
}

