/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class DAONewExporter
extends GenericExporter {
    protected String filePattern;

    public DAONewExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public DAONewExporter() {
    }

    protected void setupContext() {
        if (!this.getProperties().containsKey("ejb3")) {
            this.getProperties().put("ejb3", "false");
        }
        if (!this.getProperties().containsKey("jdk5")) {
            this.getProperties().put("jdk5", "false");
        }
        this.initFilePattern();
        this.setTemplateName(this.getProperty("hibernatetool.template_name"));
        super.setupContext();
    }

    private void initFilePattern() {
        this.filePattern = this.getProperty("hibernatetool.file_pattern");
        if (this.filePattern == null) {
            throw new IllegalStateException("Expected parameter file_pattern is not found");
        }
        this.filePattern = this.replaceParameters(this.filePattern, this.getProperties());
        this.setFilePattern(this.filePattern);
        this.log.debug((Object)("File pattern set to " + this.filePattern));
    }

    public String getProperty(String key) {
        return (String)this.getProperties().get(key);
    }

    public void doStart() {
        File file;
        boolean doExport = true;
        if (this.filePattern != null && this.filePattern.indexOf("{class-name}") == -1 && (file = new File(this.getOutputDirectory(), this.filePattern)).exists() && !this.isOverwrite()) {
            this.log.warn((Object)("Skipping the generation of file " + file + " because target already exists"));
            doExport = false;
        }
        if (doExport) {
            super.doStart();
        }
    }

    protected void exportPOJO(Map additionalContext, POJOClass element) {
        String filename = this.resolveFilename(element);
        File file = new File(this.getOutputDirectory(), filename);
        if (file.exists() && !this.isOverwrite()) {
            this.log.warn((Object)("Skipping the generation of file " + file + " because target already exists"));
        } else {
            super.exportPOJO(additionalContext, element);
        }
    }

    public boolean isOverwrite() {
        return "true".equalsIgnoreCase((String)this.getProperties().get("hibernatetool.overwrite"));
    }

    public String replaceParameters(String pattern, Map paramValues) {
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(pattern);
        String output = pattern;
        while (matcher.find()) {
            String param = matcher.group(1);
            String value = (String)paramValues.get(param);
            if (value == null) continue;
            value = value.replace('.', '/');
            output = output.replaceAll("\\{" + param + "\\}", value);
        }
        return output;
    }
}

