/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.spi.datafilter.DataFilterFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

public class DataFiltersManager {
    private static final Logger log = DLightLogger.getLogger(DataFiltersManager.class);
    private static DataFiltersManager instance = new DataFiltersManager();
    private final Collection<DataFilterFactory> allDataFilterFactories = new HashSet<DataFilterFactory>();

    private DataFiltersManager() {
    }

    public static DataFiltersManager getInstance() {
        return instance;
    }

    public DataFilter createFilter(String filterID, String filterSpec) {
        Collection factories = Lookup.getDefault().lookupAll(DataFilterFactory.class);
        for (DataFilterFactory dff : factories) {
            if (!this.allDataFilterFactories.add(dff)) continue;
            for (String id : dff.getSupportedFilterIDs()) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("DataFilterFactory for " + id + " registered...");
            }
        }
        for (DataFilterFactory dff : this.allDataFilterFactories) {
            DataFilter filter = dff.createFilter(filterID, filterSpec);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }
}

