/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.BeansFilter;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.DefaultBindingTypeFilter;
import org.netbeans.modules.web.beans.impl.model.EnableBeansFilter;
import org.netbeans.modules.web.beans.impl.model.MemberBindingFilter;
import org.netbeans.modules.web.beans.impl.model.QualifierChecker;
import org.netbeans.modules.web.beans.impl.model.TypeBindingFilter;
import org.netbeans.modules.web.beans.impl.model.TypeProductionFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.modules.web.beans.impl.model.results.DefinitionErrorResult;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

abstract class FieldInjectionPointLogic {
    static final String PRODUCER_ANNOTATION = "javax.enterprise.inject.Produces";
    static final String ANY_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Any";
    static final String DEFAULT_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Default";
    static final String NEW_QUALIFIER_ANNOTATION = "javax.enterprise.inject.New";
    static final String NAMED_QUALIFIER_ANNOTATION = "javax.inject.Named";
    static final String INJECT_ANNOTATION = "javax.inject.Inject";
    static final Logger LOGGER = Logger.getLogger(WebBeansModelProvider.class.getName());

    FieldInjectionPointLogic() {
    }

    public TypeMirror resolveType(String string, AnnotationModelHelper annotationModelHelper) {
        return annotationModelHelper.resolveType(string);
    }

    protected Result findVariableInjectable(VariableElement variableElement, DeclaredType declaredType, WebBeansModelImplementation webBeansModelImplementation) {
        AnnotatedConstruct annotatedConstruct;
        DeclaredType declaredType2 = declaredType;
        if (declaredType2 == null) {
            annotatedConstruct = webBeansModelImplementation.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement((Element)variableElement);
            boolean bl = annotatedConstruct.asType() instanceof DeclaredType;
            if (bl) {
                declaredType2 = (DeclaredType)annotatedConstruct.asType();
            }
            if (!bl) {
                return new DefinitionErrorResult(variableElement, declaredType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)variableElement.getSimpleName(), (Object)(annotatedConstruct != null ? annotatedConstruct.toString() : null)));
            }
        }
        annotatedConstruct = webBeansModelImplementation.getHelper().getCompilationController().getTypes().asMemberOf(declaredType2, variableElement);
        return this.getResult(this.doFindVariableInjectable(variableElement, (TypeMirror)annotatedConstruct, webBeansModelImplementation, true), webBeansModelImplementation);
    }

    protected Result getResult(Result result, WebBeansModelImplementation webBeansModelImplementation) {
        this.filterBeans(result);
        result = this.filterEnabled(result, webBeansModelImplementation);
        return result;
    }

    protected void filterBeans(Result result) {
        if (result instanceof ResultImpl) {
            BeansFilter beansFilter = BeansFilter.get();
            beansFilter.filter(((ResultImpl)result).getTypeElements());
        }
    }

    protected Result filterEnabled(Result result, WebBeansModelImplementation webBeansModelImplementation) {
        if (result instanceof ResultImpl) {
            EnableBeansFilter enableBeansFilter = new EnableBeansFilter((ResultImpl)result, webBeansModelImplementation);
            return enableBeansFilter.filter();
        }
        return result;
    }

    protected Result doFindVariableInjectable(VariableElement variableElement, TypeMirror typeMirror, WebBeansModelImplementation webBeansModelImplementation, boolean bl) {
        Object object;
        Set<Element> set;
        LinkedList<AnnotationMirror> linkedList = new LinkedList<AnnotationMirror>();
        boolean bl2 = false;
        try {
            bl2 = this.hasAnyQualifier(variableElement, webBeansModelImplementation, bl, linkedList);
        }
        catch (InjectionPointDefinitionError injectionPointDefinitionError) {
            return new DefinitionErrorResult(variableElement, typeMirror, injectionPointDefinitionError.getMessage());
        }
        boolean bl3 = !bl2 && linkedList.size() == 0;
        boolean bl4 = false;
        String string = null;
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        if (linkedList.size() == 1) {
            set = (AnnotationMirror)linkedList.get(0);
            object = set.getAnnotationType();
            TypeElement typeElement = (TypeElement)object.asElement();
            string = typeElement.getQualifiedName().toString();
            bl3 = typeElement.getQualifiedName().contentEquals(DEFAULT_QUALIFIER_ANNOTATION);
            bl4 = typeElement.getQualifiedName().contentEquals(NEW_QUALIFIER_ANNOTATION);
        }
        if (linkedList.size() == 0 && bl2 || bl3) {
            LOGGER.fine("Found built-in binding " + string);
            set = this.getAssignableTypes(variableElement, typeMirror, webBeansModelImplementation);
            if (bl3) {
                LOGGER.fine("@Default annotation requires test for implementors of varaible type");
                this.filterBindingsByDefault(set, webBeansModelImplementation);
            }
            hashSet.addAll(set);
        } else {
            if (bl4) {
                return this.handleNewQualifier(variableElement, typeMirror, webBeansModelImplementation, linkedList);
            }
            set = this.getBindingTypes(linkedList, webBeansModelImplementation);
            this.filterBindingsByMembers(linkedList, set, webBeansModelImplementation, TypeElement.class);
            this.filterBindingsByType(variableElement, typeMirror, set, webBeansModelImplementation);
            hashSet.addAll(set);
        }
        if (linkedList.size() == 0 && bl2 || bl3) {
            set = this.getAllProductions(webBeansModelImplementation);
            if (bl3) {
                this.filterDefaultProductions(set, webBeansModelImplementation);
            }
        } else {
            set = this.getProductions(linkedList, webBeansModelImplementation);
            this.filterBindingsByMembers(linkedList, set, webBeansModelImplementation, Element.class);
        }
        object = this.filterProductionByType(variableElement, typeMirror, set, webBeansModelImplementation);
        return this.createResult(variableElement, typeMirror, hashSet, (Map<Element, List<DeclaredType>>)object, webBeansModelImplementation);
    }

    protected boolean isQualifier(TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        QualifierChecker qualifierChecker = QualifierChecker.get();
        qualifierChecker.init(typeElement, annotationModelHelper);
        return qualifierChecker.check();
    }

    protected Set<Element> getChildSpecializes(Element element, WebBeansModelImplementation webBeansModelImplementation) {
        TypeElement typeElement = webBeansModelImplementation.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
        Set<TypeElement> set = FieldInjectionPointLogic.getImplementors(webBeansModelImplementation, typeElement);
        set.remove(element.getEnclosingElement());
        HashSet<Element> hashSet = new HashSet<Element>();
        hashSet.add(element);
        for (TypeElement typeElement2 : set) {
            this.inspectHierarchy(element, typeElement2, hashSet, webBeansModelImplementation);
        }
        hashSet.remove(element);
        return hashSet;
    }

    static Set<TypeElement> getImplementors(WebBeansModelImplementation webBeansModelImplementation, Element element) {
        if (!(element instanceof TypeElement)) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        hashSet.add((TypeElement)element);
        HashSet<TypeElement> hashSet2 = new HashSet<TypeElement>();
        hashSet2.add((TypeElement)element);
        while (hashSet2.size() > 0) {
            TypeElement typeElement = (TypeElement)hashSet2.iterator().next();
            hashSet2.remove(typeElement);
            Set<TypeElement> set = FieldInjectionPointLogic.doGetImplementors(webBeansModelImplementation, typeElement);
            if (set.size() == 0) continue;
            hashSet.addAll(set);
            for (TypeElement typeElement2 : set) {
                hashSet2.add(typeElement2);
            }
        }
        return hashSet;
    }

    private Result createResult(VariableElement variableElement, TypeMirror typeMirror, Set<TypeElement> set, Map<Element, List<DeclaredType>> map, WebBeansModelImplementation webBeansModelImplementation) {
        return new ResultImpl(variableElement, typeMirror, set, map, webBeansModelImplementation.getHelper());
    }

    private Result handleNewQualifier(VariableElement variableElement, TypeMirror typeMirror, WebBeansModelImplementation webBeansModelImplementation, List<AnnotationMirror> list) {
        AnnotationMirror annotationMirror = list.get(0);
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)webBeansModelImplementation.getHelper());
        annotationParser.expectClass("value", null);
        ParseResult parseResult = annotationParser.parse(annotationMirror);
        String string = (String)parseResult.get("value", String.class);
        TypeMirror typeMirror2 = string == null ? typeMirror : this.resolveType(string, webBeansModelImplementation.getHelper());
        Element element = null;
        if (typeMirror2 != null) {
            element = webBeansModelImplementation.getHelper().getCompilationController().getTypes().asElement(typeMirror2);
        }
        if (element != null && webBeansModelImplementation.getHelper().getCompilationController().getTypes().isAssignable(typeMirror2, typeMirror)) {
            return new ResultImpl(variableElement, typeMirror, (TypeElement)element, webBeansModelImplementation.getHelper());
        }
        return new ResultImpl(variableElement, typeMirror, webBeansModelImplementation.getHelper());
    }

    private boolean hasAnyQualifier(VariableElement variableElement, WebBeansModelImplementation webBeansModelImplementation, boolean bl, List<AnnotationMirror> list) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> list2 = webBeansModelImplementation.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(variableElement);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (AnnotationMirror annotationMirror : list2) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (ANY_QUALIFIER_ANNOTATION.equals(typeElement.getQualifiedName().toString())) {
                bl3 = true;
            } else if (this.isQualifier(typeElement, webBeansModelImplementation.getHelper())) {
                list.add(annotationMirror);
            }
            if (PRODUCER_ANNOTATION.contentEquals(typeElement.getQualifiedName())) {
                bl2 = true;
                continue;
            }
            if (!INJECT_ANNOTATION.contentEquals(typeElement.getQualifiedName())) continue;
            bl4 = true;
        }
        if (bl2) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_ProducerInjectPoint", (Object)variableElement.getSimpleName()));
        }
        if (bl && !bl4) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_NoInjectPoint", (Object)variableElement.getSimpleName()));
        }
        return bl3;
    }

    private void inspectHierarchy(Element element, TypeElement typeElement, Set<Element> set, WebBeansModelImplementation webBeansModelImplementation) {
        List<? extends Element> list = typeElement.getEnclosedElements();
        for (Element element2 : list) {
            HashSet<Element> hashSet;
            if (element2.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(element2.getSimpleName()) || !this.collectSpecializes(element, (ExecutableElement)element2, webBeansModelImplementation, hashSet = new HashSet<Element>(), set)) continue;
            set.addAll(hashSet);
            return;
        }
    }

    private boolean collectSpecializes(Element element, ExecutableElement executableElement, WebBeansModelImplementation webBeansModelImplementation, Set<Element> set, Set<Element> set2) {
        ElementUtilities elementUtilities = webBeansModelImplementation.getHelper().getCompilationController().getElementUtilities();
        if (!elementUtilities.overridesMethod(executableElement)) {
            return false;
        }
        ExecutableElement executableElement2 = elementUtilities.getOverriddenMethod(executableElement);
        if (executableElement2 == null) {
            return false;
        }
        if (!AnnotationObjectProvider.hasSpecializes(executableElement, webBeansModelImplementation.getHelper())) {
            return false;
        }
        set.add(executableElement);
        if (executableElement2.equals(element) || set2.contains(element)) {
            return true;
        }
        return this.collectSpecializes(element, executableElement2, webBeansModelImplementation, set, set2);
    }

    private static Set<TypeElement> doGetImplementors(WebBeansModelImplementation webBeansModelImplementation, TypeElement typeElement) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
        Set set = webBeansModelImplementation.getHelper().getClasspathInfo().getClassIndex().getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (set == null) {
            LOGGER.log(Level.WARNING, "ClassIndex.getElements() was interrupted");
            return Collections.emptySet();
        }
        for (ElementHandle elementHandle2 : set) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle2.getQualifiedName());
            TypeElement typeElement2 = (TypeElement)elementHandle2.resolve((CompilationInfo)webBeansModelImplementation.getHelper().getCompilationController());
            if (typeElement2 == null) continue;
            hashSet.add(typeElement2);
        }
        return hashSet;
    }

    private void filterDefaultProductions(Set<Element> set, WebBeansModelImplementation webBeansModelImplementation) {
        DefaultBindingTypeFilter<Element> defaultBindingTypeFilter = DefaultBindingTypeFilter.get(Element.class);
        defaultBindingTypeFilter.init(webBeansModelImplementation);
        defaultBindingTypeFilter.filter(set);
    }

    private Set<Element> getAllProductions(WebBeansModelImplementation webBeansModelImplementation) {
        final HashSet<Element> hashSet = new HashSet<Element>();
        try {
            webBeansModelImplementation.getHelper().getAnnotationScanner().findAnnotations(PRODUCER_ANNOTATION, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    hashSet.add(element);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warning("Finding annotation javax.enterprise.inject.Produces was interrupted");
        }
        return hashSet;
    }

    private Map<Element, List<DeclaredType>> filterProductionByType(VariableElement variableElement, TypeMirror typeMirror, Set<Element> set, WebBeansModelImplementation webBeansModelImplementation) {
        TypeProductionFilter typeProductionFilter = TypeProductionFilter.get();
        typeProductionFilter.init(variableElement, typeMirror, webBeansModelImplementation);
        typeProductionFilter.filter(set);
        return typeProductionFilter.getResult();
    }

    private void filterBindingsByDefault(Set<TypeElement> set, WebBeansModelImplementation webBeansModelImplementation) {
        DefaultBindingTypeFilter<TypeElement> defaultBindingTypeFilter = DefaultBindingTypeFilter.get(TypeElement.class);
        defaultBindingTypeFilter.init(webBeansModelImplementation);
        defaultBindingTypeFilter.filter(set);
    }

    private Set<TypeElement> getAssignableTypes(VariableElement variableElement, TypeMirror typeMirror, WebBeansModelImplementation webBeansModelImplementation) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return Collections.emptySet();
        }
        Element element = ((DeclaredType)typeMirror).asElement();
        if (!(element instanceof TypeElement)) {
            return Collections.emptySet();
        }
        if (((TypeElement)element).getTypeParameters().size() != 0) {
            return this.getAssignables(webBeansModelImplementation, typeMirror, (TypeElement)element, variableElement);
        }
        return FieldInjectionPointLogic.getImplementors(webBeansModelImplementation, element);
    }

    private Set<TypeElement> getAssignables(WebBeansModelImplementation webBeansModelImplementation, TypeMirror typeMirror, TypeElement typeElement, VariableElement variableElement) {
        Set<TypeElement> set = FieldInjectionPointLogic.getImplementors(webBeansModelImplementation, typeElement);
        TypeBindingFilter typeBindingFilter = TypeBindingFilter.get();
        typeBindingFilter.init(variableElement, typeMirror, webBeansModelImplementation);
        typeBindingFilter.filter(set);
        return set;
    }

    private void filterBindingsByType(VariableElement variableElement, TypeMirror typeMirror, Set<TypeElement> set, WebBeansModelImplementation webBeansModelImplementation) {
        TypeBindingFilter typeBindingFilter = TypeBindingFilter.get();
        typeBindingFilter.init(variableElement, typeMirror, webBeansModelImplementation);
        typeBindingFilter.filter(set);
    }

    private Set<Element> getProductions(List<AnnotationMirror> list, WebBeansModelImplementation webBeansModelImplementation) {
        Object object;
        ArrayList<Set<Element>> arrayList = new ArrayList<Set<Element>>(list.size());
        boolean bl = webBeansModelImplementation.getHelper().getAnnotationsByType(list).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<Element> hashSet = new HashSet<Element>();
        for (AnnotationMirror annotationMirror : list) {
            object = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)object.asElement();
            String string = typeElement.getQualifiedName().toString();
            this.findAnnotation(webBeansModelImplementation, arrayList, string, bl, hashSet);
        }
        if (bl) {
            arrayList.add(hashSet);
        }
        Object object2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (Set)arrayList.get(i);
            if (i == 0) {
                object2 = object;
                continue;
            }
            object2.retainAll((Collection<?>)object);
        }
        if (object2 == null) {
            return Collections.emptySet();
        }
        return object2;
    }

    private void findAnnotation(final WebBeansModelImplementation webBeansModelImplementation, final List<Set<Element>> list, final String string, boolean bl, final Set<Element> set) {
        try {
            final HashSet hashSet = new HashSet();
            webBeansModelImplementation.getHelper().getAnnotationScanner().findAnnotations(string, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    if (AnnotationObjectProvider.hasAnnotation(element, FieldInjectionPointLogic.PRODUCER_ANNOTATION, webBeansModelImplementation.getHelper())) {
                        hashSet.add(element);
                        hashSet.addAll(FieldInjectionPointLogic.this.getChildSpecializes(element, webBeansModelImplementation));
                        if (string.contentEquals(FieldInjectionPointLogic.DEFAULT_QUALIFIER_ANNOTATION)) {
                            set.addAll(hashSet);
                        } else {
                            list.add(hashSet);
                        }
                    }
                }
            });
            if (bl) {
                for (Element element : hashSet) {
                    if (!AnnotationObjectProvider.checkDefault(element, webBeansModelImplementation.getHelper())) continue;
                    set.add(element);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warning("Finding annotation " + string + " was interrupted");
        }
    }

    private Set<TypeElement> getBindingTypes(List<AnnotationMirror> list, WebBeansModelImplementation webBeansModelImplementation) {
        Object object;
        Iterator iterator;
        ArrayList arrayList = new ArrayList(list.size());
        boolean bl = webBeansModelImplementation.getHelper().getAnnotationsByType(list).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<BindingQualifier> hashSet = new HashSet<BindingQualifier>();
        for (AnnotationMirror annotationMirror : list) {
            iterator = annotationMirror.getAnnotationType();
            object = (TypeElement)iterator.asElement();
            String string = object.getQualifiedName().toString();
            PersistentObjectManager<BindingQualifier> persistentObjectManager = webBeansModelImplementation.getManager(string);
            Collection collection = persistentObjectManager.getObjects();
            if (string.contentEquals(DEFAULT_QUALIFIER_ANNOTATION)) {
                hashSet.addAll(collection);
                continue;
            }
            arrayList.add(new HashSet(collection));
            if (!bl) continue;
            for (BindingQualifier bindingQualifier : collection) {
                if (!AnnotationObjectProvider.checkDefault(bindingQualifier.getTypeElement(), webBeansModelImplementation.getHelper())) continue;
                hashSet.add(new BindingQualifier(webBeansModelImplementation.getHelper(), bindingQualifier.getTypeElement(), DEFAULT_QUALIFIER_ANNOTATION));
            }
        }
        if (bl) {
            arrayList.add(hashSet);
        }
        Object object2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            iterator = (Set)arrayList.get(i);
            if (i == 0) {
                object2 = iterator;
                continue;
            }
            object2.retainAll((Collection<?>)((Object)iterator));
        }
        if (object2 == null) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> hashSet2 = new HashSet<TypeElement>();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (BindingQualifier)((Object)iterator.next());
            hashSet2.add(object.getTypeElement());
        }
        return hashSet2;
    }

    private <T extends Element> void filterBindingsByMembers(List<AnnotationMirror> list, Set<T> set, WebBeansModelImplementation webBeansModelImplementation, Class<T> clazz) {
        MemberBindingFilter<T> memberBindingFilter = MemberBindingFilter.get(clazz);
        memberBindingFilter.init(list, webBeansModelImplementation);
        memberBindingFilter.filter(set);
    }

    private static class InjectionPointDefinitionError
    extends Exception {
        private InjectionPointDefinitionError(String string) {
            super(string);
        }
    }
}

