/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.impl.model.AssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;

class TypeBindingFilter
extends Filter<TypeElement> {
    private VariableElement myElement;
    private TypeMirror myVarType;
    private WebBeansModelImplementation myImpl;

    TypeBindingFilter() {
    }

    static TypeBindingFilter get() {
        return new TypeBindingFilter();
    }

    void init(VariableElement variableElement, TypeMirror typeMirror, WebBeansModelImplementation webBeansModelImplementation) {
        this.myElement = variableElement;
        this.myImpl = webBeansModelImplementation;
        this.myVarType = typeMirror;
    }

    @Override
    void filter(Set<TypeElement> set) {
        super.filter(set);
        if (set.size() == 0) {
            return;
        }
        TypeKind typeKind = this.getType().getKind();
        if (typeKind == TypeKind.DECLARED) {
            this.filterDeclaredTypes(set);
        } else if (typeKind.isPrimitive()) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.getElement().getSimpleName() + " " + "couldn't have type as eligible for inection becuase its " + "type is primitive. It is unproxyable bean types");
            set.clear();
        } else if (typeKind == TypeKind.ARRAY) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.getElement().getSimpleName() + " " + "couldn't have type as eligible for inection becuase its " + "type has array type. It is unproxyable bean types");
            set.clear();
        }
    }

    boolean isAssignable(TypeMirror typeMirror) {
        boolean bl;
        Element element = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getElement().asType());
        boolean bl2 = bl = element instanceof TypeElement && ((TypeElement)element).getTypeParameters().size() != 0;
        if (!bl && this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(typeMirror, this.getType())) {
            WebBeansModelProviderImpl.LOGGER.fine("Found type  " + typeMirror + " for variable element " + this.getElement().getSimpleName() + " by typesafe resolution");
            return true;
        }
        if (this.checkAssignability(typeMirror)) {
            WebBeansModelProviderImpl.LOGGER.fine("Probably found castable parametrizied or raw type " + typeMirror + " for variable element " + this.getElement().getSimpleName() + " by typesafe resolution");
            return true;
        }
        return false;
    }

    private void filterDeclaredTypes(Set<TypeElement> set) {
        Element element = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getElement().asType());
        boolean bl = element instanceof TypeElement && ((TypeElement)element).getTypeParameters().size() != 0;
        Iterator<TypeElement> iterator = set.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement = iterator.next();
            if (!bl && this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(typeElement.asType(), this.getType())) {
                WebBeansModelProviderImpl.LOGGER.fine("Found type element " + typeElement.getQualifiedName() + " for variable element " + this.getElement().getSimpleName() + " by typesafe resolution");
                continue;
            }
            if (this.checkAssignability(typeElement)) {
                WebBeansModelProviderImpl.LOGGER.fine("Probably found castable parametrizied or raw type element " + typeElement.getQualifiedName() + " for variable element " + this.getElement().getSimpleName() + " by typesafe resolution");
                continue;
            }
            iterator.remove();
        }
    }

    private boolean checkAssignability(TypeElement typeElement) {
        if (!(typeElement.asType() instanceof DeclaredType)) {
            return false;
        }
        AssignabilityChecker assignabilityChecker = AssignabilityChecker.get();
        assignabilityChecker.init((DeclaredType)this.getType(), (DeclaredType)typeElement.asType(), this.getImplementation());
        return assignabilityChecker.check();
    }

    private boolean checkAssignability(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        AssignabilityChecker assignabilityChecker = AssignabilityChecker.get();
        assignabilityChecker.init((DeclaredType)this.getType(), (DeclaredType)typeMirror, this.getImplementation());
        return assignabilityChecker.check();
    }

    private VariableElement getElement() {
        return this.myElement;
    }

    private TypeMirror getType() {
        return this.myVarType;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }
}

