/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.DocumentationScrollPane;
import org.netbeans.modules.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.JavaElement;
import org.netbeans.modules.web.beans.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.web.beans.navigation.NoBorderToolBar;
import org.netbeans.modules.web.beans.navigation.Utils;
import org.netbeans.modules.web.beans.navigation.WebBeansNavigationOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InjectablesPanel
extends JPanel {
    private static final long serialVersionUID = -1643692494954311020L;
    public static final Icon FQN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/fqn.gif", (boolean)false);
    public static final Icon EXPAND_ALL_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/expandall.gif", (boolean)false);
    private static final String NON_BINDING_MEMBER_ANNOTATION = "javax.enterprise.inject.NonBinding";
    private static TreeModel pleaseWaitTreeModel;
    private Component lastFocusedComponent;
    public ButtonGroup javaHierarchyModeButtonGroup;
    public JLabel myBindingLbl;
    public JEditorPane myBindings;
    public JCheckBox myCaseSensitiveFilterCheckBox;
    public JButton myCloseButton;
    public JButton myExpandAllButton;
    public JLabel myFilterLabel;
    public JTextField myFilterTextField;
    public JLabel myFiltersLabel;
    public JToolBar myFiltersToolbar;
    public JLabel myInjectableBindingLbl;
    public JEditorPane myInjectableBindings;
    public JTree myJavaHierarchyTree;
    public JScrollPane myJavaHierarchyTreeScrollPane;
    public JSeparator mySeparator;
    public JToggleButton myShowFQNToggleButton;
    public JSplitPane mySplitPane;
    public JEditorPane myType;
    public JLabel myTypeLbl;
    private StringBuilder myFqnTypeName;
    private StringBuilder myShortTypeName;
    private String myFqnBindings;
    private String myShortBindings;
    private InjectablesModel javaHierarchyModel;
    private DocumentationScrollPane myDocPane;
    private MetadataModel<WebBeansModel> myModel;

    public InjectablesPanel(Result result, List<AnnotationMirror> list, CompilationController compilationController, MetadataModel<WebBeansModel> metadataModel) {
        this.initComponents();
        this.mySeparator.setVisible(false);
        this.myFilterLabel.setVisible(false);
        this.myFilterTextField.setVisible(false);
        this.myCaseSensitiveFilterCheckBox.setVisible(false);
        this.myModel = metadataModel;
        this.myDocPane = new DocumentationScrollPane(true);
        this.mySplitPane.setRightComponent(this.myDocPane);
        this.mySplitPane.setDividerLocation(WebBeansNavigationOptions.getHierarchyDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.myJavaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setSelected(WebBeansNavigationOptions.isCaseSensitive());
        this.myShowFQNToggleButton.setSelected(WebBeansNavigationOptions.isShowFQN());
        this.initInjectionPoint(result.getVariable(), list, compilationController);
        this.myJavaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.myJavaHierarchyTree.setRootVisible(false);
        this.myJavaHierarchyTree.setShowsRootHandles(true);
        this.myJavaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaHierarchyModel = new InjectablesModel(result, compilationController, metadataModel);
        this.myJavaHierarchyTree.setModel(this.javaHierarchyModel);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.initListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InjectablesPanel.this.reload();
                InjectablesPanel.this.myFilterTextField.requestFocusInWindow();
            }
        });
    }

    @Override
    public void removeNotify() {
        WebBeansNavigationOptions.setHierarchyDividerLocation(this.mySplitPane.getDividerLocation());
        this.myDocPane.setData(null);
        super.removeNotify();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        JRootPane jRootPane;
        if ((keyEvent.getKeyCode() == 112 || keyEvent.getKeyCode() == 156) && (jRootPane = SwingUtilities.getRootPane(this)) != null) {
            jRootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void enterBusy() {
        Window window;
        this.myJavaHierarchyTree.setModel(pleaseWaitTreeModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.lastFocusedComponent = window.getFocusOwner();
        }
        this.myFilterTextField.setEnabled(false);
        this.myCaseSensitiveFilterCheckBox.setEnabled(false);
        this.myShowFQNToggleButton.setEnabled(false);
        this.myExpandAllButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.myJavaHierarchyTree.setModel(this.javaHierarchyModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.myFilterTextField.setEnabled(true);
        this.myCaseSensitiveFilterCheckBox.setEnabled(true);
        this.myShowFQNToggleButton.setEnabled(true);
        this.myExpandAllButton.setEnabled(true);
        if (this.lastFocusedComponent != null) {
            if (this.lastFocusedComponent.isDisplayable()) {
                this.lastFocusedComponent.requestFocusInWindow();
            }
            this.lastFocusedComponent = null;
        }
    }

    private void reload() {
        this.enterBusy();
        WebBeansNavigationOptions.setCaseSensitive(this.myCaseSensitiveFilterCheckBox.isSelected());
        WebBeansNavigationOptions.setShowFQN(this.myShowFQNToggleButton.isSelected());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InjectablesPanel.this.javaHierarchyModel.update();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InjectablesPanel.this.leaveBusy();
                            for (int i = 0; i < InjectablesPanel.this.myJavaHierarchyTree.getRowCount(); ++i) {
                                InjectablesPanel.this.myJavaHierarchyTree.expandRow(i);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRootPane jRootPane = SwingUtilities.getRootPane(InjectablesPanel.this);
                if (jRootPane != null) {
                    jRootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < InjectablesPanel.this.myJavaHierarchyTree.getRowCount(); ++i) {
                        InjectablesPanel.this.myJavaHierarchyTree.expandRow(i);
                    }
                    InjectablesPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane jRootPane = SwingUtilities.getRootPane(InjectablesPanel.this);
                    if (jRootPane != null) {
                        jRootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.myFilterTextField.setForeground(UIManager.getColor("TextField.foreground"));
        this.myJavaHierarchyTree.setSelectionRow(-1);
        for (int i = 0; i < this.myJavaHierarchyTree.getRowCount(); ++i) {
            String string;
            Object object = this.myJavaHierarchyTree.getPathForRow(i).getLastPathComponent();
            if (!(object instanceof JavaElement) || !Utils.patternMatch((JavaElement)object, string = this.myFilterTextField.getText(), string.toLowerCase())) continue;
            this.myJavaHierarchyTree.setSelectionRow(i);
            this.myJavaHierarchyTree.scrollRowToVisible(i);
            return;
        }
        this.myFilterTextField.setForeground(Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaElement) {
        try {
            javaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showBindings() {
        Object object;
        this.myInjectableBindings.setToolTipText(null);
        TreePath treePath = this.myJavaHierarchyTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof InjectableTreeNode) {
            final ElementHandle elementHandle = ((InjectableTreeNode)object).getElementHandle();
            try {
                this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                    public Void run(WebBeansModel webBeansModel) throws Exception {
                        Element element = elementHandle.resolve((CompilationInfo)webBeansModel.getCompilationController());
                        if (element == null) {
                            InjectablesPanel.this.myInjectableBindings.setText("");
                        } else {
                            List<AnnotationMirror> list = webBeansModel.getQualifiers(element);
                            StringBuilder stringBuilder = new StringBuilder();
                            for (AnnotationMirror annotationMirror : list) {
                                InjectablesPanel.this.appendBinding(annotationMirror, stringBuilder, InjectablesPanel.this.myShowFQNToggleButton.isSelected());
                            }
                            Object object = "";
                            if (stringBuilder.length() > 0) {
                                object = stringBuilder.substring(0, stringBuilder.length() - 2);
                            }
                            InjectablesPanel.this.myInjectableBindings.setText((String)object);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, metadataModelException.getMessage(), metadataModelException);
            }
            catch (IOException iOException) {
                Logger.getLogger(InjectablesPanel.class.getName()).log(Level.WARNING, iOException.getMessage(), iOException);
            }
            this.myInjectableBindings.setCaretPosition(0);
            this.myInjectableBindings.setToolTipText(((JavaElement)object).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object object;
        TreePath treePath = this.myJavaHierarchyTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.myDocPane.setData(((JavaElement)object).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }

    private void initInjectionPoint(VariableElement variableElement, List<AnnotationMirror> list, CompilationController compilationController) {
        TypeMirror typeMirror = variableElement.asType();
        this.myShortTypeName = new StringBuilder();
        this.myFqnTypeName = new StringBuilder();
        this.setInjectableType(typeMirror, compilationController);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (AnnotationMirror annotationMirror : list) {
            this.appendBinding(annotationMirror, stringBuilder, true);
            this.appendBinding(annotationMirror, stringBuilder2, false);
        }
        if (stringBuilder.length() > 0) {
            this.myFqnBindings = stringBuilder.substring(0, stringBuilder.length() - 2);
            this.myShortBindings = stringBuilder2.substring(0, stringBuilder2.length() - 2);
        } else {
            this.myFqnBindings = "";
            this.myShortBindings = "";
        }
        if (this.myShowFQNToggleButton.isSelected()) {
            this.myBindings.setText(this.myFqnBindings);
        } else {
            this.myBindings.setText(this.myShortBindings);
        }
        this.reloadInjectionPoint();
    }

    private void setInjectableType(TypeMirror typeMirror, CompilationController compilationController) {
        Element element;
        if (typeMirror.getKind().isPrimitive()) {
            this.myShortTypeName.append(typeMirror.getKind().toString().toLowerCase());
            this.myFqnTypeName.append((CharSequence)this.myShortTypeName);
            return;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            this.setInjectableArrayType(typeMirror, compilationController);
            this.myShortTypeName = this.myShortTypeName.append("[]");
            this.myFqnTypeName = this.myFqnTypeName.append("[]");
        }
        if ((element = compilationController.getTypes().asElement(typeMirror)) != null) {
            this.myFqnTypeName.append(element instanceof TypeElement ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
            this.myShortTypeName.append(element.getSimpleName().toString());
        }
    }

    private void setInjectableArrayType(TypeMirror typeMirror, CompilationController compilationController) {
        TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
        this.setInjectableType(typeMirror2, compilationController);
    }

    private void appendBinding(AnnotationMirror annotationMirror, StringBuilder stringBuilder, boolean bl) {
        DeclaredType declaredType = annotationMirror.getAnnotationType();
        Element element = declaredType.asElement();
        stringBuilder.append("@");
        String string = bl ? (element instanceof TypeElement ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString()) : element.getSimpleName().toString();
        stringBuilder.append(string);
        this.appendBindingParamters(annotationMirror, stringBuilder);
        stringBuilder.append(", ");
    }

    private void appendBindingParamters(AnnotationMirror annotationMirror, StringBuilder stringBuilder) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
            ExecutableElement executableElement = entry.getKey();
            AnnotationValue annotationValue = entry.getValue();
            List<? extends AnnotationMirror> list = executableElement.getAnnotationMirrors();
            boolean bl = false;
            for (AnnotationMirror annotationMirror2 : list) {
                DeclaredType declaredType = annotationMirror2.getAnnotationType();
                Element element = declaredType.asElement();
                if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().contentEquals(NON_BINDING_MEMBER_ANNOTATION)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder2.append(executableElement.getSimpleName().toString());
            stringBuilder2.append("=");
            if (annotationValue.getValue() instanceof String) {
                stringBuilder2.append('\"');
                stringBuilder2.append(annotationValue.getValue().toString());
                stringBuilder2.append('\"');
            } else {
                stringBuilder2.append(annotationValue.getValue().toString());
            }
            stringBuilder2.append(", ");
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("(");
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length() - 2));
            stringBuilder.append(")");
        }
    }

    private void reloadInjectionPoint() {
        if (this.myShowFQNToggleButton.isSelected()) {
            this.myBindings.setText(this.myFqnBindings);
            this.myType.setText(this.myFqnTypeName.toString());
        } else {
            this.myBindings.setText(this.myShortBindings);
            this.myType.setText(this.myShortTypeName.toString());
        }
    }

    private void initListeners() {
        this.myFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InjectablesPanel.this.selectMatchingRow();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InjectablesPanel.this.selectMatchingRow();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InjectablesPanel.this.selectMatchingRow();
            }
        });
        this.registerKeyboardActions();
        this.myCaseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setCaseSensitive(InjectablesPanel.this.myCaseSensitiveFilterCheckBox.isSelected());
                if (InjectablesPanel.this.myFilterTextField.getText().trim().length() > 0) {
                    InjectablesPanel.this.selectMatchingRow();
                }
            }
        });
        this.myJavaHierarchyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                Point point = mouseEvent.getPoint();
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement && mouseEvent.getClickCount() == 2) {
                    InjectablesPanel.this.gotoElement((JavaElement)object);
                }
            }
        });
        this.myJavaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                InjectablesPanel.this.showBindings();
                InjectablesPanel.this.showJavaDoc();
            }
        });
        this.myShowFQNToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBeansNavigationOptions.setShowFQN(InjectablesPanel.this.myShowFQNToggleButton.isSelected());
                InjectablesPanel.this.javaHierarchyModel.fireTreeNodesChanged();
                InjectablesPanel.this.reloadInjectionPoint();
                InjectablesPanel.this.showBindings();
            }
        });
        this.myExpandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.expandAll();
            }
        });
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InjectablesPanel.this.close();
            }
        });
    }

    private void registerKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.myBindings.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(36, 0, false), 0);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.myBindings.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(38, 0, false), 0);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.myBindings.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0, false), 0);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(InjectablesPanel.this.myJavaHierarchyTree);
            }
        };
        this.myFilterTextField.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.myBindings.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    InjectablesPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = InjectablesPanel.this.myDocPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionListener.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.myFilterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = InjectablesPanel.this.myDocPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(jEditorPane, 1001, "");
                    actionListener.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionListener.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.myJavaHierarchyTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = InjectablesPanel.this.myJavaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    InjectablesPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    private void initComponents() {
        this.javaHierarchyModeButtonGroup = new ButtonGroup();
        this.mySplitPane = new JSplitPane();
        this.myJavaHierarchyTreeScrollPane = new JScrollPane();
        this.myJavaHierarchyTree = new JTree();
        this.myFilterLabel = new JLabel();
        this.myFilterTextField = new JTextField();
        this.myCaseSensitiveFilterCheckBox = new JCheckBox();
        this.myFiltersLabel = new JLabel();
        this.myCloseButton = new JButton();
        this.myFiltersToolbar = new NoBorderToolBar();
        this.myShowFQNToggleButton = new JToggleButton();
        this.myExpandAllButton = new JButton();
        this.mySeparator = new JSeparator();
        this.myBindings = new JEditorPane();
        this.myBindingLbl = new JLabel();
        this.myType = new JEditorPane();
        this.myTypeLbl = new JLabel();
        this.myInjectableBindings = new JEditorPane();
        this.myInjectableBindingLbl = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mySplitPane.setDividerLocation(300);
        this.myJavaHierarchyTreeScrollPane.setBorder(null);
        this.myJavaHierarchyTreeScrollPane.setViewportView(this.myJavaHierarchyTree);
        this.myJavaHierarchyTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_InjectableHierarchy"));
        this.mySplitPane.setLeftComponent(this.myJavaHierarchyTreeScrollPane);
        this.myFilterLabel.setLabelFor(this.myFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.myFilterLabel, (String)NbBundle.getBundle(InjectablesPanel.class).getString("LABEL_filterLabel"));
        this.myFilterTextField.setToolTipText(NbBundle.getBundle(InjectablesPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCaseSensitiveFilterCheckBox, (String)NbBundle.getBundle(InjectablesPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.myCaseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.myFiltersLabel, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCloseButton, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LABEL_Close"));
        this.myFiltersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.myFiltersToolbar.setFloatable(false);
        this.myFiltersToolbar.setBorderPainted(false);
        this.myFiltersToolbar.setOpaque(false);
        this.myShowFQNToggleButton.setIcon(FQN_ICON);
        this.myShowFQNToggleButton.setMnemonic('Q');
        this.myShowFQNToggleButton.setToolTipText(NbBundle.getBundle(InjectablesPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.myShowFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myShowFQNToggleButton);
        this.myExpandAllButton.setIcon(EXPAND_ALL_ICON);
        this.myExpandAllButton.setMnemonic('E');
        this.myExpandAllButton.setToolTipText(NbBundle.getMessage(InjectablesPanel.class, (String)"TOOLTIP_expandAll"));
        this.myExpandAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.myFiltersToolbar.add(this.myExpandAllButton);
        this.myBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myBindings.setContentType("text/x-java");
        this.myBindings.setEditable(false);
        this.myBindingLbl.setLabelFor(this.myBindings);
        Mnemonics.setLocalizedText((JLabel)this.myBindingLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_Bindings"));
        this.myType.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myType.setContentType("text/x-java");
        this.myType.setEditable(false);
        this.myTypeLbl.setLabelFor(this.myType);
        Mnemonics.setLocalizedText((JLabel)this.myTypeLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_Type"));
        this.myInjectableBindings.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.myInjectableBindings.setContentType("text/x-java");
        this.myInjectableBindings.setEditable(false);
        this.myInjectableBindingLbl.setLabelFor(this.myInjectableBindings);
        Mnemonics.setLocalizedText((JLabel)this.myInjectableBindingLbl, (String)NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_CurrentElementBindings"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.mySplitPane, -1, 641, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myFilterLabel).addPreferredGap(0).add((Component)this.myFilterTextField, -1, 516, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.myCaseSensitiveFilterCheckBox)).add((Component)this.mySeparator, -1, 641, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myBindingLbl).add((Component)this.myTypeLbl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myType, -1, 518, Short.MAX_VALUE).add((Component)this.myBindings, -1, 518, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myFiltersLabel).addPreferredGap(0).add((Component)this.myFiltersToolbar, -1, 539, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.myCloseButton)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myInjectableBindingLbl).addPreferredGap(0).add((Component)this.myInjectableBindings, -1, 588, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myTypeLbl).add((Component)this.myType, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myBindings, -2, 20, -2).add((Component)this.myBindingLbl)).addPreferredGap(0).add((Component)this.mySeparator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myFilterLabel).add((Component)this.myFilterTextField, -2, -1, -2).add((Component)this.myCaseSensitiveFilterCheckBox)).addPreferredGap(0).add((Component)this.mySplitPane, -1, 202, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myInjectableBindingLbl).add((Component)this.myInjectableBindings, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myFiltersLabel).add((Component)this.myCloseButton)).add((Component)this.myFiltersToolbar, -2, 25, -2)).addContainerGap()));
        this.myFilterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_TextFilter"));
        this.myFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_TextFilter"));
        this.myFilterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_TextFieldFilter"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_CaseSensitive"));
        this.myCaseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Filters"));
        this.myFiltersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Filters"));
        this.myCloseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Close"));
        this.myCloseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Close"));
        this.myBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Bindings"));
        this.myBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Bindnigs"));
        this.myTypeLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_Type"));
        this.myTypeLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_Type"));
        this.myInjectableBindingLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSN_InjectableBindings"));
        this.myInjectableBindingLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InjectablesPanel.class, (String)"ACSD_InjectableBindnigs"));
    }

    static {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(NbBundle.getMessage(InjectablesPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
    }
}

