/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.ErrorInfoPanel;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private Window window;
    private boolean updatingUrl = false;
    private boolean updatingFields = false;
    private boolean fieldEntryMode = true;
    private boolean userSpecifiedShowUrl = false;
    private final LinkedHashMap<String, UrlField> urlFields = new LinkedHashMap();
    private Set<String> knownConnectionNames = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(NewConnectionPanel.class.getName());
    private JTextField additionalPropsField;
    private JLabel additionalPropsLabel;
    private JTextField databaseField;
    private JLabel databaseLabel;
    private JRadioButton directInputCheckBox;
    private JTextArea directUrlField;
    private JLabel directUrlLabel;
    private JScrollPane directUrlScroll;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JTextField dsnField;
    private JLabel dsnLabel;
    private ErrorInfoPanel errorInfoPanel;
    private JRadioButton fieldInputCheckBox;
    private JTextField hostField;
    private JLabel hostLabel;
    private ButtonGroup inputModeButtonGroup;
    private JLabel inputModelLabel;
    private JTextField instanceField;
    private JLabel instanceLabel;
    private JPanel jPanel1;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField serverNameField;
    private JLabel serverNameLabel;
    private JTextField serviceField;
    private JLabel serviceLabel;
    private JCheckBox showUrlCheckBox;
    private JTextField sidField;
    private JLabel sidLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JTextField tnsField;
    private JLabel tnsLabel;
    private JTextField urlField;
    private JTextField userField;
    private JLabel userLabel;

    private void initFieldMap() {
        this.urlFields.put("<HOST>", new UrlField(this.hostField, this.hostLabel));
        this.urlFields.put("<PORT>", new UrlField(this.portField, this.portLabel));
        this.urlFields.put("<DB>", new UrlField(this.databaseField, this.databaseLabel));
        this.urlFields.put("<SID>", new UrlField(this.sidField, this.sidLabel));
        this.urlFields.put("<SERVICE>", new UrlField(this.serviceField, this.serviceLabel));
        this.urlFields.put("<TNSNAME>", new UrlField(this.tnsField, this.tnsLabel));
        this.urlFields.put("<DSN>", new UrlField(this.dsnField, this.dsnLabel));
        this.urlFields.put("<SERVERNAME>", new UrlField(this.serverNameField, this.serverNameLabel));
        this.urlFields.put("<INSTANCE>", new UrlField(this.instanceField, this.instanceLabel));
        this.urlFields.put("<ADDITIONAL>", new UrlField(this.additionalPropsField, this.additionalPropsLabel));
    }

    public NewConnectionPanel(ConnectionDialogMediator mediator, String driverClass, DatabaseConnection connection) {
        this.mediator = mediator;
        this.connection = connection;
        this.initComponents();
        this.initAccessibility();
        this.initFieldMap();
        this.errorInfoPanel.setup();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), driverClass);
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            @Override
            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            @Override
            public void connectionStep(String step) {
                NewConnectionPanel.this.setProgressMessage(step);
            }

            @Override
            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress(true);
            }

            @Override
            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress(false);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
        this.userField.setText(connection.getUser());
        this.passwordField.setText(connection.getPassword());
        if (!connection.getDisplayName().equals(connection.getName())) {
            this.displayNameField.setText(connection.getDisplayName());
        }
        String driver = connection.getDriver();
        String driverName = connection.getDriverName();
        if (driver != null && driverName != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                Object item = this.templateComboBox.getItemAt(i);
                if (!(item instanceof JdbcUrl)) continue;
                JdbcUrl url = (JdbcUrl)item;
                assert (url.getDriver() != null);
                if (!url.getClassName().equals(driver) || !url.getDriver().getName().equals(driverName)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            new InputAdapter(entry.getValue().getField());
        }
        new InputAdapter(this.templateComboBox);
        new InputAdapter(this.directUrlField);
        this.urlField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                NewConnectionPanel.this.updateFieldsFromUrl();
            }
        });
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }
        });
        this.urlField.setVisible(false);
        this.showUrlCheckBox.setSelected(false);
        this.fieldEntryMode = true;
        this.fieldInputCheckBox.setSelected(true);
        this.setUrlField();
        this.updateFieldsFromUrl();
        this.setUpFields();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }
        };
        this.userField.getDocument().addDocumentListener(docListener);
        this.passwordField.getDocument().addDocumentListener(docListener);
        for (DatabaseConnection existingConnection : ConnectionList.getDefault().getConnections()) {
            this.knownConnectionNames.add(existingConnection.getDisplayName());
        }
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    private void initAccessibility() {
        this.templateLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.displayNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameA11yDesc"));
        this.displayNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameTextFieldA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.userField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordTextFieldA11yName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostTextFieldA11yName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortTextFieldA11yName"));
        this.serverNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameTextFieldA11yName"));
        this.serverNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.databaseField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameTextFieldA11yName"));
        this.databaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.additionalPropsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesTextFieldA11yName"));
        this.additionalPropsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.urlField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLTextFieldA11yName"));
        this.sidField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDTextFieldA11yName"));
        this.sidLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameTextFieldA11yName"));
        this.serviceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameTextFieldA11yName"));
        this.tnsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.dsnField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNTextFieldA11yName"));
        this.dsnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.instanceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameTextFieldA11yName"));
        this.instanceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
    }

    @Override
    public void initializeFocus() {
        this.setFocus();
    }

    private void initComponents() {
        this.inputModeButtonGroup = new ButtonGroup();
        this.showUrlCheckBox = new JCheckBox();
        this.templateComboBox = new JComboBox();
        this.hostField = new JTextField();
        this.templateLabel = new JLabel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.databaseLabel = new JLabel();
        this.databaseField = new JTextField();
        this.sidLabel = new JLabel();
        this.sidField = new JTextField();
        this.serviceLabel = new JLabel();
        this.serviceField = new JTextField();
        this.tnsLabel = new JLabel();
        this.tnsField = new JTextField();
        this.serverNameLabel = new JLabel();
        this.serverNameField = new JTextField();
        this.instanceLabel = new JLabel();
        this.instanceField = new JTextField();
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.dsnLabel = new JLabel();
        this.dsnField = new JTextField();
        this.additionalPropsLabel = new JLabel();
        this.additionalPropsField = new JTextField();
        this.urlField = new JTextField();
        this.passwordCheckBox = new JCheckBox();
        this.errorInfoPanel = new ErrorInfoPanel();
        this.inputModelLabel = new JLabel();
        this.fieldInputCheckBox = new JRadioButton();
        this.directInputCheckBox = new JRadioButton();
        this.directUrlLabel = new JLabel();
        this.directUrlScroll = new JScrollPane();
        this.directUrlField = new JTextArea();
        this.jPanel1 = new JPanel();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.showUrlCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionShowJDBCURL"));
        this.showUrlCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionShowJDBCURLAllyDesc"));
        this.showUrlCheckBox.setMargin(new Insets(3, 0, 1, 1));
        this.showUrlCheckBox.addActionListener(formListener);
        this.templateComboBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverClassComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(formListener);
        this.templateComboBox.addActionListener(formListener);
        this.hostField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.templateLabel.setLabelFor(this.templateComboBox);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDriverName"));
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionHost"));
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPort"));
        this.portField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.databaseLabel.setLabelFor(this.databaseField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDatabase"));
        this.databaseField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.sidLabel.setLabelFor(this.sidField);
        Mnemonics.setLocalizedText((JLabel)this.sidLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionSID"));
        this.sidField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceLabel.setLabelFor(this.serviceField);
        Mnemonics.setLocalizedText((JLabel)this.serviceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServiceName"));
        this.serviceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsLabel.setLabelFor(this.tnsField);
        Mnemonics.setLocalizedText((JLabel)this.tnsLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionTNSName"));
        this.tnsField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.serverNameLabel.setLabelFor(this.serverNameField);
        Mnemonics.setLocalizedText((JLabel)this.serverNameLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServerName"));
        this.serverNameField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.instanceLabel.setLabelFor(this.instanceField);
        Mnemonics.setLocalizedText((JLabel)this.instanceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionInstanceName"));
        this.instanceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
        this.displayNameLabel.setLabelFor(this.displayNameField);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDisplayName"));
        this.displayNameField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameA11yDesc"));
        this.userLabel.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionUserName"));
        this.userField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPassword"));
        this.passwordField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.dsnLabel.setLabelFor(this.dsnField);
        Mnemonics.setLocalizedText((JLabel)this.dsnLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDSN"));
        this.dsnField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.additionalPropsLabel.setLabelFor(this.additionalPropsField);
        Mnemonics.setLocalizedText((JLabel)this.additionalPropsLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionAdditionalProperties"));
        this.additionalPropsField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.urlField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLA11yDesc"));
        this.urlField.addActionListener(formListener);
        this.urlField.addFocusListener(formListener);
        this.urlField.addKeyListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionRememberPasswordA11yDesc"));
        this.passwordCheckBox.setMargin(new Insets(3, 0, 1, 1));
        this.inputModelLabel.setLabelFor(this.fieldInputCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.inputModelLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewCOnnectionInputMode"));
        this.inputModeButtonGroup.add(this.fieldInputCheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.fieldInputCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionFieldEntryMode"));
        this.fieldInputCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionFieldEntryModeA11yDesc"));
        this.fieldInputCheckBox.addActionListener(formListener);
        this.inputModeButtonGroup.add(this.directInputCheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.directInputCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDirectUrlEntryMode"));
        this.directInputCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDirectUrlEntryModeA11yDesc"));
        this.directInputCheckBox.addActionListener(formListener);
        this.directUrlLabel.setLabelFor(this.directUrlField);
        Mnemonics.setLocalizedText((JLabel)this.directUrlLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDirectURL"));
        this.directUrlField.setColumns(20);
        this.directUrlField.setLineWrap(true);
        this.directUrlField.setRows(5);
        this.directUrlField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLA11yDesc"));
        this.directUrlScroll.setViewportView(this.directUrlField);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 722, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputModelLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.displayNameLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.showUrlCheckBox, GroupLayout.Alignment.LEADING, -2, 132, Short.MAX_VALUE).addComponent(this.directUrlLabel, GroupLayout.Alignment.LEADING).addComponent(this.templateLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.userLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.instanceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serverNameLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.dsnLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.tnsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serviceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.sidLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.databaseLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.portLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hostLabel, GroupLayout.Alignment.LEADING, -2, 121, -2)).addComponent(this.additionalPropsLabel, -2, 117, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fieldInputCheckBox).addGap(18, 18, 18).addComponent(this.directInputCheckBox)).addComponent(this.passwordCheckBox, -2, 256, -2).addComponent(this.templateComboBox, 0, 550, Short.MAX_VALUE).addComponent(this.hostField, -1, 550, Short.MAX_VALUE).addComponent(this.portField, -1, 550, Short.MAX_VALUE).addComponent(this.databaseField, -1, 550, Short.MAX_VALUE).addComponent(this.sidField, -1, 550, Short.MAX_VALUE).addComponent(this.serviceField, -1, 550, Short.MAX_VALUE).addComponent(this.tnsField, -1, 550, Short.MAX_VALUE).addComponent(this.dsnField, -1, 550, Short.MAX_VALUE).addComponent(this.serverNameField, -1, 550, Short.MAX_VALUE).addComponent(this.instanceField, -1, 550, Short.MAX_VALUE).addComponent(this.userField, -1, 550, Short.MAX_VALUE).addComponent(this.passwordField, -1, 550, Short.MAX_VALUE).addComponent(this.displayNameField, -1, 550, Short.MAX_VALUE).addComponent(this.additionalPropsField, -1, 550, Short.MAX_VALUE).addComponent(this.urlField, -1, 550, Short.MAX_VALUE).addComponent(this.directUrlScroll, -1, 550, Short.MAX_VALUE))).addComponent(this.errorInfoPanel, -1, 722, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputModelLabel).addComponent(this.fieldInputCheckBox).addComponent(this.directInputCheckBox)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateLabel).addComponent(this.templateComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.hostField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseLabel).addComponent(this.databaseField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sidLabel).addComponent(this.sidField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serviceLabel).addComponent(this.serviceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tnsLabel).addComponent(this.tnsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dsnLabel).addComponent(this.dsnField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverNameLabel).addComponent(this.serverNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instanceLabel).addComponent(this.instanceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLabel).addComponent(this.displayNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.additionalPropsField, -2, -1, -2).addComponent(this.additionalPropsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showUrlCheckBox).addComponent(this.urlField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directUrlLabel).addComponent(this.directUrlScroll, -2, 84, -2)).addGap(8, 8, 8).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorInfoPanel, -2, -1, -2).addContainerGap(121, Short.MAX_VALUE)));
    }

    private void urlFieldActionPerformed(ActionEvent evt) {
    }

    private void urlFieldFocusLost(FocusEvent evt) {
    }

    private void urlFieldKeyPressed(KeyEvent evt) {
    }

    private void templateComboBoxActionPerformed(ActionEvent evt) {
    }

    private void templateComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Object item = this.templateComboBox.getSelectedItem();
            if (item != null && !(item instanceof JdbcUrl)) {
                return;
            }
            JdbcUrl jdbcurl = (JdbcUrl)item;
            if (!jdbcurl.isParseUrl()) {
                this.fieldInputCheckBox.setVisible(false);
                this.inputModelLabel.setVisible(false);
                this.directInputCheckBox.setVisible(false);
                if (this.fieldEntryMode) {
                    this.directInputCheckBox.setSelected(true);
                    this.updateInputMode(false);
                }
            } else {
                this.fieldInputCheckBox.setVisible(true);
                this.inputModelLabel.setVisible(true);
                this.directInputCheckBox.setVisible(true);
                this.directUrlField.setText("");
                this.setUpFields();
            }
            this.updateUrlFromFields();
            this.fireChange();
        }
    }

    private void fieldInputCheckBoxActionPerformed(ActionEvent evt) {
        this.updateInputMode(false);
    }

    private void directInputCheckBoxActionPerformed(ActionEvent evt) {
        this.updateInputMode(true);
    }

    private void showUrlCheckBoxActionPerformed(ActionEvent evt) {
        this.showUrl();
    }

    private void showUrl() {
        this.userSpecifiedShowUrl = this.showUrlCheckBox.isSelected();
        if (this.showUrlCheckBox.isSelected()) {
            this.updateUrlFromFields();
        }
        this.urlField.setVisible(this.showUrlCheckBox.isSelected());
        this.resize();
    }

    public void setConnectionInfo() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url != null) {
            JDBCDriver driver = url.getDriver();
            assert (driver != null);
            this.connection.setDriverName(driver.getName());
            this.connection.setDriver(driver.getClassName());
        }
        if (this.fieldEntryMode) {
            this.connection.setDatabase(this.urlField.getText());
        } else {
            this.connection.setDatabase(this.directUrlField.getText());
        }
        this.connection.setUser(this.userField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
        this.connection.setDisplayName(this.displayNameField.getText());
    }

    private void resize() {
        this.revalidate();
        if (this.window != null) {
            this.window.pack();
        }
    }

    private void updateInputMode(boolean copyUrl) {
        this.fieldEntryMode = this.fieldInputCheckBox.isSelected();
        if (copyUrl) {
            this.directUrlField.setText(this.urlField.getText());
        }
        this.setUpFields();
    }

    private void setUpFields() {
        Object item = this.templateComboBox.getSelectedItem();
        if (item != null && !(item instanceof JdbcUrl)) {
            return;
        }
        JdbcUrl jdbcurl = (JdbcUrl)item;
        if (jdbcurl == null) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
            this.urlField.setVisible(false);
            this.checkValid();
            this.resize();
            return;
        }
        this.userField.setVisible(true);
        this.userLabel.setVisible(true);
        this.passwordField.setVisible(true);
        this.passwordLabel.setVisible(true);
        this.passwordCheckBox.setVisible(true);
        if (this.fieldEntryMode) {
            this.directUrlLabel.setVisible(false);
            this.directUrlScroll.setVisible(false);
            this.showUrlCheckBox.setVisible(true);
            this.urlField.setVisible(this.showUrlCheckBox.isSelected());
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(jdbcurl.supportsToken(entry.getKey()));
                entry.getValue().getLabel().setVisible(jdbcurl.supportsToken(entry.getKey()));
            }
            if (!jdbcurl.isParseUrl()) {
                this.showUrlCheckBox.setEnabled(false);
                this.showUrlCheckBox.setSelected(true);
                this.urlField.setVisible(true);
                this.setUrlField();
            } else {
                this.showUrlCheckBox.setEnabled(true);
                this.showUrlCheckBox.setSelected(this.userSpecifiedShowUrl);
                this.showUrl();
            }
        } else {
            this.directUrlLabel.setVisible(true);
            this.directUrlScroll.setVisible(true);
            this.showUrlCheckBox.setVisible(false);
            this.urlField.setVisible(false);
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
        }
        this.displayNameField.setVisible(true);
        this.displayNameLabel.setVisible(true);
        this.setFocus();
        this.checkValid();
        this.resize();
    }

    private void setFocus() {
        if (this.templateComboBox.getItemCount() <= 1) {
            this.templateComboBox.requestFocusInWindow();
            return;
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            if (!entry.getValue().getField().isVisible()) continue;
            entry.getValue().getField().requestFocusInWindow();
            return;
        }
        this.userField.requestFocusInWindow();
    }

    private JdbcUrl getSelectedJdbcUrl() {
        Object item = this.templateComboBox.getSelectedItem();
        if (!(item instanceof JdbcUrl)) {
            return null;
        }
        return (JdbcUrl)item;
    }

    private void setUrlField() {
        if (!this.connection.getDatabase().equals("")) {
            this.urlField.setText(this.connection.getDatabase());
            return;
        }
        JdbcUrl jdbcurl = this.getSelectedJdbcUrl();
        if (jdbcurl == null) {
            this.urlField.setText("");
            return;
        }
        if (jdbcurl.isParseUrl()) {
            this.updateUrlFromFields();
        } else {
            this.urlField.setText(jdbcurl.getUrlTemplate());
        }
    }

    private String getPassword() {
        String tempPassword = new String(this.passwordField.getPassword());
        String password = tempPassword.length() > 0 ? tempPassword : null;
        return password;
    }

    public String getTitle() {
        return NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NewConnectionPanel.class, (String)"ConnectionProgress_Connecting"));
                NewConnectionPanel.this.progressHandle.start();
                NewConnectionPanel.this.enableInput(false);
            }
        });
    }

    private void setProgressMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.setDisplayName(message);
                }
            }
        });
    }

    public void terminateProgress() {
        this.stopProgress(false);
    }

    private void stopProgress(boolean connected) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.finish();
                    NewConnectionPanel.this.enableInput(true);
                }
            }
        });
    }

    private void enableInput(boolean enable) {
        this.displayNameField.setEnabled(enable);
        this.fieldInputCheckBox.setEnabled(enable);
        this.directInputCheckBox.setEnabled(enable);
        this.templateComboBox.setEnabled(enable);
        this.userField.setEnabled(enable);
        this.passwordField.setEnabled(enable);
        this.passwordCheckBox.setEnabled(enable);
        this.showUrlCheckBox.setEnabled(enable);
        this.urlField.setEnabled(enable);
        this.directUrlField.setEnabled(enable);
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().setEnabled(enable);
        }
    }

    private void resetProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.setDisplayName("");
        }
    }

    private void fireChange() {
        this.mediator.closeConnection();
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }

    private void updateUrlFromFields() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url == null || !url.isParseUrl()) {
            return;
        }
        if (!this.updatingUrl) {
            this.updatingFields = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                url.put(entry.getKey(), entry.getValue().getField().getText());
            }
            this.urlField.setText(url.getUrl());
            this.updatingFields = false;
        }
        this.checkValid();
    }

    private void checkValid() {
        if (this.fieldEntryMode) {
            JdbcUrl url = this.getSelectedJdbcUrl();
            boolean requiredFieldMissing = false;
            if (url == null) {
                this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SelectADriver"), false);
            } else if (url != null && url.isParseUrl()) {
                for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                    if (!url.requiresToken(entry.getKey()) || !this.isEmpty(entry.getValue().getField().getText())) continue;
                    requiredFieldMissing = true;
                    this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.ERR_FieldRequired", (Object)entry.getValue().getLabel().getText()), false);
                }
                if (!requiredFieldMissing) {
                    this.clearError();
                }
            } else if (this.isEmpty(this.urlField.getText())) {
                this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SpecifyURL"), false);
            } else {
                this.clearError();
            }
        } else if (this.directUrlField.getText().trim().length() > 0) {
            this.clearError();
        } else {
            this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SpecifyURL"), false);
        }
        if (this.knownConnectionNames.contains(this.displayNameField.getText().trim())) {
            this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_DuplicateDisplayName"), false);
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    private void updateFieldsFromUrl() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url == null) {
            return;
        }
        if (this.updatingFields) {
            return;
        }
        try {
            url.setUrl(this.urlField.getText());
            this.clearError();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        if (url.isParseUrl()) {
            this.updatingUrl = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setText((String)url.get(entry.getKey()));
            }
            this.updatingUrl = false;
        }
    }

    private void clearError() {
        this.errorInfoPanel.clear();
        this.mediator.setValid(true);
    }

    private void displayError(String message, boolean isError) {
        this.errorInfoPanel.set(message, isError);
        this.mediator.setValid(false);
    }

    private class InputAdapter
    implements DocumentListener,
    ListDataListener {
        public InputAdapter(JTextField source) {
            source.getDocument().addDocumentListener(this);
        }

        public InputAdapter(JComboBox source) {
            source.getModel().addListDataListener(this);
        }

        public InputAdapter(JTextArea source) {
            source.getDocument().addDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }
    }

    private class UrlField {
        private final JTextField field;
        private final JLabel label;

        public UrlField(JTextField field, JLabel label) {
            this.field = field;
            this.label = label;
        }

        public JTextField getField() {
            return this.field;
        }

        public JLabel getLabel() {
            return this.label;
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener,
    KeyListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.showUrlCheckBox) {
                NewConnectionPanel.this.showUrlCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.fieldInputCheckBox) {
                NewConnectionPanel.this.fieldInputCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.directInputCheckBox) {
                NewConnectionPanel.this.directInputCheckBoxActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldFocusLost(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(evt);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldKeyPressed(evt);
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }
    }
}

