/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.actions;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.swingapp.ActionPropertyEditorPanel;

public class AcceleratorKeyListener
implements KeyListener {
    private int currentKeyCode = 0;
    private KeyStroke keyStroke = null;
    private ActionPropertyEditorPanel panel;

    public AcceleratorKeyListener(ActionPropertyEditorPanel actionPropertyEditorPanel) {
        this.panel = actionPropertyEditorPanel;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
        JTextField jTextField = (JTextField)keyEvent.getSource();
        switch (keyEvent.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return;
            }
        }
        this.setModifiers(keyEvent);
        String string = this.toString(keyEvent);
        if (!jTextField.getText().equals(string)) {
            jTextField.setText(string);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void setCurrentKeyStroke(KeyStroke keyStroke) {
        this.clearFields();
        this.keyStroke = keyStroke;
        if (this.keyStroke != null) {
            this.currentKeyCode = this.keyStroke.getKeyCode();
            this.panel.acceleratorText.setText(KeyEvent.getKeyText(this.currentKeyCode));
            this.panel.shiftCheckbox.setSelected((this.keyStroke.getModifiers() & 0x40) > 0);
            this.panel.controlCheckbox.setSelected((this.keyStroke.getModifiers() & 0x80) > 0);
            this.panel.altCheckbox.setSelected((this.keyStroke.getModifiers() & 0x200) > 0);
            this.panel.metaCheckbox.setSelected((this.keyStroke.getModifiers() & 0x100) > 0);
        }
    }

    public KeyStroke getCurrentKeyStroke() {
        return this.keyStroke;
    }

    public void clearFields() {
        this.panel.shiftCheckbox.setSelected(false);
        this.panel.controlCheckbox.setSelected(false);
        this.panel.altCheckbox.setSelected(false);
        this.panel.metaCheckbox.setSelected(false);
        this.panel.acceleratorText.setText("");
        this.keyStroke = null;
    }

    public void setEnabled(boolean bl) {
        this.panel.shiftCheckbox.setEnabled(bl);
        this.panel.controlCheckbox.setEnabled(bl);
        this.panel.altCheckbox.setEnabled(bl);
        this.panel.metaCheckbox.setEnabled(bl);
        this.panel.acceleratorText.setEnabled(bl);
    }

    public void updateFromModifiers() {
        int n = 0;
        if (this.panel.shiftCheckbox.isSelected()) {
            n |= 1;
        }
        if (this.panel.altCheckbox.isSelected()) {
            n |= 8;
        }
        if (this.panel.controlCheckbox.isSelected()) {
            n |= 2;
        }
        if (this.panel.metaCheckbox.isSelected()) {
            n |= 4;
        }
        this.keyStroke = KeyStroke.getKeyStroke(this.currentKeyCode, n);
    }

    private void setModifiers(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown()) {
            this.panel.shiftCheckbox.setSelected(keyEvent.isShiftDown());
            this.panel.controlCheckbox.setSelected(keyEvent.isControlDown());
            this.panel.altCheckbox.setSelected(keyEvent.isAltDown());
            this.panel.metaCheckbox.setSelected(keyEvent.isMetaDown());
        }
    }

    private String toString(KeyEvent keyEvent) {
        if (!(keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown())) {
            int n = this.panel.altCheckbox.isSelected() ? 8 : 0;
            n |= this.panel.controlCheckbox.isSelected() ? 2 : 0;
            n |= this.panel.metaCheckbox.isSelected() ? 4 : 0;
            keyEvent = new KeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n |= this.panel.shiftCheckbox.isSelected() ? 1 : 0, keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
        this.keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        this.currentKeyCode = keyEvent.getKeyCode();
        return KeyEvent.getKeyText(this.currentKeyCode);
    }
}

